/*
 * Decompiled with CFR 0.152.
 */
package io.elasticjob.lite.lifecycle.restful;

import io.elasticjob.lite.lifecycle.restful.RestfulException;
import io.elasticjob.lite.util.json.GsonFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

@Provider
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public final class GsonJsonProvider
implements MessageBodyWriter<Object>,
MessageBodyReader<Object> {
    private static final String UTF_8 = "UTF-8";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) {
        try (InputStreamReader streamReader = new InputStreamReader(entityStream, UTF_8);){
            Object object = GsonFactory.getGson().fromJson((Reader)streamReader, type.equals(genericType) ? type : genericType);
            return object;
        }
        catch (IOException ex) {
            throw new RestfulException(ex);
        }
    }

    public void writeTo(Object object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        try (OutputStreamWriter writer = new OutputStreamWriter(entityStream, UTF_8);){
            GsonFactory.getGson().toJson(object, type.equals(genericType) ? type : genericType, (Appendable)writer);
        }
        catch (IOException ex) {
            throw new RestfulException(ex);
        }
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public long getSize(Object object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }
}

