/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.springboot;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.springframework.util.StreamUtils;

public class JakartaSupport {
    private JakartaSupport() {
    }

    public static boolean useJakarta(ClassLoader classLoader) {
        try {
            classLoader.loadClass("jakarta.servlet.http.HttpServlet");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static Class loadJavaxOrJakartaClass(ClassLoader classLoader, String classname) {
        try {
            if (JakartaSupport.useJakarta(classLoader)) {
                return new JakartaClassLoader(classLoader, classname).loadClass(classname);
            }
            return classLoader.loadClass(classname);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static String javax2jakarta(String s) {
        if (s.startsWith("javax/servlet/") || s.startsWith("javax/websocket/")) {
            return "jakarta" + s.substring("javax".length());
        }
        return s.replace("Ljavax/websocket/", "Ljakarta/websocket/").replace("Ljavax/servlet/", "Ljakarta/servlet/");
    }

    private static class JakartaClassLoader
    extends ClassLoader {
        private final String patchedClassName;

        public JakartaClassLoader(ClassLoader classLoader, String patchedClassName) {
            super(classLoader);
            this.patchedClassName = patchedClassName;
        }

        private byte[] loadPatchedClass(String classname) {
            URL classUrl = this.getResource(classname.replace('.', '/') + ".class");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream dataOut = new DataOutputStream(out);
            try (DataInputStream in = new DataInputStream(classUrl.openStream());){
                long magicMajorMinor = in.readLong();
                dataOut.writeLong(magicMajorMinor);
                int constCount = in.readUnsignedShort();
                dataOut.writeShort(constCount);
                byte[] b3 = new byte[3];
                block14: for (int i = 0; i < constCount - 1; ++i) {
                    byte constType = in.readByte();
                    dataOut.writeByte(constType);
                    switch (constType) {
                        case 7: 
                        case 8: 
                        case 16: 
                        case 19: 
                        case 20: {
                            int b2 = in.readUnsignedShort();
                            dataOut.writeShort(b2);
                            continue block14;
                        }
                        case 3: 
                        case 4: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 17: 
                        case 18: {
                            int b4 = in.readInt();
                            dataOut.writeInt(b4);
                            continue block14;
                        }
                        case 5: 
                        case 6: {
                            long b8 = in.readLong();
                            dataOut.writeLong(b8);
                            continue block14;
                        }
                        case 1: {
                            String utf = in.readUTF();
                            utf = JakartaSupport.javax2jakarta(utf);
                            dataOut.writeUTF(utf);
                            continue block14;
                        }
                        case 15: {
                            in.readFully(b3);
                            dataOut.write(b3);
                            continue block14;
                        }
                        default: {
                            throw new RuntimeException("Unknown constant tag: " + constType);
                        }
                    }
                }
                StreamUtils.copy((InputStream)in, (OutputStream)dataOut);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return out.toByteArray();
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if ((name.equals(this.patchedClassName) || name.startsWith(this.patchedClassName + '$')) && this.findLoadedClass(name) == null) {
                byte[] bytecode = this.loadPatchedClass(name);
                Class<?> res = this.defineClass(name, bytecode, 0, bytecode.length);
                if (resolve) {
                    this.resolveClass(res);
                }
                return res;
            }
            return super.loadClass(name, resolve);
        }
    }
}

