/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.springboot;

import com.logviewer.springboot.JakartaSupport;
import java.lang.reflect.Constructor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;
import org.springframework.web.socket.server.standard.ServerEndpointExporter;
import org.springframework.web.socket.server.standard.ServerEndpointRegistration;

@Configuration
@ConditionalOnClass(value={ServerEndpointRegistration.class})
@ConditionalOnProperty(name={"log-viewer.use-web-socket"}, matchIfMissing=true)
@PropertySource(value={"classpath:log-viewer-springboot.properties"})
public class LogViewerWebsocketConfig {
    @Bean
    public ServerEndpointRegistration logViewerWebSocket(Environment environment) {
        String path = environment.getRequiredProperty("log-viewer.websocket.path");
        if (!path.startsWith("/")) {
            path = '/' + path;
        }
        String logServletPath = environment.getProperty("log-viewer.url-mapping", "/logs/*");
        logServletPath = logServletPath.replaceAll("/+\\**$", "");
        Class endpointCls = JakartaSupport.loadJavaxOrJakartaClass(LogViewerWebsocketConfig.class.getClassLoader(), "com.logviewer.web.LogViewerWebsocket");
        try {
            Constructor constructor = ServerEndpointRegistration.class.getConstructor(String.class, Class.class);
            return (ServerEndpointRegistration)constructor.newInstance(logServletPath + path, endpointCls);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @ConditionalOnMissingBean(value={ServerEndpointExporter.class})
    @Bean
    public ServerEndpointExporter endpointExporter() {
        return new ServerEndpointExporter();
    }
}

