/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.maven;

import io.spring.gradle.dependencymanagement.DependencyManagementConfigurationContainer;
import io.spring.gradle.dependencymanagement.maven.PomDependencyModelResolver;
import io.spring.gradle.dependencymanagement.maven.ProjectPropertiesModelInterpolator;
import io.spring.gradle.dependencymanagement.maven.RelaxedModelValidator;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.Model;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.building.DefaultModelBuilder;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.building.DefaultModelBuilderFactory;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.building.DefaultModelBuildingRequest;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.building.FileModelSource;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.building.ModelBuildingException;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.building.ModelBuildingResult;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.building.ModelProblem;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.resolution.ModelResolver;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gradle.api.Project;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EffectiveModelBuilder {
    private final Logger log = LoggerFactory.getLogger(EffectiveModelBuilder.class);
    private final Project project;
    private final ModelResolver modelResolver;

    public EffectiveModelBuilder(Project project, DependencyManagementConfigurationContainer configurationContainer) {
        this.project = project;
        this.modelResolver = new PomDependencyModelResolver(project, configurationContainer);
    }

    public Model buildModel(File pom) {
        return this.buildModel(pom, Collections.emptyMap());
    }

    public Model buildModel(File pom, Map<String, String> properties) {
        DefaultModelBuildingRequest request = new DefaultModelBuildingRequest();
        request.setSystemProperties(System.getProperties());
        request.setModelSource(new FileModelSource(pom));
        request.setModelResolver(this.modelResolver);
        try {
            ModelBuildingResult result = this.createModelBuilder(this.project, properties).build(request);
            List<ModelProblem> errors = this.extractErrors(result.getProblems());
            if (errors.isEmpty()) {
                return result.getEffectiveModel();
            }
            this.reportErrors(errors, pom);
        }
        catch (ModelBuildingException ex) {
            this.reportErrors(this.extractErrors(ex.getProblems()), pom);
        }
        return null;
    }

    private List<ModelProblem> extractErrors(List<ModelProblem> problems) {
        ArrayList<ModelProblem> errors = new ArrayList<ModelProblem>();
        for (ModelProblem problem : problems) {
            if (problem.getSeverity() != ModelProblem.Severity.ERROR) continue;
            errors.add(problem);
        }
        return errors;
    }

    private void reportErrors(List<ModelProblem> errors, File file) {
        StringBuilder message = new StringBuilder("Processing of " + file + " failed:");
        for (ModelProblem error : errors) {
            message.append("\n    " + error.getMessage() + " in " + error.getModelId());
        }
        this.log.error(message.toString());
    }

    private DefaultModelBuilder createModelBuilder(Project project, Map<String, String> properties) {
        DefaultModelBuilder modelBuilder = new DefaultModelBuilderFactory().newInstance();
        modelBuilder.setModelInterpolator(new ProjectPropertiesModelInterpolator(project, properties));
        modelBuilder.setModelValidator(new RelaxedModelValidator());
        return modelBuilder;
    }
}

