/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.internal;

import groovy.util.Node;
import io.spring.gradle.dependencymanagement.internal.DependencyManagement;
import io.spring.gradle.dependencymanagement.internal.DependencyManagementSettings;
import io.spring.gradle.dependencymanagement.internal.pom.Coordinates;
import io.spring.gradle.dependencymanagement.internal.pom.Dependency;
import io.spring.gradle.dependencymanagement.internal.pom.Pom;
import io.spring.gradle.dependencymanagement.internal.pom.PomReference;
import io.spring.gradle.dependencymanagement.internal.pom.PomResolver;
import io.spring.gradle.dependencymanagement.internal.properties.ProjectPropertySource;
import io.spring.gradle.dependencymanagement.internal.properties.PropertySource;
import io.spring.gradle.dependencymanagement.maven.PomDependencyManagementConfigurer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.XmlProvider;

public class StandardPomDependencyManagementConfigurer
implements PomDependencyManagementConfigurer {
    private static final String NODE_NAME_DEPENDENCY_MANAGEMENT = "dependencyManagement";
    private static final String NODE_NAME_DEPENDENCIES = "dependencies";
    private static final String NODE_NAME_DEPENDENCY = "dependency";
    private static final String NODE_NAME_EXCLUSION = "exclusion";
    private static final String NODE_NAME_GROUP_ID = "groupId";
    private static final String NODE_NAME_ARTIFACT_ID = "artifactId";
    private static final String NODE_NAME_EXCLUSIONS = "exclusions";
    private static final String NODE_NAME_VERSION = "version";
    private static final String NODE_NAME_SCOPE = "scope";
    private static final String NODE_NAME_TYPE = "type";
    private final DependencyManagement dependencyManagement;
    private final DependencyManagementSettings.PomCustomizationSettings settings;
    private final PomResolver pomResolver;
    private final Project project;

    public StandardPomDependencyManagementConfigurer(DependencyManagement dependencyManagement, DependencyManagementSettings.PomCustomizationSettings settings, PomResolver pomResolver, Project project) {
        this.dependencyManagement = dependencyManagement;
        this.settings = settings;
        this.pomResolver = pomResolver;
        this.project = project;
    }

    @Override
    public void execute(XmlProvider xmlProvider) {
        this.configurePom(xmlProvider.asNode());
    }

    @Override
    public void configurePom(Node pom) {
        if (this.settings.isEnabled()) {
            this.doConfigurePom(pom);
        }
    }

    private void doConfigurePom(Node pom) {
        Node dependenciesNode;
        Node dependencyManagementNode = this.findChild(pom, NODE_NAME_DEPENDENCY_MANAGEMENT);
        if (dependencyManagementNode == null) {
            dependencyManagementNode = pom.appendNode((Object)NODE_NAME_DEPENDENCY_MANAGEMENT);
        }
        if ((dependenciesNode = this.findChild(dependencyManagementNode, NODE_NAME_DEPENDENCIES)) == null) {
            dependenciesNode = dependencyManagementNode.appendNode((Object)NODE_NAME_DEPENDENCIES);
        }
        this.configureBomImports(dependenciesNode);
        this.configureDependencies(dependenciesNode);
    }

    private Node findChild(Node node, String name) {
        for (Object childObject : node.children()) {
            if (!(childObject instanceof Node) || !((Node)childObject).name().equals(name)) continue;
            return (Node)childObject;
        }
        return null;
    }

    private void configureBomImports(Node dependencies) {
        List<PomReference> bomReferences = this.dependencyManagement.getImportedBomReferences();
        List<Pom> resolvedWithoutPropertiesBoms = this.pomResolver.resolvePoms(bomReferences, new PropertySource(){

            @Override
            public Object getProperty(String name) {
                return null;
            }
        });
        HashMap<String, Dependency> managedDependencies = new HashMap<String, Dependency>();
        for (Pom pomWithoutProperty : resolvedWithoutPropertiesBoms) {
            for (Dependency dependency : pomWithoutProperty.getManagedDependencies()) {
                managedDependencies.put(this.createId(dependency), dependency);
            }
        }
        ArrayList<Dependency> overrides = new ArrayList<Dependency>();
        for (Pom pom : this.pomResolver.resolvePoms(bomReferences, new ProjectPropertySource(this.project))) {
            for (Dependency dependency : pom.getManagedDependencies()) {
                Dependency other = (Dependency)managedDependencies.get(this.createId(dependency));
                if (dependency.getCoordinates().getVersion().equals(other.getCoordinates().getVersion())) continue;
                overrides.add(dependency);
            }
        }
        for (Dependency override : overrides) {
            this.appendDependencyNode(dependencies, override.getCoordinates(), override.getScope(), override.getType());
        }
        for (Pom resolvedBom : this.dependencyManagement.getImportedBoms()) {
            this.addImport(dependencies, resolvedBom);
        }
    }

    private String createId(Dependency dependency) {
        return String.format("%s:%s:%s:%s:%s", dependency.getCoordinates().getGroupId(), dependency.getCoordinates().getArtifactId(), dependency.getScope(), dependency.getType(), dependency.getClassifier());
    }

    private void addImport(Node dependencies, Pom importedBom) {
        this.appendDependencyNode(dependencies, importedBom.getCoordinates(), "import", "pom");
    }

    private Node appendDependencyNode(Node parent, Coordinates coordinates, String scope, String type) {
        Node dependencyNode = parent.appendNode((Object)NODE_NAME_DEPENDENCY);
        dependencyNode.appendNode((Object)NODE_NAME_GROUP_ID, (Object)coordinates.getGroupId());
        dependencyNode.appendNode((Object)NODE_NAME_ARTIFACT_ID, (Object)coordinates.getArtifactId());
        dependencyNode.appendNode((Object)NODE_NAME_VERSION, (Object)coordinates.getVersion());
        if (scope != null) {
            dependencyNode.appendNode((Object)NODE_NAME_SCOPE, (Object)scope);
        }
        if (!"jar".equals(type)) {
            dependencyNode.appendNode((Object)NODE_NAME_TYPE, (Object)type);
        }
        return dependencyNode;
    }

    private void configureDependencies(Node dependencies) {
        for (Dependency dependency : this.dependencyManagement.getManagedDependencies()) {
            Node dependencyNode = this.appendDependencyNode(dependencies, dependency.getCoordinates(), dependency.getScope(), dependency.getType());
            if (dependency.getExclusions().isEmpty()) continue;
            Node exclusionsNode = dependencyNode.appendNode((Object)NODE_NAME_EXCLUSIONS);
            for (String exclusion : dependency.getExclusions()) {
                String[] exclusionComponents = exclusion.split(":");
                Node exclusionNode = exclusionsNode.appendNode((Object)NODE_NAME_EXCLUSION);
                exclusionNode.appendNode((Object)NODE_NAME_GROUP_ID, (Object)exclusionComponents[0]);
                exclusionNode.appendNode((Object)NODE_NAME_ARTIFACT_ID, (Object)exclusionComponents[1]);
            }
        }
    }
}

