/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.internal.maven;

import io.spring.gradle.dependencymanagement.internal.DependencyManagementConfigurationContainer;
import io.spring.gradle.dependencymanagement.internal.maven.EffectiveModelBuilder;
import io.spring.gradle.dependencymanagement.internal.maven.PlatformCategoryAttributeConfigurer;
import io.spring.gradle.dependencymanagement.internal.pom.Coordinates;
import io.spring.gradle.dependencymanagement.internal.pom.Pom;
import io.spring.gradle.dependencymanagement.internal.pom.PomReference;
import io.spring.gradle.dependencymanagement.internal.pom.PomResolver;
import io.spring.gradle.dependencymanagement.internal.properties.CompositePropertySource;
import io.spring.gradle.dependencymanagement.internal.properties.MapPropertySource;
import io.spring.gradle.dependencymanagement.internal.properties.PropertySource;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.Dependency;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.Exclusion;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.Model;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.specs.Specs;

public class MavenPomResolver
implements PomResolver {
    private final PlatformCategoryAttributeConfigurer attributeConfigurer = new PlatformCategoryAttributeConfigurer();
    private final DependencyManagementConfigurationContainer configurationContainer;
    private final EffectiveModelBuilder effectiveModelBuilder;
    private final DependencyHandler dependencyHandler;

    public MavenPomResolver(Project project, DependencyManagementConfigurationContainer configurationContainer) {
        this.configurationContainer = configurationContainer;
        this.effectiveModelBuilder = new EffectiveModelBuilder(project, configurationContainer, this.attributeConfigurer);
        this.dependencyHandler = project.getDependencies();
    }

    @Override
    public List<Pom> resolvePomsLeniently(List<PomReference> pomReferences) {
        return this.createPoms(this.createConfiguration(pomReferences).getResolvedConfiguration().getLenientConfiguration().getArtifacts(Specs.SATISFIES_ALL), pomReferences, new MapPropertySource(Collections.emptyMap()));
    }

    @Override
    public List<Pom> resolvePoms(List<PomReference> pomReferences, PropertySource properties) {
        List<PomReference> deduplicatedPomReferences = this.deduplicate(pomReferences);
        return this.createPoms(this.createConfiguration(deduplicatedPomReferences).getResolvedConfiguration().getResolvedArtifacts(), deduplicatedPomReferences, properties);
    }

    private List<PomReference> deduplicate(List<PomReference> pomReferences) {
        ArrayList<PomReference> deduplicatedReferences = new ArrayList<PomReference>();
        HashSet<String> seen = new HashSet<String>();
        for (int i = pomReferences.size() - 1; i >= 0; --i) {
            PomReference pomReference = pomReferences.get(i);
            if (!seen.add(this.createKey(pomReference.getCoordinates().getGroupId(), pomReference.getCoordinates().getArtifactId()))) continue;
            deduplicatedReferences.add(pomReference);
        }
        Collections.reverse(deduplicatedReferences);
        return deduplicatedReferences;
    }

    private Configuration createConfiguration(List<PomReference> pomReferences) {
        Configuration configuration = this.configurationContainer.newConfiguration(new org.gradle.api.artifacts.Dependency[0]);
        for (PomReference pomReference : pomReferences) {
            Coordinates coordinates = pomReference.getCoordinates();
            org.gradle.api.artifacts.Dependency dependency = this.dependencyHandler.create((Object)(coordinates.getGroupId() + ":" + coordinates.getArtifactId() + ":" + coordinates.getVersion() + "@pom"));
            this.attributeConfigurer.configureCategoryAttribute(dependency);
            configuration.getDependencies().add((Object)dependency);
        }
        return configuration;
    }

    private List<Pom> createPoms(Set<ResolvedArtifact> resolvedArtifacts, List<PomReference> pomReferences, PropertySource properties) {
        HashMap<String, PomReference> referencesById = new HashMap<String, PomReference>();
        for (PomReference pomReference : pomReferences) {
            referencesById.put(this.createKey(pomReference.getCoordinates().getGroupId(), pomReference.getCoordinates().getArtifactId()), pomReference);
        }
        ArrayList<Pom> resolvedPoms = new ArrayList<Pom>();
        for (ResolvedArtifact resolvedArtifact : resolvedArtifacts) {
            ModuleVersionIdentifier id = resolvedArtifact.getModuleVersion().getId();
            PomReference reference = (PomReference)referencesById.get(this.createKey(id.getGroup(), id.getName()));
            CompositePropertySource allProperties = new CompositePropertySource(reference.getProperties(), properties);
            resolvedPoms.add(this.createPom(resolvedArtifact.getFile(), allProperties));
        }
        return resolvedPoms;
    }

    private Pom createPom(File file, PropertySource properties) {
        Model effectiveModel = this.effectiveModelBuilder.buildModel(file, properties);
        Coordinates coordinates = new Coordinates(effectiveModel.getGroupId(), effectiveModel.getArtifactId(), effectiveModel.getVersion());
        return new Pom(coordinates, this.getManagedDependencies(effectiveModel), this.getDependencies(effectiveModel), this.asMap(effectiveModel.getProperties()));
    }

    private List<io.spring.gradle.dependencymanagement.internal.pom.Dependency> getManagedDependencies(Model model) {
        if (model.getDependencyManagement() == null || model.getDependencyManagement().getDependencies() == null) {
            return Collections.emptyList();
        }
        ArrayList<io.spring.gradle.dependencymanagement.internal.pom.Dependency> result = new ArrayList<io.spring.gradle.dependencymanagement.internal.pom.Dependency>();
        for (Dependency dependency : model.getDependencyManagement().getDependencies()) {
            result.add(this.createDependency(dependency));
        }
        return result;
    }

    private io.spring.gradle.dependencymanagement.internal.pom.Dependency createDependency(Dependency dependency) {
        LinkedHashSet<String> exclusions = new LinkedHashSet<String>();
        if (dependency.getExclusions() != null) {
            for (Exclusion exclusion : dependency.getExclusions()) {
                exclusions.add(exclusion.getGroupId() + ":" + exclusion.getArtifactId());
            }
        }
        return new io.spring.gradle.dependencymanagement.internal.pom.Dependency(new Coordinates(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion()), dependency.isOptional(), dependency.getType(), dependency.getClassifier(), dependency.getScope(), exclusions);
    }

    private List<io.spring.gradle.dependencymanagement.internal.pom.Dependency> getDependencies(Model model) {
        if (model.getDependencies() == null) {
            return Collections.emptyList();
        }
        ArrayList<io.spring.gradle.dependencymanagement.internal.pom.Dependency> result = new ArrayList<io.spring.gradle.dependencymanagement.internal.pom.Dependency>();
        for (Dependency dependency : model.getDependencies()) {
            result.add(this.createDependency(dependency));
        }
        return result;
    }

    private Map<String, String> asMap(Properties properties) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String name : properties.stringPropertyNames()) {
            map.put(name, properties.getProperty(name));
        }
        return map;
    }

    private String createKey(String group, String name) {
        return group + ":" + name;
    }
}

