/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.analyze.treewalker.steps;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import nl.basjes.parse.useragent.analyze.InvalidParserConfigurationException;
import nl.basjes.parse.useragent.analyze.WordRangeVisitor;
import nl.basjes.parse.useragent.analyze.treewalker.steps.Step;
import nl.basjes.parse.useragent.analyze.treewalker.steps.compare.StepContains;
import nl.basjes.parse.useragent.analyze.treewalker.steps.compare.StepEndsWith;
import nl.basjes.parse.useragent.analyze.treewalker.steps.compare.StepEquals;
import nl.basjes.parse.useragent.analyze.treewalker.steps.compare.StepIsNull;
import nl.basjes.parse.useragent.analyze.treewalker.steps.compare.StepNotEquals;
import nl.basjes.parse.useragent.analyze.treewalker.steps.compare.StepStartsWith;
import nl.basjes.parse.useragent.analyze.treewalker.steps.lookup.StepLookup;
import nl.basjes.parse.useragent.analyze.treewalker.steps.value.StepBackToFull;
import nl.basjes.parse.useragent.analyze.treewalker.steps.value.StepCleanVersion;
import nl.basjes.parse.useragent.analyze.treewalker.steps.value.StepFixedString;
import nl.basjes.parse.useragent.analyze.treewalker.steps.value.StepNormalizeBrand;
import nl.basjes.parse.useragent.analyze.treewalker.steps.value.StepWordRange;
import nl.basjes.parse.useragent.analyze.treewalker.steps.walk.StepDown;
import nl.basjes.parse.useragent.analyze.treewalker.steps.walk.StepNext;
import nl.basjes.parse.useragent.analyze.treewalker.steps.walk.StepPrev;
import nl.basjes.parse.useragent.analyze.treewalker.steps.walk.StepUp;
import nl.basjes.parse.useragent.parser.UserAgentTreeWalkerBaseVisitor;
import nl.basjes.parse.useragent.parser.UserAgentTreeWalkerParser;
import nl.basjes.shaded.org.antlr.v4.runtime.ParserRuleContext;
import nl.basjes.shaded.org.antlr.v4.runtime.tree.ParseTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WalkList
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(WalkList.class);
    private final Map<String, Map<String, String>> lookups;
    private final List<Step> steps = new ArrayList<Step>();
    private final boolean verbose;
    Boolean usesIsNull = null;

    public WalkList(ParserRuleContext requiredPattern, Map<String, Map<String, String>> lookups, boolean verbose) {
        this.lookups = lookups;
        this.verbose = verbose;
        new WalkListBuilder().visit(requiredPattern);
        this.linkSteps();
        int i = 1;
        if (verbose) {
            LOG.info("------------------------------------");
            LOG.info("Required: " + requiredPattern.getText());
            for (Step step : this.steps) {
                step.setVerbose(true);
                LOG.info("{}: {}", (Object)i++, (Object)step);
            }
        }
    }

    private void linkSteps() {
        if (this.steps.size() > 0) {
            int i;
            for (i = 0; i < this.steps.size() - 1; ++i) {
                this.steps.get(i).setNextStep(i, this.steps.get(i + 1));
            }
            this.steps.get(i).setNextStep(i, null);
        }
    }

    public String walk(ParseTree tree, String value) {
        if (this.steps.size() == 0) {
            return value;
        }
        Step firstStep = this.steps.get(0);
        if (this.verbose) {
            Step.LOG.info("Tree: >>>{}<<<", (Object)tree.getText());
            Step.LOG.info("Enter step: {}", (Object)firstStep);
        }
        String result = firstStep.walk(tree, value);
        if (this.verbose) {
            Step.LOG.info("Leave step ({}): {}", (Object)(result == null ? "-" : "+"), (Object)firstStep);
        }
        return result;
    }

    public Step getFirstStep() {
        if (this.steps == null || this.steps.size() == 0) {
            return null;
        }
        return this.steps.get(0);
    }

    public boolean usesIsNull() {
        if (this.usesIsNull != null) {
            return this.usesIsNull;
        }
        for (Step step = this.getFirstStep(); step != null; step = step.getNextStep()) {
            if (!(step instanceof StepIsNull)) continue;
            this.usesIsNull = true;
            return true;
        }
        this.usesIsNull = false;
        return false;
    }

    public String toString() {
        if (this.steps.size() == 0) {
            return "Empty";
        }
        StringBuilder sb = new StringBuilder(128);
        for (Step step : this.steps) {
            sb.append(" --> ").append(step);
        }
        return sb.toString();
    }

    private class WalkListBuilder
    extends UserAgentTreeWalkerBaseVisitor<Void> {
        boolean foundHashEntryPoint = false;

        private WalkListBuilder() {
        }

        private void fromHereItCannotBeInHashMapAnymore() {
            this.foundHashEntryPoint = true;
        }

        private void add(Step step) {
            if (this.foundHashEntryPoint) {
                WalkList.this.steps.add(step);
            }
        }

        private void visitNext(UserAgentTreeWalkerParser.PathContext nextStep) {
            if (nextStep != null) {
                this.visit(nextStep);
            }
        }

        @Override
        public Void visitMatcherPath(UserAgentTreeWalkerParser.MatcherPathContext ctx) {
            this.visit(ctx.basePath());
            return null;
        }

        @Override
        public Void visitMatcherPathLookup(UserAgentTreeWalkerParser.MatcherPathLookupContext ctx) {
            this.visit(ctx.matcher());
            this.fromHereItCannotBeInHashMapAnymore();
            String lookupName = ctx.lookup.getText();
            Map lookup = (Map)WalkList.this.lookups.get(lookupName);
            if (lookup == null) {
                throw new InvalidParserConfigurationException("Missing lookup \"" + ctx.lookup.getText() + "\" ");
            }
            String defaultValue = null;
            if (ctx.defaultValue != null) {
                defaultValue = ctx.defaultValue.getText();
            }
            this.add(new StepLookup(lookupName, lookup, defaultValue));
            return null;
        }

        @Override
        public Void visitMatcherCleanVersion(UserAgentTreeWalkerParser.MatcherCleanVersionContext ctx) {
            this.visit(ctx.matcher());
            this.fromHereItCannotBeInHashMapAnymore();
            this.add(new StepCleanVersion());
            return null;
        }

        @Override
        public Void visitMatcherNormalizeBrand(UserAgentTreeWalkerParser.MatcherNormalizeBrandContext ctx) {
            this.visit(ctx.matcher());
            this.fromHereItCannotBeInHashMapAnymore();
            this.add(new StepNormalizeBrand());
            return null;
        }

        @Override
        public Void visitMatcherWordRange(UserAgentTreeWalkerParser.MatcherWordRangeContext ctx) {
            this.visit(ctx.matcher());
            this.fromHereItCannotBeInHashMapAnymore();
            this.add(new StepWordRange(WordRangeVisitor.getRange(ctx.wordRange())));
            return null;
        }

        @Override
        public Void visitMatcherPathIsNull(UserAgentTreeWalkerParser.MatcherPathIsNullContext ctx) {
            WalkList.this.steps.add(new StepIsNull());
            this.visit(ctx.matcher());
            return null;
        }

        @Override
        public Void visitPathFixedValue(UserAgentTreeWalkerParser.PathFixedValueContext ctx) {
            this.add(new StepFixedString(ctx.value.getText()));
            return null;
        }

        @Override
        public Void visitPathWalk(UserAgentTreeWalkerParser.PathWalkContext ctx) {
            this.visitNext(ctx.nextStep);
            return null;
        }

        @Override
        public Void visitStepDown(UserAgentTreeWalkerParser.StepDownContext ctx) {
            this.add(new StepDown(ctx.numberRange(), ctx.name.getText()));
            this.visitNext(ctx.nextStep);
            return null;
        }

        @Override
        public Void visitStepUp(UserAgentTreeWalkerParser.StepUpContext ctx) {
            this.fromHereItCannotBeInHashMapAnymore();
            this.add(new StepUp());
            this.visitNext(ctx.nextStep);
            return null;
        }

        @Override
        public Void visitStepNext(UserAgentTreeWalkerParser.StepNextContext ctx) {
            this.fromHereItCannotBeInHashMapAnymore();
            this.add(new StepNext());
            this.visitNext(ctx.nextStep);
            return null;
        }

        @Override
        public Void visitStepPrev(UserAgentTreeWalkerParser.StepPrevContext ctx) {
            this.fromHereItCannotBeInHashMapAnymore();
            this.add(new StepPrev());
            this.visitNext(ctx.nextStep);
            return null;
        }

        @Override
        public Void visitStepEqualsValue(UserAgentTreeWalkerParser.StepEqualsValueContext ctx) {
            this.add(new StepEquals(ctx.value.getText()));
            this.fromHereItCannotBeInHashMapAnymore();
            this.visitNext(ctx.nextStep);
            return null;
        }

        @Override
        public Void visitStepNotEqualsValue(UserAgentTreeWalkerParser.StepNotEqualsValueContext ctx) {
            this.fromHereItCannotBeInHashMapAnymore();
            this.add(new StepNotEquals(ctx.value.getText()));
            this.visitNext(ctx.nextStep);
            return null;
        }

        @Override
        public Void visitStepStartsWithValue(UserAgentTreeWalkerParser.StepStartsWithValueContext ctx) {
            this.fromHereItCannotBeInHashMapAnymore();
            this.add(new StepStartsWith(ctx.value.getText()));
            this.visitNext(ctx.nextStep);
            return null;
        }

        @Override
        public Void visitStepEndsWithValue(UserAgentTreeWalkerParser.StepEndsWithValueContext ctx) {
            this.fromHereItCannotBeInHashMapAnymore();
            this.add(new StepEndsWith(ctx.value.getText()));
            this.visitNext(ctx.nextStep);
            return null;
        }

        @Override
        public Void visitStepContainsValue(UserAgentTreeWalkerParser.StepContainsValueContext ctx) {
            this.fromHereItCannotBeInHashMapAnymore();
            this.add(new StepContains(ctx.value.getText()));
            this.visitNext(ctx.nextStep);
            return null;
        }

        @Override
        public Void visitStepWordRange(UserAgentTreeWalkerParser.StepWordRangeContext ctx) {
            WordRangeVisitor.Range range = WordRangeVisitor.getRange(ctx.wordRange());
            if (!range.isRangeInHashMap()) {
                this.fromHereItCannotBeInHashMapAnymore();
            }
            this.add(new StepWordRange(range));
            this.visitNext(ctx.nextStep);
            return null;
        }

        @Override
        public Void visitStepBackToFull(UserAgentTreeWalkerParser.StepBackToFullContext ctx) {
            this.add(new StepBackToFull());
            this.visitNext(ctx.nextStep);
            return null;
        }
    }
}

