/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.Serializable;
import nl.basjes.parse.useragent.AbstractUserAgentAnalyzerDirect;
import nl.basjes.parse.useragent.UserAgent;
import org.apache.commons.collections4.map.LRUMap;

@DefaultSerializer(value=KryoSerializer.class)
public class AbstractUserAgentAnalyzer
extends AbstractUserAgentAnalyzerDirect
implements Serializable {
    public static final int DEFAULT_PARSE_CACHE_SIZE = 10000;
    protected int cacheSize = 10000;
    private transient LRUMap<String, UserAgent> parseCache = null;

    protected AbstractUserAgentAnalyzer() {
        this.initializeCache();
    }

    public void disableCaching() {
        this.setCacheSize(0);
    }

    public void setCacheSize(int newCacheSize) {
        this.cacheSize = Math.max(newCacheSize, 0);
        this.initializeCache();
    }

    private void initializeCache() {
        this.parseCache = this.cacheSize >= 1 ? new LRUMap(this.cacheSize) : null;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    @Override
    public synchronized UserAgent parse(UserAgent userAgent) {
        if (userAgent == null) {
            return null;
        }
        userAgent.reset();
        if (this.parseCache == null) {
            return super.parse(userAgent);
        }
        String userAgentString = userAgent.getUserAgentString();
        UserAgent cachedValue = (UserAgent)this.parseCache.get((Object)userAgentString);
        if (cachedValue != null) {
            userAgent.clone(cachedValue);
        } else {
            cachedValue = new UserAgent(super.parse(userAgent));
            this.parseCache.put((Object)userAgentString, (Object)cachedValue);
        }
        return userAgent;
    }

    @Override
    public String toString() {
        return "UserAgentAnalyzer{cacheSize=" + this.cacheSize + ", " + super.toString() + "} ";
    }

    public static abstract class AbstractUserAgentAnalyzerBuilder<UAA extends AbstractUserAgentAnalyzer, B extends AbstractUserAgentAnalyzerBuilder<UAA, B>>
    extends AbstractUserAgentAnalyzerDirect.AbstractUserAgentAnalyzerDirectBuilder<UAA, B> {
        private final UAA uaa;

        public AbstractUserAgentAnalyzerBuilder(UAA newUaa) {
            super(newUaa);
            this.uaa = newUaa;
        }

        public B withCache(int newCacheSize) {
            this.failIfAlreadyBuilt();
            ((AbstractUserAgentAnalyzer)this.uaa).setCacheSize(newCacheSize);
            return (B)this;
        }

        public B withoutCache() {
            this.failIfAlreadyBuilt();
            ((AbstractUserAgentAnalyzer)this.uaa).setCacheSize(0);
            return (B)this;
        }

        @Override
        public UAA build() {
            return (UAA)((AbstractUserAgentAnalyzer)super.build());
        }
    }

    public static class KryoSerializer
    extends AbstractUserAgentAnalyzerDirect.KryoSerializer {
        public KryoSerializer(Kryo kryo, Class<?> type) {
            super(kryo, type);
        }

        public void write(Kryo kryo, Output output, AbstractUserAgentAnalyzerDirect object) {
            output.write(((AbstractUserAgentAnalyzer)object).cacheSize);
        }

        @Override
        public AbstractUserAgentAnalyzer read(Kryo kryo, Input input, Class<AbstractUserAgentAnalyzerDirect> type) {
            AbstractUserAgentAnalyzer uaa = (AbstractUserAgentAnalyzer)super.read(kryo, input, (Class)type);
            uaa.cacheSize = input.read();
            uaa.initializeCache();
            return uaa;
        }
    }
}

