/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.utils.publicsuffix;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import nl.basjes.parse.useragent.utils.publicsuffix.PublicSuffixMatcher;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.conn.util.DomainType;
import org.apache.http.conn.util.PublicSuffixListParser;
import org.apache.http.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.SAFE)
public final class PublicSuffixMatcherLoader {
    private static volatile PublicSuffixMatcher defaultInstance;

    private PublicSuffixMatcherLoader() {
    }

    public static PublicSuffixMatcher load(InputStream in) throws IOException {
        Args.notNull((Object)in, (String)"InputStream");
        List lists = new PublicSuffixListParser().parseByType((Reader)new InputStreamReader(in, StandardCharsets.UTF_8));
        return new PublicSuffixMatcher(lists);
    }

    public static PublicSuffixMatcher load(URL url) throws IOException {
        Args.notNull((Object)url, (String)"URL");
        try (InputStream in = url.openStream();){
            PublicSuffixMatcher publicSuffixMatcher = PublicSuffixMatcherLoader.load(in);
            return publicSuffixMatcher;
        }
    }

    public static PublicSuffixMatcher load(File file) throws IOException {
        Args.notNull((Object)file, (String)"File");
        try (FileInputStream in = new FileInputStream(file);){
            PublicSuffixMatcher publicSuffixMatcher = PublicSuffixMatcherLoader.load(in);
            return publicSuffixMatcher;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PublicSuffixMatcher getDefault() {
        if (defaultInstance != null) return defaultInstance;
        Class<PublicSuffixMatcherLoader> clazz = PublicSuffixMatcherLoader.class;
        synchronized (PublicSuffixMatcherLoader.class) {
            if (defaultInstance != null) return defaultInstance;
            URL url = PublicSuffixMatcherLoader.class.getResource("/mozilla/public-suffix-list.txt");
            if (url != null) {
                try {
                    defaultInstance = PublicSuffixMatcherLoader.load(url);
                }
                catch (IOException ex) {
                    Logger log = LoggerFactory.getLogger(PublicSuffixMatcherLoader.class);
                    if (!log.isWarnEnabled()) return defaultInstance;
                    log.warn("Failure loading public suffix list from default resource", (Throwable)ex);
                }
            } else {
                defaultInstance = new PublicSuffixMatcher(DomainType.ICANN, Collections.singletonList("com"), null);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultInstance;
        }
    }
}

