/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.analyze.treewalker.steps;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.basjes.parse.useragent.analyze.InvalidParserConfigurationException;
import nl.basjes.parse.useragent.analyze.WordRangeVisitor;
import nl.basjes.parse.useragent.analyze.treewalker.steps.Step;
import nl.basjes.parse.useragent.analyze.treewalker.steps.compare.StepContains;
import nl.basjes.parse.useragent.analyze.treewalker.steps.compare.StepEndsWith;
import nl.basjes.parse.useragent.analyze.treewalker.steps.compare.StepEquals;
import nl.basjes.parse.useragent.analyze.treewalker.steps.compare.StepIsInSet;
import nl.basjes.parse.useragent.analyze.treewalker.steps.compare.StepIsNull;
import nl.basjes.parse.useragent.analyze.treewalker.steps.compare.StepNotEquals;
import nl.basjes.parse.useragent.analyze.treewalker.steps.compare.StepStartsWith;
import nl.basjes.parse.useragent.analyze.treewalker.steps.lookup.StepIsInLookupContains;
import nl.basjes.parse.useragent.analyze.treewalker.steps.lookup.StepIsInLookupPrefix;
import nl.basjes.parse.useragent.analyze.treewalker.steps.lookup.StepLookup;
import nl.basjes.parse.useragent.analyze.treewalker.steps.lookup.StepLookupContains;
import nl.basjes.parse.useragent.analyze.treewalker.steps.lookup.StepLookupPrefix;
import nl.basjes.parse.useragent.analyze.treewalker.steps.value.StepBackToFull;
import nl.basjes.parse.useragent.analyze.treewalker.steps.value.StepCleanVersion;
import nl.basjes.parse.useragent.analyze.treewalker.steps.value.StepConcat;
import nl.basjes.parse.useragent.analyze.treewalker.steps.value.StepConcatPostfix;
import nl.basjes.parse.useragent.analyze.treewalker.steps.value.StepConcatPrefix;
import nl.basjes.parse.useragent.analyze.treewalker.steps.value.StepNormalizeBrand;
import nl.basjes.parse.useragent.analyze.treewalker.steps.value.StepWordRange;
import nl.basjes.parse.useragent.analyze.treewalker.steps.walk.StepDown;
import nl.basjes.parse.useragent.analyze.treewalker.steps.walk.StepNext;
import nl.basjes.parse.useragent.analyze.treewalker.steps.walk.StepNextN;
import nl.basjes.parse.useragent.analyze.treewalker.steps.walk.StepPrev;
import nl.basjes.parse.useragent.analyze.treewalker.steps.walk.StepPrevN;
import nl.basjes.parse.useragent.analyze.treewalker.steps.walk.StepUp;
import nl.basjes.parse.useragent.parser.UserAgentTreeWalkerBaseVisitor;
import nl.basjes.parse.useragent.parser.UserAgentTreeWalkerParser;
import nl.basjes.shaded.org.antlr.v4.runtime.ParserRuleContext;
import nl.basjes.shaded.org.antlr.v4.runtime.Token;
import nl.basjes.shaded.org.antlr.v4.runtime.tree.ParseTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WalkList
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(WalkList.class);
    private final Map<String, Map<String, String>> lookups;
    private final Map<String, Set<String>> lookupSets;
    private final List<Step> steps = new ArrayList<Step>();
    private final boolean verbose;
    private Boolean usesIsNull = null;

    private WalkList() {
        this.lookups = Collections.emptyMap();
        this.lookupSets = Collections.emptyMap();
        this.verbose = false;
    }

    public WalkList(ParserRuleContext requiredPattern, Map<String, Map<String, String>> lookups, Map<String, Set<String>> lookupSets, boolean verbose) {
        this.lookups = lookups;
        this.lookupSets = lookupSets;
        this.verbose = verbose;
        new WalkListBuilder().visit(requiredPattern);
        this.linkSteps();
        int i = 1;
        if (verbose) {
            LOG.info("------------------------------------");
            LOG.info("Required: {}", (Object)requiredPattern.getText());
            for (Step step : this.steps) {
                step.setVerbose(true);
                LOG.info("{}: {}", (Object)i++, (Object)step);
            }
        }
    }

    private void linkSteps() {
        Step nextStep = null;
        for (int i = this.steps.size() - 1; i >= 0; --i) {
            Step current = this.steps.get(i);
            current.setNextStep(i, nextStep);
            nextStep = current;
        }
    }

    public long pruneTrailingStepsThatCannotFail() {
        Step current;
        int lastStepThatCannotFail = Integer.MAX_VALUE;
        int i = this.steps.size() - 1;
        while (i >= 0 && !(current = this.steps.get(i)).canFail()) {
            lastStepThatCannotFail = i--;
        }
        if (lastStepThatCannotFail == Integer.MAX_VALUE) {
            return 0L;
        }
        if (lastStepThatCannotFail == 0) {
            long prunedSteps = this.steps.size();
            this.steps.clear();
            return prunedSteps;
        }
        int lastRelevantStepIndex = lastStepThatCannotFail - 1;
        Step lastRelevantStep = this.steps.get(lastRelevantStepIndex);
        lastRelevantStep.setNextStep(lastRelevantStepIndex, null);
        this.steps.subList(lastRelevantStepIndex + 1, this.steps.size()).clear();
        return this.steps.size() - (lastRelevantStepIndex + 1);
    }

    public WalkResult walk(ParseTree tree, String value) {
        if (this.steps.isEmpty()) {
            return new WalkResult(tree, value);
        }
        Step firstStep = this.steps.get(0);
        if (this.verbose) {
            Step.LOG.info("Tree: >>>{}<<<", (Object)tree.getText());
            Step.LOG.info("Enter step: {}", (Object)firstStep);
        }
        WalkResult result = firstStep.walk(tree, value);
        if (this.verbose) {
            Step.LOG.info("Leave step ({}): {}", (Object)(result == null ? "-" : "+"), (Object)firstStep);
        }
        return result;
    }

    public Step getFirstStep() {
        return this.steps.isEmpty() ? null : this.steps.get(0);
    }

    public boolean usesIsNull() {
        if (this.usesIsNull != null) {
            return this.usesIsNull;
        }
        for (Step step = this.getFirstStep(); step != null; step = step.getNextStep()) {
            if (!(step instanceof StepIsNull)) continue;
            this.usesIsNull = true;
            return true;
        }
        this.usesIsNull = false;
        return false;
    }

    public String toString() {
        if (this.steps.isEmpty()) {
            return "Empty";
        }
        StringBuilder sb = new StringBuilder(128);
        for (Step step : this.steps) {
            sb.append(" --> ").append(step);
        }
        return sb.toString();
    }

    private class WalkListBuilder
    extends UserAgentTreeWalkerBaseVisitor<Void> {
        boolean foundHashEntryPoint = false;

        private WalkListBuilder() {
        }

        private void fromHereItCannotBeInHashMapAnymore() {
            this.foundHashEntryPoint = true;
        }

        private boolean stillGoingToHashMap() {
            return !this.foundHashEntryPoint;
        }

        private void add(Step step) {
            if (this.foundHashEntryPoint) {
                WalkList.this.steps.add(step);
            }
        }

        private void visitNext(UserAgentTreeWalkerParser.PathContext nextStep) {
            if (nextStep != null) {
                this.visit(nextStep);
            }
        }

        @Override
        public Void visitMatcherPath(UserAgentTreeWalkerParser.MatcherPathContext ctx) {
            this.visit(ctx.basePath());
            return null;
        }

        private String extractText(Token token) {
            if (token == null) {
                return null;
            }
            return token.getText();
        }

        @Override
        public Void visitMatcherPathLookup(UserAgentTreeWalkerParser.MatcherPathLookupContext ctx) {
            this.visit(ctx.matcher());
            this.fromHereItCannotBeInHashMapAnymore();
            String lookupName = ctx.lookup.getText();
            Map<String, String> lookup = this.getLookup(lookupName);
            this.add(new StepLookup(lookupName, lookup, this.extractText(ctx.defaultValue)));
            return null;
        }

        @Override
        public Void visitMatcherPathLookupContains(UserAgentTreeWalkerParser.MatcherPathLookupContainsContext ctx) {
            this.visit(ctx.matcher());
            this.fromHereItCannotBeInHashMapAnymore();
            String lookupName = ctx.lookup.getText();
            Map<String, String> lookup = this.getLookup(lookupName);
            this.add(new StepLookupContains(lookupName, lookup, this.extractText(ctx.defaultValue)));
            return null;
        }

        @Override
        public Void visitMatcherPathLookupPrefix(UserAgentTreeWalkerParser.MatcherPathLookupPrefixContext ctx) {
            this.visit(ctx.matcher());
            this.fromHereItCannotBeInHashMapAnymore();
            String lookupName = ctx.lookup.getText();
            Map<String, String> lookup = this.getLookup(lookupName);
            this.add(new StepLookupPrefix(lookupName, lookup, this.extractText(ctx.defaultValue)));
            return null;
        }

        @Override
        public Void visitMatcherPathIsInLookupContains(UserAgentTreeWalkerParser.MatcherPathIsInLookupContainsContext ctx) {
            this.visit(ctx.matcher());
            this.fromHereItCannotBeInHashMapAnymore();
            String lookupName = ctx.lookup.getText();
            Map<String, String> lookup = this.getLookup(lookupName);
            this.add(new StepIsInLookupContains(lookupName, lookup));
            return null;
        }

        @Override
        public Void visitMatcherPathIsInLookupPrefix(UserAgentTreeWalkerParser.MatcherPathIsInLookupPrefixContext ctx) {
            this.visit(ctx.matcher());
            this.fromHereItCannotBeInHashMapAnymore();
            String lookupName = ctx.lookup.getText();
            Map<String, String> lookup = this.getLookup(lookupName);
            this.add(new StepIsInLookupPrefix(lookupName, lookup));
            return null;
        }

        private Map<String, String> getLookup(String lookupName) {
            Map lookup = (Map)WalkList.this.lookups.get(lookupName);
            if (lookup == null) {
                throw new InvalidParserConfigurationException("Missing lookup \"" + lookupName + "\" ");
            }
            return lookup;
        }

        @Override
        public Void visitMatcherCleanVersion(UserAgentTreeWalkerParser.MatcherCleanVersionContext ctx) {
            this.visit(ctx.matcher());
            this.fromHereItCannotBeInHashMapAnymore();
            this.add(new StepCleanVersion());
            return null;
        }

        @Override
        public Void visitMatcherNormalizeBrand(UserAgentTreeWalkerParser.MatcherNormalizeBrandContext ctx) {
            this.visit(ctx.matcher());
            this.fromHereItCannotBeInHashMapAnymore();
            this.add(new StepNormalizeBrand());
            return null;
        }

        @Override
        public Void visitMatcherConcat(UserAgentTreeWalkerParser.MatcherConcatContext ctx) {
            this.visit(ctx.matcher());
            this.fromHereItCannotBeInHashMapAnymore();
            this.add(new StepConcat(ctx.prefix.getText(), ctx.postfix.getText()));
            return null;
        }

        @Override
        public Void visitMatcherConcatPrefix(UserAgentTreeWalkerParser.MatcherConcatPrefixContext ctx) {
            this.visit(ctx.matcher());
            this.fromHereItCannotBeInHashMapAnymore();
            this.add(new StepConcatPrefix(ctx.prefix.getText()));
            return null;
        }

        @Override
        public Void visitMatcherConcatPostfix(UserAgentTreeWalkerParser.MatcherConcatPostfixContext ctx) {
            this.visit(ctx.matcher());
            this.fromHereItCannotBeInHashMapAnymore();
            this.add(new StepConcatPostfix(ctx.postfix.getText()));
            return null;
        }

        @Override
        public Void visitMatcherWordRange(UserAgentTreeWalkerParser.MatcherWordRangeContext ctx) {
            this.visit(ctx.matcher());
            this.fromHereItCannotBeInHashMapAnymore();
            this.add(new StepWordRange(WordRangeVisitor.getRange(ctx.wordRange())));
            return null;
        }

        @Override
        public Void visitMatcherPathIsNull(UserAgentTreeWalkerParser.MatcherPathIsNullContext ctx) {
            WalkList.this.steps.add(new StepIsNull());
            this.visit(ctx.matcher());
            return null;
        }

        @Override
        public Void visitPathVariable(UserAgentTreeWalkerParser.PathVariableContext ctx) {
            this.fromHereItCannotBeInHashMapAnymore();
            this.visitNext(ctx.nextStep);
            return null;
        }

        @Override
        public Void visitPathWalk(UserAgentTreeWalkerParser.PathWalkContext ctx) {
            this.visitNext(ctx.nextStep);
            return null;
        }

        @Override
        public Void visitStepDown(UserAgentTreeWalkerParser.StepDownContext ctx) {
            this.add(new StepDown(ctx.numberRange(), ctx.name.getText()));
            this.visitNext(ctx.nextStep);
            return null;
        }

        @Override
        public Void visitStepUp(UserAgentTreeWalkerParser.StepUpContext ctx) {
            this.fromHereItCannotBeInHashMapAnymore();
            this.add(new StepUp());
            this.visitNext(ctx.nextStep);
            return null;
        }

        @Override
        public Void visitStepNext(UserAgentTreeWalkerParser.StepNextContext ctx) {
            this.fromHereItCannotBeInHashMapAnymore();
            this.add(new StepNext());
            this.visitNext(ctx.nextStep);
            return null;
        }

        private Void doStepNextN(UserAgentTreeWalkerParser.PathContext nextStep, int nextSteps) {
            this.fromHereItCannotBeInHashMapAnymore();
            this.add(new StepNextN(nextSteps));
            this.visitNext(nextStep);
            return null;
        }

        @Override
        public Void visitStepNext2(UserAgentTreeWalkerParser.StepNext2Context ctx) {
            return this.doStepNextN(ctx.nextStep, 2);
        }

        @Override
        public Void visitStepNext3(UserAgentTreeWalkerParser.StepNext3Context ctx) {
            return this.doStepNextN(ctx.nextStep, 3);
        }

        @Override
        public Void visitStepNext4(UserAgentTreeWalkerParser.StepNext4Context ctx) {
            return this.doStepNextN(ctx.nextStep, 4);
        }

        @Override
        public Void visitStepPrev(UserAgentTreeWalkerParser.StepPrevContext ctx) {
            this.fromHereItCannotBeInHashMapAnymore();
            this.add(new StepPrev());
            this.visitNext(ctx.nextStep);
            return null;
        }

        private Void doStepPrevN(UserAgentTreeWalkerParser.PathContext nextStep, int prevSteps) {
            this.fromHereItCannotBeInHashMapAnymore();
            this.add(new StepPrevN(prevSteps));
            this.visitNext(nextStep);
            return null;
        }

        @Override
        public Void visitStepPrev2(UserAgentTreeWalkerParser.StepPrev2Context ctx) {
            return this.doStepPrevN(ctx.nextStep, 2);
        }

        @Override
        public Void visitStepPrev3(UserAgentTreeWalkerParser.StepPrev3Context ctx) {
            return this.doStepPrevN(ctx.nextStep, 3);
        }

        @Override
        public Void visitStepPrev4(UserAgentTreeWalkerParser.StepPrev4Context ctx) {
            return this.doStepPrevN(ctx.nextStep, 4);
        }

        @Override
        public Void visitStepEqualsValue(UserAgentTreeWalkerParser.StepEqualsValueContext ctx) {
            this.add(new StepEquals(ctx.value.getText()));
            this.fromHereItCannotBeInHashMapAnymore();
            this.visitNext(ctx.nextStep);
            return null;
        }

        @Override
        public Void visitStepNotEqualsValue(UserAgentTreeWalkerParser.StepNotEqualsValueContext ctx) {
            this.fromHereItCannotBeInHashMapAnymore();
            this.add(new StepNotEquals(ctx.value.getText()));
            this.visitNext(ctx.nextStep);
            return null;
        }

        @Override
        public Void visitStepIsInSet(UserAgentTreeWalkerParser.StepIsInSetContext ctx) {
            Map lookup;
            this.fromHereItCannotBeInHashMapAnymore();
            String lookupSetName = ctx.set.getText();
            LinkedHashSet lookupSet = (LinkedHashSet)WalkList.this.lookupSets.get(lookupSetName);
            if (lookupSet == null && (lookup = (Map)WalkList.this.lookups.get(lookupSetName)) != null) {
                lookupSet = new LinkedHashSet(lookup.keySet());
            }
            if (lookupSet == null) {
                throw new InvalidParserConfigurationException("Missing lookupSet \"" + lookupSetName + "\" ");
            }
            this.add(new StepIsInSet(lookupSetName, lookupSet));
            this.visitNext(ctx.nextStep);
            return null;
        }

        @Override
        public Void visitStepStartsWithValue(UserAgentTreeWalkerParser.StepStartsWithValueContext ctx) {
            boolean skipIfShortEnough = this.stillGoingToHashMap();
            this.fromHereItCannotBeInHashMapAnymore();
            String value = ctx.value.getText();
            boolean addTheStep = true;
            if (skipIfShortEnough && value.length() <= 3) {
                addTheStep = false;
            }
            if (addTheStep) {
                this.add(new StepStartsWith(value));
            }
            this.visitNext(ctx.nextStep);
            return null;
        }

        @Override
        public Void visitStepEndsWithValue(UserAgentTreeWalkerParser.StepEndsWithValueContext ctx) {
            this.fromHereItCannotBeInHashMapAnymore();
            this.add(new StepEndsWith(ctx.value.getText()));
            this.visitNext(ctx.nextStep);
            return null;
        }

        @Override
        public Void visitStepContainsValue(UserAgentTreeWalkerParser.StepContainsValueContext ctx) {
            this.fromHereItCannotBeInHashMapAnymore();
            this.add(new StepContains(ctx.value.getText()));
            this.visitNext(ctx.nextStep);
            return null;
        }

        @Override
        public Void visitStepWordRange(UserAgentTreeWalkerParser.StepWordRangeContext ctx) {
            WordRangeVisitor.Range range = WordRangeVisitor.getRange(ctx.wordRange());
            this.add(new StepWordRange(range));
            this.visitNext(ctx.nextStep);
            return null;
        }

        @Override
        public Void visitStepBackToFull(UserAgentTreeWalkerParser.StepBackToFullContext ctx) {
            this.add(new StepBackToFull());
            this.visitNext(ctx.nextStep);
            return null;
        }
    }

    public static class WalkResult {
        private final ParseTree tree;
        private final String value;

        public WalkResult(ParseTree tree, String value) {
            this.tree = tree;
            this.value = value;
        }

        public ParseTree getTree() {
            return this.tree;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return "WalkResult{tree=" + (this.tree == null ? ">>>NULL<<<" : this.tree.getText()) + ", value=" + (this.value == null ? ">>>NULL<<<" : '\'' + this.value + '\'') + '}';
        }
    }
}

