/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.analyze;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.analyze.Analyzer;
import nl.basjes.parse.useragent.analyze.InvalidParserConfigurationException;
import nl.basjes.parse.useragent.analyze.MatcherAction;
import nl.basjes.parse.useragent.analyze.MatcherExtractAction;
import nl.basjes.parse.useragent.analyze.MatcherRequireAction;
import nl.basjes.parse.useragent.analyze.MatcherVariableAction;
import nl.basjes.parse.useragent.analyze.MatchesList;
import nl.basjes.parse.useragent.analyze.UselessMatcherException;
import nl.basjes.parse.useragent.analyze.WordRangeVisitor;
import nl.basjes.parse.useragent.utils.YamlUtils;
import nl.basjes.shaded.org.yaml.snakeyaml.nodes.MappingNode;
import nl.basjes.shaded.org.yaml.snakeyaml.nodes.NodeTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Matcher
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(Matcher.class);
    private final Analyzer analyzer;
    private final List<MatcherVariableAction> variableActions;
    private final List<MatcherAction> dynamicActions;
    private final List<MatcherAction> fixedStringActions;
    private UserAgent newValuesUserAgent = null;
    private long actionsThatRequireInput;
    private boolean verbose;
    private boolean permanentVerbose;
    private String matcherSourceLocation;
    private final Map<String, Set<MatcherAction>> informMatcherActionsAboutVariables = new HashMap<String, Set<MatcherAction>>(8);
    private boolean alreadyNotifiedAnalyzerWeReceivedInput = false;
    private long actionsThatRequireInputAndReceivedInput = 0L;

    public String getMatcherSourceLocation() {
        return this.matcherSourceLocation;
    }

    private Matcher() {
        this.analyzer = null;
        this.fixedStringActions = new ArrayList<MatcherAction>();
        this.variableActions = new ArrayList<MatcherVariableAction>();
        this.dynamicActions = new ArrayList<MatcherAction>();
    }

    Matcher(Analyzer analyzer) {
        this.analyzer = analyzer;
        this.fixedStringActions = new ArrayList<MatcherAction>();
        this.variableActions = new ArrayList<MatcherVariableAction>();
        this.dynamicActions = new ArrayList<MatcherAction>();
    }

    public void destroy() {
        this.dynamicActions.forEach(MatcherAction::destroy);
        this.dynamicActions.clear();
        this.fixedStringActions.forEach(MatcherAction::destroy);
        this.fixedStringActions.clear();
    }

    public Map<String, Map<String, String>> getLookups() {
        return this.analyzer.getLookups();
    }

    public Map<String, Set<String>> getLookupSets() {
        return this.analyzer.getLookupSets();
    }

    public Matcher(Analyzer analyzer, Collection<String> wantedFieldNames, MappingNode matcherConfig, String filename) throws UselessMatcherException {
        this.analyzer = analyzer;
        this.fixedStringActions = new ArrayList<MatcherAction>();
        this.variableActions = new ArrayList<MatcherVariableAction>();
        this.dynamicActions = new ArrayList<MatcherAction>();
        this.newValuesUserAgent = new UserAgent(wantedFieldNames);
        this.matcherSourceLocation = filename + ':' + matcherConfig.getStartMark().getLine();
        this.verbose = false;
        boolean hasActiveExtractConfigs = false;
        boolean hasDefinedExtractConfigs = false;
        ArrayList<ConfigLine> configLines = new ArrayList<ConfigLine>(16);
        block17: for (NodeTuple nodeTuple : matcherConfig.getValue()) {
            String name;
            switch (name = YamlUtils.getKeyAsString(nodeTuple, this.matcherSourceLocation)) {
                case "options": {
                    List<String> options = YamlUtils.getStringValues(nodeTuple.getValueNode(), this.matcherSourceLocation);
                    this.verbose = options.contains("verbose");
                    break;
                }
                case "variable": {
                    String[] configParts;
                    for (String variableConfig : YamlUtils.getStringValues(nodeTuple.getValueNode(), this.matcherSourceLocation)) {
                        configParts = variableConfig.split(":", 2);
                        if (configParts.length != 2) {
                            throw new InvalidParserConfigurationException("Invalid variable config line: " + variableConfig);
                        }
                        String variableName = configParts[0].trim();
                        String config = configParts[1].trim();
                        configLines.add(new ConfigLine(ConfigLine.Type.VARIABLE, variableName, null, config));
                    }
                    continue block17;
                }
                case "require": {
                    for (String requireConfig : YamlUtils.getStringValues(nodeTuple.getValueNode(), this.matcherSourceLocation)) {
                        configLines.add(new ConfigLine(ConfigLine.Type.REQUIRE, null, null, requireConfig));
                    }
                    continue block17;
                }
                case "extract": {
                    String[] configParts;
                    for (String extractConfig : YamlUtils.getStringValues(nodeTuple.getValueNode(), this.matcherSourceLocation)) {
                        configParts = extractConfig.split(":", 3);
                        if (configParts.length != 3) {
                            throw new InvalidParserConfigurationException("Invalid extract config line: " + extractConfig);
                        }
                        String attribute = configParts[0].trim();
                        Long confidence = Long.parseLong(configParts[1].trim());
                        String config = configParts[2].trim();
                        hasDefinedExtractConfigs = true;
                        if (wantedFieldNames == null || wantedFieldNames.contains(attribute)) {
                            configLines.add(new ConfigLine(ConfigLine.Type.EXTRACT, attribute, confidence, config));
                            hasActiveExtractConfigs = true;
                            continue;
                        }
                        configLines.add(new ConfigLine(ConfigLine.Type.REQUIRE, null, null, config));
                    }
                    continue block17;
                }
            }
        }
        this.permanentVerbose = this.verbose;
        if (this.verbose) {
            LOG.info("---------------------------");
            LOG.info("- MATCHER -");
        }
        if (!hasDefinedExtractConfigs) {
            throw new InvalidParserConfigurationException("Matcher does not extract anything:" + this.matcherSourceLocation);
        }
        if (!hasActiveExtractConfigs) {
            throw new UselessMatcherException("Does not extract any wanted fields" + this.matcherSourceLocation);
        }
        for (ConfigLine configLine : configLines) {
            if (this.verbose) {
                LOG.info("{}: {}", (Object)configLine.type, (Object)configLine.expression);
            }
            switch (configLine.type) {
                case VARIABLE: {
                    this.variableActions.add(new MatcherVariableAction(configLine.attribute, configLine.expression, this));
                    break;
                }
                case REQUIRE: {
                    this.dynamicActions.add(new MatcherRequireAction(configLine.expression, this));
                    break;
                }
                case EXTRACT: {
                    MatcherExtractAction action = new MatcherExtractAction(configLine.attribute, configLine.confidence, configLine.expression, this);
                    this.dynamicActions.add(action);
                    this.newValuesUserAgent.set(configLine.attribute, "Dummy", -9999L);
                    action.setResultAgentField(this.newValuesUserAgent.get(configLine.attribute));
                    break;
                }
            }
        }
    }

    public void initialize() {
        long newEntries = 0L;
        long initStart = System.nanoTime();
        try {
            for (MatcherVariableAction matcherVariableAction : this.variableActions) {
                newEntries += matcherVariableAction.initialize();
            }
        }
        catch (InvalidParserConfigurationException e) {
            throw new InvalidParserConfigurationException("Syntax error.(" + this.matcherSourceLocation + ")", e);
        }
        HashSet<MatcherAction> uselessRequireActions = new HashSet<MatcherAction>();
        for (MatcherAction matcherAction : this.dynamicActions) {
            try {
                newEntries += matcherAction.initialize();
            }
            catch (InvalidParserConfigurationException e) {
                if (!e.getMessage().startsWith("It is useless to put a fixed value")) {
                    throw new InvalidParserConfigurationException("Syntax error.(" + this.matcherSourceLocation + ")" + e.getMessage(), e);
                }
                uselessRequireActions.add(matcherAction);
            }
        }
        for (MatcherAction matcherAction : this.dynamicActions) {
            if (!(matcherAction instanceof MatcherExtractAction) || !((MatcherExtractAction)matcherAction).isFixedValue()) continue;
            this.fixedStringActions.add(matcherAction);
            matcherAction.obtainResult();
        }
        this.fixedStringActions.forEach(this.dynamicActions::remove);
        uselessRequireActions.forEach(this.dynamicActions::remove);
        HashSet<MatcherVariableAction> hashSet = new HashSet<MatcherVariableAction>(this.variableActions.size());
        for (MatcherVariableAction variableAction : this.variableActions) {
            hashSet.add(variableAction);
            Set<MatcherAction> interestedActions = this.informMatcherActionsAboutVariables.get(variableAction.getVariableName());
            if (interestedActions == null || interestedActions.isEmpty()) continue;
            variableAction.setInterestedActions(interestedActions);
            for (MatcherAction interestedAction : interestedActions) {
                if (!hashSet.contains(interestedAction)) continue;
                throw new InvalidParserConfigurationException("Syntax error (" + this.matcherSourceLocation + "): The line >>" + interestedAction + "<< is referencing variable @" + variableAction.getVariableName() + " which is not defined yet.");
            }
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet seenVariableNames = new HashSet();
        hashSet.forEach(m -> seenVariableNames.add(((MatcherVariableAction)m).getVariableName()));
        for (String variableName : this.informMatcherActionsAboutVariables.keySet()) {
            if (seenVariableNames.contains(variableName)) continue;
            hashSet2.add(variableName);
        }
        if (!hashSet2.isEmpty()) {
            throw new InvalidParserConfigurationException("Syntax error (" + this.matcherSourceLocation + "): Used, yet undefined variables: " + hashSet2);
        }
        this.dynamicActions.addAll(0, this.variableActions);
        this.actionsThatRequireInput = this.countActionsThatMustHaveMatches(this.dynamicActions);
        long initFinish = System.nanoTime();
        if (newEntries > 3000L) {
            LOG.warn("Large matcher: {} in {} ms:.({})", new Object[]{newEntries, (initFinish - initStart) / 1000000L, this.matcherSourceLocation});
        }
        if (this.verbose) {
            LOG.info("---------------------------");
        }
    }

    private long countActionsThatMustHaveMatches(List<? extends MatcherAction> actions) {
        long actionsThatMustHaveMatches = 0L;
        for (MatcherAction matcherAction : actions) {
            matcherAction.reset();
            if (!matcherAction.mustHaveMatches()) continue;
            ++actionsThatMustHaveMatches;
        }
        return actionsThatMustHaveMatches;
    }

    public Set<String> getAllPossibleFieldNames() {
        TreeSet<String> results = new TreeSet<String>();
        results.addAll(this.getAllPossibleFieldNames(this.dynamicActions));
        results.addAll(this.getAllPossibleFieldNames(this.fixedStringActions));
        results.remove("__Set_ALL_Fields__");
        return results;
    }

    private Set<String> getAllPossibleFieldNames(List<MatcherAction> actions) {
        TreeSet<String> results = new TreeSet<String>();
        for (MatcherAction action : actions) {
            if (!(action instanceof MatcherExtractAction)) continue;
            MatcherExtractAction extractAction = (MatcherExtractAction)action;
            results.add(extractAction.getAttribute());
        }
        return results;
    }

    public void lookingForRange(String treeName, WordRangeVisitor.Range range) {
        this.analyzer.lookingForRange(treeName, range);
    }

    public void informMeAbout(MatcherAction matcherAction, String keyPattern) {
        this.analyzer.informMeAbout(matcherAction, keyPattern);
    }

    public void informMeAboutPrefix(MatcherAction matcherAction, String keyPattern, String prefix) {
        this.analyzer.informMeAboutPrefix(matcherAction, keyPattern, prefix);
    }

    void informMeAboutVariable(MatcherAction matcherAction, String variableName) {
        Set analyzerSet = this.informMatcherActionsAboutVariables.computeIfAbsent(variableName, k -> new LinkedHashSet());
        analyzerSet.add(matcherAction);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void analyze(UserAgent userAgent) {
        if (this.verbose) {
            LOG.info("");
            LOG.info("--- Matcher.({}) ------------------------", (Object)this.matcherSourceLocation);
            LOG.info("ANALYSE ----------------------------");
            boolean good = true;
            for (MatcherAction action : this.dynamicActions) {
                if (!action.cannotBeValid()) continue;
                LOG.error("CANNOT BE VALID : {}", (Object)action.getMatchExpression());
                good = false;
            }
            for (MatcherAction action : this.dynamicActions) {
                if (action.obtainResult()) continue;
                LOG.error("FAILED : {}", (Object)action.getMatchExpression());
                good = false;
            }
            if (!good) {
                LOG.info("INCOMPLETE ----------------------------");
                return;
            }
            LOG.info("COMPLETE ----------------------------");
        } else {
            if (this.actionsThatRequireInput != this.actionsThatRequireInputAndReceivedInput) {
                return;
            }
            for (MatcherAction action : this.dynamicActions) {
                if (action.obtainResult()) continue;
                return;
            }
        }
        userAgent.set(this.newValuesUserAgent, this);
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    void receivedInput() {
        if (this.alreadyNotifiedAnalyzerWeReceivedInput) {
            return;
        }
        this.analyzer.receivedInput(this);
        this.alreadyNotifiedAnalyzerWeReceivedInput = true;
    }

    public long getActionsThatRequireInput() {
        return this.actionsThatRequireInput;
    }

    void gotMyFirstStartingPoint() {
        ++this.actionsThatRequireInputAndReceivedInput;
    }

    public void setVerboseTemporarily(boolean newVerbose) {
        for (MatcherAction action : this.dynamicActions) {
            action.setVerbose(newVerbose, true);
        }
    }

    public void reset() {
        this.alreadyNotifiedAnalyzerWeReceivedInput = false;
        this.actionsThatRequireInputAndReceivedInput = 0L;
        this.verbose = this.permanentVerbose;
        for (MatcherAction action : this.dynamicActions) {
            action.reset();
        }
    }

    public List<MatchesList.Match> getMatches() {
        ArrayList<MatchesList.Match> allMatches = new ArrayList<MatchesList.Match>(128);
        for (MatcherAction action : this.dynamicActions) {
            allMatches.addAll(action.getMatches());
        }
        return allMatches;
    }

    public List<MatchesList.Match> getUsedMatches() {
        ArrayList<MatchesList.Match> allMatches = new ArrayList<MatchesList.Match>(128);
        for (MatcherAction action : this.dynamicActions) {
            if (!action.cannotBeValid()) continue;
            return new ArrayList<MatchesList.Match>();
        }
        for (MatcherAction action : this.dynamicActions) {
            if (!action.obtainResult()) {
                return new ArrayList<MatchesList.Match>();
            }
            allMatches.addAll(action.getMatches());
        }
        return allMatches;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(512);
        sb.append("MATCHER.(").append(this.matcherSourceLocation).append("):\n").append("    VARIABLE:\n");
        for (MatcherAction action : this.dynamicActions) {
            if (!(action instanceof MatcherVariableAction)) continue;
            sb.append("        @").append(((MatcherVariableAction)action).getVariableName()).append(":    ").append(action.getMatchExpression()).append('\n');
            sb.append("        -->").append(action.getMatches().toStrings()).append('\n');
        }
        sb.append("    REQUIRE:\n");
        for (MatcherAction action : this.dynamicActions) {
            if (!(action instanceof MatcherRequireAction)) continue;
            sb.append("        ").append(action.getMatchExpression()).append('\n');
            if (action.getMatches() == null) continue;
            sb.append("        -->").append(action.getMatches().toStrings()).append('\n');
        }
        sb.append("    EXTRACT:\n");
        for (MatcherAction action : this.dynamicActions) {
            if (!(action instanceof MatcherExtractAction)) continue;
            sb.append("        ").append(action.toString()).append('\n');
            if (action.getMatches() == null) continue;
            sb.append("        -->").append(action.getMatches()).append('\n');
        }
        for (MatcherAction action : this.fixedStringActions) {
            sb.append("        ").append(action.toString()).append('\n');
        }
        return sb.toString();
    }

    static class ConfigLine {
        final Type type;
        final String attribute;
        final Long confidence;
        final String expression;

        ConfigLine(Type type, String attribute, Long confidence, String expression) {
            this.type = type;
            this.attribute = attribute;
            this.confidence = confidence;
            this.expression = expression;
        }

        public static enum Type {
            VARIABLE,
            REQUIRE,
            EXTRACT;

        }
    }
}

