/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.analyze;

import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.analyze.Matcher;
import nl.basjes.parse.useragent.analyze.MatcherAction;
import nl.basjes.parse.useragent.analyze.treewalker.steps.WalkList;
import nl.basjes.parse.useragent.parser.UserAgentTreeWalkerParser;
import nl.basjes.shaded.org.antlr.v4.runtime.ParserRuleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatcherExtractAction
extends MatcherAction {
    private static final Logger LOG = LoggerFactory.getLogger(MatcherExtractAction.class);
    private final String attribute;
    private final long confidence;
    private String foundValue = null;
    private String fixedValue = null;
    private final String expression;
    private UserAgent.AgentField resultAgentField;

    private MatcherExtractAction() {
        this.attribute = null;
        this.confidence = -1L;
        this.expression = null;
    }

    public MatcherExtractAction(String attribute, long confidence, String config, Matcher matcher) {
        this.attribute = attribute;
        this.confidence = confidence;
        this.expression = config;
        this.init(config, matcher);
    }

    public void setResultAgentField(UserAgent.AgentField newResultAgentField) {
        this.resultAgentField = newResultAgentField;
    }

    @Override
    protected ParserRuleContext parseWalkerExpression(UserAgentTreeWalkerParser parser) {
        return parser.matcherExtract();
    }

    public boolean isFixedValue() {
        return this.fixedValue != null;
    }

    @Override
    protected void setFixedValue(String newFixedValue) {
        if (this.verbose) {
            LOG.info("-- set Fixed value({} , {} , {})", new Object[]{this.attribute, this.confidence, newFixedValue});
        }
        this.fixedValue = newFixedValue;
    }

    public String getAttribute() {
        return this.attribute;
    }

    @Override
    public void inform(String key, WalkList.WalkResult newlyFoundValue) {
        if (this.verbose) {
            LOG.info("INFO  : EXTRACT ({}): {}", (Object)this.attribute, (Object)key);
            LOG.info("NEED  : EXTRACT ({}): {}", (Object)this.attribute, (Object)this.getMatchExpression());
        }
        if (this.foundValue == null) {
            this.foundValue = newlyFoundValue.getValue();
            if (this.verbose) {
                LOG.info("KEPT  : EXTRACT ({}): {}", (Object)this.attribute, (Object)key);
            }
        }
    }

    @Override
    public boolean obtainResult() {
        this.processInformedMatches();
        if (this.fixedValue != null) {
            if (this.verbose) {
                LOG.info("Set fixedvalue ({})[{}]: {}", new Object[]{this.attribute, this.confidence, this.fixedValue});
            }
            this.resultAgentField.setValueForced(this.fixedValue, this.confidence);
            return true;
        }
        if (this.foundValue != null) {
            if (this.verbose) {
                LOG.info("Set parsevalue ({})[{}]: {}", new Object[]{this.attribute, this.confidence, this.foundValue});
            }
            this.resultAgentField.setValueForced(this.foundValue, this.confidence);
            return true;
        }
        if (this.verbose) {
            LOG.info("Nothing found for {}", (Object)this.attribute);
        }
        return false;
    }

    @Override
    public void reset() {
        super.reset();
        this.foundValue = null;
    }

    @Override
    public String toString() {
        if (this.isFixedValue()) {
            return "Extract FIXED.(" + this.matcher.getMatcherSourceLocation() + "): (" + this.attribute + ", " + this.confidence + ") =   \"" + this.fixedValue + "\"";
        }
        return "Extract DYNAMIC.(" + this.matcher.getMatcherSourceLocation() + "): (" + this.attribute + ", " + this.confidence + "):    " + this.expression;
    }
}

