/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.calculate;

import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.calculate.FieldCalculator;

public class ConcatNONDuplicatedCalculator
implements FieldCalculator {
    private String targetName;
    private String firstName;
    private String secondName;

    public ConcatNONDuplicatedCalculator(String targetName, String firstName, String secondName) {
        this.targetName = targetName;
        this.firstName = firstName;
        this.secondName = secondName;
    }

    private ConcatNONDuplicatedCalculator() {
    }

    @Override
    public void calculate(UserAgent userAgent) {
        UserAgent.AgentField firstField = this.firstName == null ? null : userAgent.get(this.firstName);
        UserAgent.AgentField secondField = this.secondName == null ? null : userAgent.get(this.secondName);
        String first = null;
        long firstConfidence = -1L;
        String second = null;
        long secondConfidence = -1L;
        if (firstField != null) {
            first = firstField.getValue();
            firstConfidence = firstField.getConfidence();
        }
        if (secondField != null) {
            second = secondField.getValue();
            secondConfidence = secondField.getConfidence();
        }
        if (first == null && second == null) {
            return;
        }
        if (second == null) {
            if (firstConfidence >= 0L) {
                userAgent.set(this.targetName, first, firstConfidence);
            } else {
                userAgent.setForced(this.targetName, "Unknown", firstConfidence);
            }
            return;
        }
        if (first == null) {
            if (secondConfidence >= 0L) {
                userAgent.set(this.targetName, second, secondConfidence);
            } else {
                userAgent.setForced(this.targetName, "Unknown", secondConfidence);
            }
            return;
        }
        if (first.equals(second)) {
            userAgent.set(this.targetName, first, firstConfidence);
        } else if (second.startsWith(first)) {
            userAgent.set(this.targetName, second, secondConfidence);
        } else {
            String value = first + " " + second;
            long confidence = Math.max(firstConfidence, secondConfidence);
            if (confidence < 0L) {
                userAgent.setForced(this.targetName, value, confidence);
            } else {
                userAgent.set(this.targetName, value, confidence);
            }
        }
    }

    public String toString() {
        return "Calculate [ " + this.firstName + " + " + this.secondName + " ] --> " + this.targetName;
    }
}

