/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.utils;

import nl.basjes.parse.useragent.utils.Splitter;

public final class VersionSplitter
extends Splitter {
    private static VersionSplitter instance;

    private VersionSplitter() {
    }

    public static VersionSplitter getInstance() {
        if (instance == null) {
            instance = new VersionSplitter();
        }
        return instance;
    }

    @Override
    public boolean isSeparator(char c) {
        switch (c) {
            case '-': 
            case '.': 
            case '_': 
            case '|': {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isEndOfStringSeparator(char c) {
        return false;
    }

    private boolean looksLikeEmailOrWebaddress(String value) {
        return value.startsWith("www.") || value.startsWith("http") || value.contains("@") && value.contains(".");
    }

    @Override
    public String getSingleSplit(String value, int split) {
        if (this.looksLikeEmailOrWebaddress(value)) {
            return split == 1 ? value : null;
        }
        char[] characters = value.toCharArray();
        int start = this.findSplitStart(characters, split);
        if (start == -1) {
            return null;
        }
        int end = this.findSplitEnd(characters, start);
        return value.substring(start, end);
    }

    @Override
    public String getFirstSplits(String value, int split) {
        if (this.looksLikeEmailOrWebaddress(value)) {
            return split == 1 ? value : null;
        }
        char[] characters = value.toCharArray();
        int start = this.findSplitStart(characters, split);
        if (start == -1) {
            return null;
        }
        int end = this.findSplitEnd(characters, start);
        return value.substring(0, end);
    }
}

