/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.utils;

import java.util.Arrays;
import java.util.List;
import nl.basjes.parse.useragent.analyze.InvalidParserConfigurationException;
import nl.basjes.parse.useragent.utils.YamlUtils;
import nl.basjes.shaded.org.yaml.snakeyaml.nodes.MappingNode;
import nl.basjes.shaded.org.yaml.snakeyaml.nodes.Node;
import nl.basjes.shaded.org.yaml.snakeyaml.nodes.NodeTuple;
import nl.basjes.shaded.org.yaml.snakeyaml.nodes.SequenceNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class YauaaVersion {
    private static final Logger LOG = LoggerFactory.getLogger(YauaaVersion.class);

    private YauaaVersion() {
    }

    public static void logVersion(String ... extraLines) {
        YauaaVersion.logVersion(Arrays.asList(extraLines));
    }

    public static void logVersion(List<String> extraLines) {
        String[] lines = new String[]{"For more information: https://yauaa.basjes.nl", "Copyright (C) 2013-2020 Niels Basjes - License Apache 2.0"};
        String version = YauaaVersion.getVersion();
        int width = version.length();
        for (String string : lines) {
            width = Math.max(width, string.length());
        }
        for (String line : extraLines) {
            width = Math.max(width, line.length());
        }
        LOG.info("");
        LOG.info("/-{}-\\", (Object)YauaaVersion.padding('-', width));
        YauaaVersion.logLine(version, width);
        LOG.info("+-{}-+", (Object)YauaaVersion.padding('-', width));
        for (String string : lines) {
            YauaaVersion.logLine(string, width);
        }
        if (!extraLines.isEmpty()) {
            LOG.info("+-{}-+", (Object)YauaaVersion.padding('-', width));
            for (String line : extraLines) {
                YauaaVersion.logLine(line, width);
            }
        }
        LOG.info("\\-{}-/", (Object)YauaaVersion.padding('-', width));
        LOG.info("");
    }

    private static String padding(char letter, int count) {
        StringBuilder sb = new StringBuilder(128);
        for (int i = 0; i < count; ++i) {
            sb.append(letter);
        }
        return sb.toString();
    }

    private static void logLine(String line, int width) {
        LOG.info("| {}{} |", (Object)line, (Object)YauaaVersion.padding(' ', width - line.length()));
    }

    public static String getVersion() {
        return YauaaVersion.getVersion("5.16", "v5.16", "2020-03-30T14:07:52Z");
    }

    public static String getVersion(String projectVersion, String gitCommitIdDescribeShort, String buildTimestamp) {
        return "Yauaa " + projectVersion + " (" + gitCommitIdDescribeShort + " @ " + buildTimestamp + ")";
    }

    public static void assertSameVersion(NodeTuple versionNodeTuple, String filename) {
        SequenceNode versionNode = YamlUtils.getValueAsSequenceNode(versionNodeTuple, filename);
        String gitCommitIdDescribeShort = null;
        String buildTimestamp = null;
        String projectVersion = null;
        List<Node> versionList = versionNode.getValue();
        block14: for (Node versionEntry : versionList) {
            YamlUtils.requireNodeInstanceOf(MappingNode.class, versionEntry, filename, "The entry MUST be a mapping");
            NodeTuple entry = YamlUtils.getExactlyOneNodeTuple((MappingNode)versionEntry, filename);
            String key = YamlUtils.getKeyAsString(entry, filename);
            String value = YamlUtils.getValueAsString(entry, filename);
            switch (key) {
                case "git_commit_id_describe_short": {
                    gitCommitIdDescribeShort = value;
                    continue block14;
                }
                case "build_timestamp": {
                    buildTimestamp = value;
                    continue block14;
                }
                case "project_version": {
                    projectVersion = value;
                    continue block14;
                }
                case "copyright": 
                case "license": 
                case "url": {
                    continue block14;
                }
            }
            throw new InvalidParserConfigurationException("Yaml config.(" + filename + ":" + versionNode.getStartMark().getLine() + "): Found unexpected config entry: " + key + ", allowed are 'git_commit_id_describe_short', 'build_timestamp' and 'project_version'");
        }
        YauaaVersion.assertSameVersion(gitCommitIdDescribeShort, buildTimestamp, projectVersion);
    }

    public static void assertSameVersion(String gitCommitIdDescribeShort, String buildTimestamp, String projectVersion) {
        if ("v5.16".equals(gitCommitIdDescribeShort) && "2020-03-30T14:07:52Z".equals(buildTimestamp) && "5.16".equals(projectVersion)) {
            return;
        }
        String libraryVersion = YauaaVersion.getVersion("5.16", "v5.16", "2020-03-30T14:07:52Z");
        String rulesVersion = YauaaVersion.getVersion(projectVersion, gitCommitIdDescribeShort, buildTimestamp);
        LOG.error("===============================================");
        LOG.error("==========        FATAL ERROR       ===========");
        LOG.error("vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv");
        LOG.error("");
        LOG.error("Two different Yauaa versions have been loaded:");
        LOG.error("Runtime Library: {}", (Object)libraryVersion);
        LOG.error("Rule sets      : {}", (Object)rulesVersion);
        LOG.error("");
        LOG.error("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
        LOG.error("===============================================");
        throw new InvalidParserConfigurationException("Two different Yauaa versions have been loaded: \nRuntime Library: " + libraryVersion + "\nRule sets      : " + rulesVersion + "\n");
    }
}

