/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent;

import java.io.Serializable;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.UserAgentAnalyzerDirect;
import org.apache.commons.collections4.map.LRUMap;

public class UserAgentAnalyzer
extends UserAgentAnalyzerDirect
implements Serializable {
    private static final int DEFAULT_PARSE_CACHE_SIZE = 10000;
    private int cacheSize = 10000;
    private LRUMap<String, UserAgent> parseCache = null;

    protected UserAgentAnalyzer() {
        this.initializeCache();
    }

    public void disableCaching() {
        this.setCacheSize(0);
    }

    public void setCacheSize(int newCacheSize) {
        this.cacheSize = newCacheSize > 0 ? newCacheSize : 0;
        this.initializeCache();
    }

    private void initializeCache() {
        this.parseCache = this.cacheSize >= 1 ? new LRUMap(this.cacheSize) : null;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    @Override
    public synchronized UserAgent parse(UserAgent userAgent) {
        if (userAgent == null) {
            return null;
        }
        userAgent.reset();
        if (this.parseCache == null) {
            return super.parse(userAgent);
        }
        String userAgentString = userAgent.getUserAgentString();
        UserAgent cachedValue = (UserAgent)this.parseCache.get((Object)userAgentString);
        if (cachedValue != null) {
            userAgent.clone(cachedValue);
        } else {
            cachedValue = new UserAgent(super.parse(userAgent));
            this.parseCache.put((Object)userAgentString, (Object)cachedValue);
        }
        return userAgent;
    }

    public static UserAgentAnalyzerBuilder<? extends UserAgentAnalyzer, ? extends UserAgentAnalyzerBuilder<?, ?>> newBuilder() {
        return new UserAgentAnalyzerBuilder(new UserAgentAnalyzer());
    }

    public static class UserAgentAnalyzerBuilder<UAA extends UserAgentAnalyzer, B extends UserAgentAnalyzerBuilder<UAA, B>>
    extends UserAgentAnalyzerDirect.UserAgentAnalyzerDirectBuilder<UAA, B> {
        private final UAA uaa;

        public UserAgentAnalyzerBuilder(UAA newUaa) {
            super(newUaa);
            this.uaa = newUaa;
        }

        public B withCache(int newCacheSize) {
            this.failIfAlreadyBuilt();
            ((UserAgentAnalyzer)this.uaa).setCacheSize(newCacheSize);
            return (B)this;
        }

        public B withoutCache() {
            this.failIfAlreadyBuilt();
            ((UserAgentAnalyzer)this.uaa).setCacheSize(0);
            return (B)this;
        }

        @Override
        public UAA build() {
            return (UAA)((UserAgentAnalyzer)super.build());
        }
    }
}

