/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.analyze;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import nl.basjes.parse.useragent.analyze.InvalidParserConfigurationException;
import nl.basjes.parse.useragent.analyze.Matcher;
import nl.basjes.parse.useragent.analyze.MatchesList;
import nl.basjes.parse.useragent.analyze.NumberRangeList;
import nl.basjes.parse.useragent.analyze.NumberRangeVisitor;
import nl.basjes.parse.useragent.analyze.WordRangeVisitor;
import nl.basjes.parse.useragent.analyze.treewalker.TreeExpressionEvaluator;
import nl.basjes.parse.useragent.analyze.treewalker.steps.WalkList;
import nl.basjes.parse.useragent.parser.UserAgentTreeWalkerBaseVisitor;
import nl.basjes.parse.useragent.parser.UserAgentTreeWalkerLexer;
import nl.basjes.parse.useragent.parser.UserAgentTreeWalkerParser;
import nl.basjes.parse.useragent.utils.DefaultANTLRErrorListener;
import nl.basjes.shaded.org.antlr.v4.runtime.CharStreams;
import nl.basjes.shaded.org.antlr.v4.runtime.CodePointCharStream;
import nl.basjes.shaded.org.antlr.v4.runtime.CommonToken;
import nl.basjes.shaded.org.antlr.v4.runtime.CommonTokenStream;
import nl.basjes.shaded.org.antlr.v4.runtime.ParserRuleContext;
import nl.basjes.shaded.org.antlr.v4.runtime.RecognitionException;
import nl.basjes.shaded.org.antlr.v4.runtime.Recognizer;
import nl.basjes.shaded.org.antlr.v4.runtime.Token;
import nl.basjes.shaded.org.antlr.v4.runtime.tree.ParseTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MatcherAction
implements Serializable {
    private String matchExpression;
    protected TreeExpressionEvaluator evaluator;
    private static final Logger LOG = LoggerFactory.getLogger(MatcherAction.class);
    private Matcher matcher;
    private MatchesList matches;
    private boolean mustHaveMatches = false;
    boolean verbose = false;
    private boolean verbosePermanent = false;
    private boolean verboseTemporary = false;
    private static final Map<Class, CalculateInformPathFunction> CALCULATE_INFORM_PATH = new HashMap<Class, CalculateInformPathFunction>();

    TreeExpressionEvaluator getEvaluatorForUnitTesting() {
        return this.evaluator;
    }

    boolean mustHaveMatches() {
        return this.mustHaveMatches;
    }

    private void setVerbose(boolean newVerbose) {
        this.setVerbose(newVerbose, false);
    }

    public void setVerbose(boolean newVerbose, boolean temporary) {
        this.verbose = newVerbose;
        if (!temporary) {
            this.verbosePermanent = newVerbose;
        }
        this.verboseTemporary = temporary;
    }

    public String getMatchExpression() {
        return this.matchExpression;
    }

    void init(String newMatchExpression, Matcher newMatcher) {
        this.matcher = newMatcher;
        this.matchExpression = newMatchExpression;
        this.setVerbose(newMatcher.getVerbose());
    }

    public void initialize() {
        InitErrorListener errorListener = new InitErrorListener();
        CodePointCharStream input = CharStreams.fromString(this.matchExpression);
        UserAgentTreeWalkerLexer lexer = new UserAgentTreeWalkerLexer(input);
        lexer.addErrorListener(errorListener);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        UserAgentTreeWalkerParser parser = new UserAgentTreeWalkerParser(tokens);
        parser.addErrorListener(errorListener);
        ParserRuleContext requiredPattern = this.parseWalkerExpression(parser);
        new UnQuoteValues().visit(requiredPattern);
        this.evaluator = new TreeExpressionEvaluator(requiredPattern, this.matcher, this.verbose);
        String fixedValue = this.evaluator.getFixedValue();
        if (fixedValue != null) {
            this.setFixedValue(fixedValue);
            this.mustHaveMatches = false;
            this.matches = new MatchesList(0);
            return;
        }
        this.mustHaveMatches = !this.evaluator.usesIsNull();
        int informs = MatcherAction.calculateInformPath(this, "agent", requiredPattern);
        if (this.mustHaveMatches && informs == 0) {
            this.mustHaveMatches = false;
        }
        int listSize = 0;
        if (informs > 0) {
            listSize = 1;
        }
        this.matches = new MatchesList(listSize);
    }

    protected abstract ParserRuleContext parseWalkerExpression(UserAgentTreeWalkerParser var1);

    protected abstract void setFixedValue(String var1);

    public void inform(String key, String value, ParseTree result) {
        if (this.mustHaveMatches && this.matches.isEmpty()) {
            this.matcher.gotMyFirstStartingPoint();
        }
        this.matches.add(key, value, result);
    }

    protected abstract void inform(String var1, WalkList.WalkResult var2);

    boolean cannotBeValid() {
        return this.mustHaveMatches && this.matches.isEmpty();
    }

    public abstract boolean obtainResult();

    boolean isValidIsNull() {
        return this.matches.isEmpty() && this.evaluator.usesIsNull();
    }

    void processInformedMatches() {
        for (MatchesList.Match match : this.matches) {
            WalkList.WalkResult matchedValue = this.evaluator.evaluate(match.getResult(), match.getKey(), match.getValue());
            if (matchedValue == null) continue;
            this.inform(match.getKey(), matchedValue);
            break;
        }
    }

    private static int calculateInformPath(MatcherAction action, String treeName, ParserRuleContext tree) {
        if (tree == null) {
            action.matcher.informMeAbout(action, treeName);
            return 1;
        }
        CalculateInformPathFunction function = CALCULATE_INFORM_PATH.get(tree.getClass());
        if (function != null) {
            return function.calculateInformPath(action, treeName, tree);
        }
        action.matcher.informMeAbout(action, treeName);
        return 1;
    }

    public void reset() {
        this.matches.clear();
        if (this.verboseTemporary) {
            this.verbose = this.verbosePermanent;
        }
    }

    public MatchesList getMatches() {
        return this.matches;
    }

    static {
        CALCULATE_INFORM_PATH.put(UserAgentTreeWalkerParser.MatcherBaseContext.class, (action, treeName, tree) -> MatcherAction.calculateInformPath(action, treeName, ((UserAgentTreeWalkerParser.MatcherBaseContext)tree).matcher()));
        CALCULATE_INFORM_PATH.put(UserAgentTreeWalkerParser.MatcherPathIsNullContext.class, (action, treeName, tree) -> MatcherAction.calculateInformPath(action, treeName, ((UserAgentTreeWalkerParser.MatcherPathIsNullContext)tree).matcher()));
        CALCULATE_INFORM_PATH.put(UserAgentTreeWalkerParser.MatcherExtractContext.class, (action, treeName, tree) -> MatcherAction.calculateInformPath(action, treeName, ((UserAgentTreeWalkerParser.MatcherExtractContext)tree).expression));
        CALCULATE_INFORM_PATH.put(UserAgentTreeWalkerParser.MatcherVariableContext.class, (action, treeName, tree) -> MatcherAction.calculateInformPath(action, treeName, ((UserAgentTreeWalkerParser.MatcherVariableContext)tree).expression));
        CALCULATE_INFORM_PATH.put(UserAgentTreeWalkerParser.MatcherPathContext.class, (action, treeName, tree) -> MatcherAction.calculateInformPath(action, treeName, ((UserAgentTreeWalkerParser.MatcherPathContext)tree).basePath()));
        CALCULATE_INFORM_PATH.put(UserAgentTreeWalkerParser.MatcherConcatContext.class, (action, treeName, tree) -> MatcherAction.calculateInformPath(action, treeName, ((UserAgentTreeWalkerParser.MatcherConcatContext)tree).matcher()));
        CALCULATE_INFORM_PATH.put(UserAgentTreeWalkerParser.MatcherConcatPrefixContext.class, (action, treeName, tree) -> MatcherAction.calculateInformPath(action, treeName, ((UserAgentTreeWalkerParser.MatcherConcatPrefixContext)tree).matcher()));
        CALCULATE_INFORM_PATH.put(UserAgentTreeWalkerParser.MatcherConcatPostfixContext.class, (action, treeName, tree) -> MatcherAction.calculateInformPath(action, treeName, ((UserAgentTreeWalkerParser.MatcherConcatPostfixContext)tree).matcher()));
        CALCULATE_INFORM_PATH.put(UserAgentTreeWalkerParser.MatcherNormalizeBrandContext.class, (action, treeName, tree) -> MatcherAction.calculateInformPath(action, treeName, ((UserAgentTreeWalkerParser.MatcherNormalizeBrandContext)tree).matcher()));
        CALCULATE_INFORM_PATH.put(UserAgentTreeWalkerParser.MatcherCleanVersionContext.class, (action, treeName, tree) -> MatcherAction.calculateInformPath(action, treeName, ((UserAgentTreeWalkerParser.MatcherCleanVersionContext)tree).matcher()));
        CALCULATE_INFORM_PATH.put(UserAgentTreeWalkerParser.MatcherPathLookupContext.class, (action, treeName, tree) -> MatcherAction.calculateInformPath(action, treeName, ((UserAgentTreeWalkerParser.MatcherPathLookupContext)tree).matcher()));
        CALCULATE_INFORM_PATH.put(UserAgentTreeWalkerParser.MatcherWordRangeContext.class, (action, treeName, tree) -> MatcherAction.calculateInformPath(action, treeName, ((UserAgentTreeWalkerParser.MatcherWordRangeContext)tree).matcher()));
        CALCULATE_INFORM_PATH.put(UserAgentTreeWalkerParser.PathVariableContext.class, (action, treeName, tree) -> {
            action.matcher.informMeAboutVariable(action, ((UserAgentTreeWalkerParser.PathVariableContext)tree).variable.getText());
            return 0;
        });
        CALCULATE_INFORM_PATH.put(UserAgentTreeWalkerParser.PathWalkContext.class, (action, treeName, tree) -> MatcherAction.calculateInformPath(action, treeName, ((UserAgentTreeWalkerParser.PathWalkContext)tree).nextStep));
        CALCULATE_INFORM_PATH.put(UserAgentTreeWalkerParser.StepDownContext.class, (action, treeName, tree) -> {
            UserAgentTreeWalkerParser.StepDownContext thisTree = (UserAgentTreeWalkerParser.StepDownContext)tree;
            int informs = 0;
            Iterator iterator = ((NumberRangeList)NumberRangeVisitor.NUMBER_RANGE_VISITOR.visit(thisTree.numberRange())).iterator();
            while (iterator.hasNext()) {
                int number = (Integer)iterator.next();
                informs += MatcherAction.calculateInformPath(action, treeName + '.' + "(" + number + ")" + thisTree.name.getText(), thisTree.nextStep);
            }
            return informs;
        });
        CALCULATE_INFORM_PATH.put(UserAgentTreeWalkerParser.StepEqualsValueContext.class, (action, treeName, tree) -> {
            UserAgentTreeWalkerParser.StepEqualsValueContext thisTree = (UserAgentTreeWalkerParser.StepEqualsValueContext)tree;
            action.matcher.informMeAbout(action, treeName + "=\"" + thisTree.value.getText() + "\"");
            return 1;
        });
        CALCULATE_INFORM_PATH.put(UserAgentTreeWalkerParser.StepStartsWithValueContext.class, (action, treeName, tree) -> {
            UserAgentTreeWalkerParser.StepStartsWithValueContext thisTree = (UserAgentTreeWalkerParser.StepStartsWithValueContext)tree;
            action.matcher.informMeAboutPrefix(action, treeName, thisTree.value.getText());
            return 1;
        });
        CALCULATE_INFORM_PATH.put(UserAgentTreeWalkerParser.StepWordRangeContext.class, (action, treeName, tree) -> {
            UserAgentTreeWalkerParser.StepWordRangeContext thisTree = (UserAgentTreeWalkerParser.StepWordRangeContext)tree;
            WordRangeVisitor.Range range = WordRangeVisitor.getRange(thisTree.wordRange());
            action.matcher.lookingForRange(treeName, range);
            return MatcherAction.calculateInformPath(action, treeName + range, thisTree.nextStep);
        });
    }

    @FunctionalInterface
    public static interface CalculateInformPathFunction {
        public int calculateInformPath(MatcherAction var1, String var2, ParserRuleContext var3);
    }

    private static class UnQuoteValues
    extends UserAgentTreeWalkerBaseVisitor<Void> {
        private UnQuoteValues() {
        }

        private void unQuoteToken(Token token) {
            if (token instanceof CommonToken) {
                CommonToken commonToken = (CommonToken)token;
                commonToken.setStartIndex(commonToken.getStartIndex() + 1);
                commonToken.setStopIndex(commonToken.getStopIndex() - 1);
            }
        }

        @Override
        public Void visitMatcherPathLookup(UserAgentTreeWalkerParser.MatcherPathLookupContext ctx) {
            this.unQuoteToken(ctx.defaultValue);
            return (Void)super.visitMatcherPathLookup(ctx);
        }

        @Override
        public Void visitPathFixedValue(UserAgentTreeWalkerParser.PathFixedValueContext ctx) {
            this.unQuoteToken(ctx.value);
            return (Void)super.visitPathFixedValue(ctx);
        }

        @Override
        public Void visitMatcherConcat(UserAgentTreeWalkerParser.MatcherConcatContext ctx) {
            this.unQuoteToken(ctx.prefix);
            this.unQuoteToken(ctx.postfix);
            return (Void)super.visitMatcherConcat(ctx);
        }

        @Override
        public Void visitMatcherConcatPrefix(UserAgentTreeWalkerParser.MatcherConcatPrefixContext ctx) {
            this.unQuoteToken(ctx.prefix);
            return (Void)super.visitMatcherConcatPrefix(ctx);
        }

        @Override
        public Void visitMatcherConcatPostfix(UserAgentTreeWalkerParser.MatcherConcatPostfixContext ctx) {
            this.unQuoteToken(ctx.postfix);
            return (Void)super.visitMatcherConcatPostfix(ctx);
        }

        @Override
        public Void visitStepEqualsValue(UserAgentTreeWalkerParser.StepEqualsValueContext ctx) {
            this.unQuoteToken(ctx.value);
            return (Void)super.visitStepEqualsValue(ctx);
        }

        @Override
        public Void visitStepNotEqualsValue(UserAgentTreeWalkerParser.StepNotEqualsValueContext ctx) {
            this.unQuoteToken(ctx.value);
            return (Void)super.visitStepNotEqualsValue(ctx);
        }

        @Override
        public Void visitStepStartsWithValue(UserAgentTreeWalkerParser.StepStartsWithValueContext ctx) {
            this.unQuoteToken(ctx.value);
            return (Void)super.visitStepStartsWithValue(ctx);
        }

        @Override
        public Void visitStepEndsWithValue(UserAgentTreeWalkerParser.StepEndsWithValueContext ctx) {
            this.unQuoteToken(ctx.value);
            return (Void)super.visitStepEndsWithValue(ctx);
        }

        @Override
        public Void visitStepContainsValue(UserAgentTreeWalkerParser.StepContainsValueContext ctx) {
            this.unQuoteToken(ctx.value);
            return (Void)super.visitStepContainsValue(ctx);
        }
    }

    class InitErrorListener
    implements DefaultANTLRErrorListener {
        InitErrorListener() {
        }

        @Override
        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            LOG.error("Syntax error");
            LOG.error("Source : {}", (Object)MatcherAction.this.matchExpression);
            LOG.error("Message: {}", (Object)msg);
            throw new InvalidParserConfigurationException("Syntax error \"" + msg + "\" caused by \"" + MatcherAction.this.matchExpression + "\".");
        }
    }
}

