/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.analyze;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import nl.basjes.shaded.org.antlr.v4.runtime.tree.ParseTree;

public final class MatchesList
implements Collection<Match>,
Serializable {
    private int size;
    private int maxSize;
    private Match[] allElements;
    private static final int CAPACITY_INCREASE = 3;

    public MatchesList(int newMaxSize) {
        this.maxSize = newMaxSize;
        this.size = 0;
        this.allElements = new Match[this.maxSize];
        for (int i = 0; i < this.maxSize; ++i) {
            this.allElements[i] = new Match(null, null, null);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    public boolean add(String key, String value, ParseTree result) {
        if (this.size >= this.maxSize) {
            this.increaseCapacity();
        }
        this.allElements[this.size].fill(key, value, result);
        ++this.size;
        return true;
    }

    @Override
    public Iterator<Match> iterator() {
        return new Iterator<Match>(){
            int offset = 0;

            @Override
            public boolean hasNext() {
                return this.offset < MatchesList.this.size;
            }

            @Override
            public Match next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("Array index out of bounds");
                }
                return MatchesList.this.allElements[this.offset++];
            }
        };
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.allElements, this.size);
    }

    private void increaseCapacity() {
        int newMaxSize = this.maxSize + 3;
        Match[] newAllElements = new Match[newMaxSize];
        System.arraycopy(this.allElements, 0, newAllElements, 0, this.maxSize);
        for (int i = this.maxSize; i < newMaxSize; ++i) {
            newAllElements[i] = new Match(null, null, null);
        }
        this.allElements = newAllElements;
        this.maxSize = newMaxSize;
    }

    public List<String> toStrings() {
        ArrayList<String> result = new ArrayList<String>(this.size);
        for (Match match : this) {
            result.add("{ \"" + match.key + "\"=\"" + match.value + "\" }");
        }
        return result;
    }

    @Override
    public boolean add(Match match) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends Match> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        throw new UnsupportedOperationException();
    }

    public static final class Match
    implements Serializable {
        private String key;
        private String value;
        private ParseTree result;

        public Match(String key, String value, ParseTree result) {
            this.fill(key, value, result);
        }

        public void fill(String nKey, String nValue, ParseTree nResult) {
            this.key = nKey;
            this.value = nValue;
            this.result = nResult;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public ParseTree getResult() {
            return this.result;
        }
    }
}

