/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.analyze;

import java.io.Serializable;
import java.util.Objects;
import nl.basjes.parse.useragent.parser.UserAgentTreeWalkerBaseVisitor;
import nl.basjes.parse.useragent.parser.UserAgentTreeWalkerParser;

public final class WordRangeVisitor
extends UserAgentTreeWalkerBaseVisitor<Range> {
    private static final WordRangeVisitor WORD_RANGE_VISITOR = new WordRangeVisitor();

    private WordRangeVisitor() {
    }

    public static Range getRange(UserAgentTreeWalkerParser.WordRangeContext ctx) {
        return (Range)WORD_RANGE_VISITOR.visit(ctx);
    }

    @Override
    public Range visitWordRangeStartToEnd(UserAgentTreeWalkerParser.WordRangeStartToEndContext ctx) {
        return new Range(Integer.parseInt(ctx.firstWord.getText()), Integer.parseInt(ctx.lastWord.getText()));
    }

    @Override
    public Range visitWordRangeFirstWords(UserAgentTreeWalkerParser.WordRangeFirstWordsContext ctx) {
        return new Range(1, Integer.parseInt(ctx.lastWord.getText()));
    }

    @Override
    public Range visitWordRangeLastWords(UserAgentTreeWalkerParser.WordRangeLastWordsContext ctx) {
        return new Range(Integer.parseInt(ctx.firstWord.getText()), -1);
    }

    @Override
    public Range visitWordRangeSingleWord(UserAgentTreeWalkerParser.WordRangeSingleWordContext ctx) {
        int wordNumber = Integer.parseInt(ctx.singleWord.getText());
        return new Range(wordNumber, wordNumber);
    }

    public static class Range
    implements Serializable {
        private final int first;
        private final int last;
        private String rangeString = null;

        public Range(int first, int last) {
            this.first = first;
            this.last = last;
        }

        public int getFirst() {
            return this.first;
        }

        public int getLast() {
            return this.last;
        }

        public String toString() {
            if (this.rangeString == null) {
                this.rangeString = this.last == -1 ? "[" + this.first + "-]" : "[" + this.first + "-" + this.last + "]";
            }
            return this.rangeString;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Range)) {
                return false;
            }
            Range range = (Range)o;
            return this.first == range.first && this.last == range.last;
        }

        public int hashCode() {
            return Objects.hash(this.first, this.last);
        }
    }
}

