/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.analyze.treewalker;

import java.io.Serializable;
import java.util.Map;
import nl.basjes.parse.useragent.analyze.InvalidParserConfigurationException;
import nl.basjes.parse.useragent.analyze.Matcher;
import nl.basjes.parse.useragent.analyze.treewalker.steps.WalkList;
import nl.basjes.parse.useragent.parser.UserAgentTreeWalkerBaseVisitor;
import nl.basjes.parse.useragent.parser.UserAgentTreeWalkerParser;
import nl.basjes.shaded.org.antlr.v4.runtime.ParserRuleContext;
import nl.basjes.shaded.org.antlr.v4.runtime.tree.ParseTree;
import nl.basjes.shaded.org.antlr.v4.runtime.tree.RuleNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeExpressionEvaluator
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(TreeExpressionEvaluator.class);
    private final boolean verbose;
    private final String requiredPatternText;
    private final Matcher matcher;
    private final WalkList walkList;
    private final String fixedValue;

    public TreeExpressionEvaluator(ParserRuleContext requiredPattern, Matcher matcher, boolean verbose) {
        this.requiredPatternText = requiredPattern.getText();
        this.matcher = matcher;
        this.verbose = verbose;
        this.fixedValue = this.calculateFixedValue(requiredPattern);
        this.walkList = new WalkList(requiredPattern, matcher.getLookups(), matcher.getLookupSets(), verbose);
    }

    public String getFixedValue() {
        return this.fixedValue;
    }

    private String calculateFixedValue(ParserRuleContext requiredPattern) {
        return (String)new UserAgentTreeWalkerBaseVisitor<String>(){

            @Override
            protected boolean shouldVisitNextChild(RuleNode node, String currentResult) {
                return currentResult == null;
            }

            @Override
            protected String aggregateResult(String aggregate, String nextResult) {
                return nextResult == null ? aggregate : nextResult;
            }

            @Override
            public String visitMatcherPathLookup(UserAgentTreeWalkerParser.MatcherPathLookupContext ctx) {
                String value = (String)this.visit(ctx.matcher());
                if (value == null) {
                    return null;
                }
                Map<String, String> lookup = TreeExpressionEvaluator.this.matcher.getLookups().get(ctx.lookup.getText());
                if (lookup == null) {
                    throw new InvalidParserConfigurationException("Missing lookup \"" + ctx.lookup.getText() + "\" ");
                }
                String resultingValue = lookup.get(value.toLowerCase());
                if (resultingValue == null) {
                    if (ctx.defaultValue != null) {
                        return ctx.defaultValue.getText();
                    }
                    throw new InvalidParserConfigurationException("Fixed value >>" + value + "<< is missing in lookup: \"" + ctx.lookup.getText() + "\" ");
                }
                return resultingValue;
            }

            @Override
            public String visitPathFixedValue(UserAgentTreeWalkerParser.PathFixedValueContext ctx) {
                return ctx.value.getText();
            }
        }.visit(requiredPattern);
    }

    public WalkList.WalkResult evaluate(ParseTree tree, String key, String value) {
        if (this.verbose) {
            LOG.info("Evaluate: {} => {}", (Object)key, (Object)value);
            LOG.info("Pattern : {}", (Object)this.requiredPatternText);
            LOG.info("WalkList: {}", (Object)this.walkList);
        }
        WalkList.WalkResult result = this.walkList.walk(tree, value);
        if (this.verbose) {
            LOG.info("Evaluate: Result = {}", (Object)(result == null ? "null" : result.getValue()));
        }
        return result;
    }

    public boolean usesIsNull() {
        return this.walkList.usesIsNull();
    }

    public WalkList getWalkListForUnitTesting() {
        return this.walkList;
    }

    public void pruneTrailingStepsThatCannotFail() {
        this.walkList.pruneTrailingStepsThatCannotFail();
    }
}

