/*
 * Yet Another UserAgent Analyzer
 * Copyright (C) 2013-2022 Niels Basjes
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package nl.basjes.parse.useragent;

import nl.basjes.parse.useragent.utils.YauaaVersion;

public final class Version extends YauaaVersion.AbstractVersion {

    private static final Version INSTANCE = new Version();

    public static Version getInstance() {
        return INSTANCE;
    }

    public static final String GIT_COMMIT_ID                = "440c1b119b6778ab9b6a8d1be169a75d8db8e103";
    public static final String GIT_COMMIT_ID_DESCRIBE_SHORT = "v6.12";
    public static final String BUILD_TIME_STAMP             = "2022-03-27T12:56:26Z";
    public static final String PROJECT_VERSION              = "6.12";
    public static final String COPYRIGHT                    = "Copyright (C) 2013-2022 Niels Basjes";
    public static final String LICENSE                      = "License Apache 2.0";
    public static final String URL                          = "https://yauaa.basjes.nl";
    public static final String BUILD_JDK_VERSION            = "17.0.2";
    public static final String TARGET_JRE_VERSION           = "1.8";

    @Override public String getGitCommitId()              { return GIT_COMMIT_ID;                }
    @Override public String getGitCommitIdDescribeShort() { return GIT_COMMIT_ID_DESCRIBE_SHORT; }
    @Override public String getBuildTimeStamp()           { return BUILD_TIME_STAMP;             }
    @Override public String getProjectVersion()           { return PROJECT_VERSION;              }
    @Override public String getCopyright()                { return COPYRIGHT;                    }
    @Override public String getLicense()                  { return LICENSE;                      }
    @Override public String getUrl()                      { return URL;                          }
    @Override public String getBuildJDKVersion()          { return BUILD_JDK_VERSION;            }
    @Override public String getTargetJREVersion()         { return TARGET_JRE_VERSION;           }
}
