/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.calculate;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import nl.basjes.parse.useragent.AgentField;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.calculate.FieldCalculator;

public class ConcatNONDuplicatedCalculator
extends FieldCalculator {
    private final String targetName;
    private final String firstName;
    private final String secondName;

    public ConcatNONDuplicatedCalculator(@Nonnull String targetName, @Nonnull String firstName, @Nonnull String secondName) {
        this.targetName = targetName;
        this.firstName = firstName;
        this.secondName = secondName;
    }

    private ConcatNONDuplicatedCalculator() {
        this.targetName = "Dummy";
        this.firstName = "Dummy";
        this.secondName = "Dummy";
    }

    @Override
    public void calculate(UserAgent.MutableUserAgent userAgent) {
        AgentField firstField = userAgent.get(this.firstName);
        AgentField secondField = userAgent.get(this.secondName);
        String first = firstField.getValue();
        long firstConfidence = firstField.getConfidence();
        String second = secondField.getValue();
        long secondConfidence = secondField.getConfidence();
        long confidence = Math.max(firstConfidence, secondConfidence);
        if (firstField.isDefaultValue() && secondField.isDefaultValue()) {
            userAgent.set(this.targetName, "<<<null>>>", confidence);
            return;
        }
        if (first.equals(second)) {
            userAgent.setForced(this.targetName, first, firstConfidence);
            return;
        }
        if (second.startsWith(first)) {
            userAgent.setForced(this.targetName, second, secondConfidence);
            return;
        }
        String value = first + " " + second;
        userAgent.set(this.targetName, value, confidence);
    }

    @Override
    public String getCalculatedFieldName() {
        return this.targetName;
    }

    @Override
    public Set<String> getDependencies() {
        return new HashSet<String>(Arrays.asList(this.firstName, this.secondName));
    }

    @Override
    public String toString() {
        return "Calculate [ " + this.firstName + " + " + this.secondName + " ] --> " + this.targetName;
    }
}

