/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.BooleanSupplier;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.analyze.Analyzer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestCase
implements Serializable {
    private final String userAgent;
    private final String testName;
    private final List<String> options;
    private final Map<String, String> metadata;
    private final Map<String, String> expected;
    private static final Logger LOG = LogManager.getLogger(TestCase.class);

    private TestCase() {
        this.userAgent = "<<Should never appear after deserialization>>";
        this.testName = "<<Should never appear after deserialization>>";
        this.options = Collections.emptyList();
        this.metadata = Collections.emptyMap();
        this.expected = Collections.emptyMap();
    }

    public TestCase(String userAgent, String testName) {
        this.userAgent = userAgent;
        this.testName = testName;
        this.options = new ArrayList<String>();
        this.metadata = new LinkedHashMap<String, String>();
        this.expected = new LinkedHashMap<String, String>();
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getTestName() {
        return this.testName;
    }

    public List<String> getOptions() {
        return this.options;
    }

    public void addOption(String option) {
        this.options.add(option);
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void addMetadata(String key, String value) {
        this.metadata.put(key, value);
    }

    public Map<String, String> getExpected() {
        return this.expected;
    }

    public void expect(String key, String value) {
        this.expected.put(key, value);
    }

    private String spaceFiller(int length) {
        return this.filler(length, ' ');
    }

    private String minFiller(int length) {
        return this.filler(length, '-');
    }

    private String filler(int length, char charr) {
        if (length <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            sb.append(charr);
        }
        return sb.toString();
    }

    private String logLine(String field, int maxFieldLength, String exp, int maxExpectedLength, String actual, int maxActualLength) {
        if (field == null) {
            field = "<<<null>>>";
        }
        if (exp == null) {
            exp = "<<<null>>>";
        }
        if (actual == null) {
            actual = "<<<null>>>";
        }
        return " | " + field + this.spaceFiller(maxFieldLength - field.length()) + " | " + exp + this.spaceFiller(maxExpectedLength - exp.length()) + " | " + actual + this.spaceFiller(maxActualLength - actual.length()) + " |";
    }

    private String logSeparator(int maxFieldLength, int maxExpectedLength, int maxActualLength) {
        return " |-" + this.minFiller(maxFieldLength) + "-+-" + this.minFiller(maxExpectedLength) + "-+-" + this.minFiller(maxActualLength) + "-|";
    }

    public TestResult verify(Analyzer analyzer) {
        long startTime = System.nanoTime();
        UserAgent.ImmutableUserAgent result = analyzer.parse(this.userAgent);
        long endTime = System.nanoTime();
        TestResult testResult = new TestResult();
        testResult.testCase = this;
        testResult.parseDurationNS = endTime - startTime;
        TreeSet<String> combinedKeys = new TreeSet<String>();
        combinedKeys.addAll(this.expected.keySet());
        combinedKeys.addAll(result.toMap().keySet());
        combinedKeys.remove("Useragent");
        combinedKeys.remove("__SyntaxError__");
        boolean passed = true;
        StringBuilder sb = new StringBuilder("\n");
        int maxFieldLength = combinedKeys.stream().filter(Objects::nonNull).map(String::length).max(Integer::compareTo).orElse(0);
        int maxExpectLength = this.expected.values().stream().filter(Objects::nonNull).map(String::length).max(Integer::compareTo).orElse(0);
        int maxActualLength = result.toMap().entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("Useragent")).map(Map.Entry::getValue).filter(Objects::nonNull).map(String::length).max(Integer::compareTo).orElse(0);
        sb.append(this.logSeparator(maxFieldLength, maxExpectLength, maxActualLength)).append('\n');
        sb.append(this.logLine("Field", maxFieldLength, "Expected", maxExpectLength, "Actual", maxActualLength)).append('\n');
        sb.append(this.logSeparator(maxFieldLength, maxExpectLength, maxActualLength)).append('\n');
        for (String key : combinedKeys) {
            String expectedValue = this.expected.get(key);
            String actualValue = result.getValue(key);
            sb.append(this.logLine(key, maxFieldLength, expectedValue, maxExpectLength, actualValue, maxActualLength));
            if (expectedValue == null) {
                if (!result.get(key).isDefaultValue()) {
                    passed = false;
                    sb.append(" --> UNEXPECTED");
                }
            } else if (!expectedValue.equals(actualValue)) {
                passed = false;
                sb.append(" --> !!! FAIL !!!");
            }
            sb.append('\n');
        }
        sb.append(this.logSeparator(maxFieldLength, maxExpectLength, maxActualLength)).append('\n');
        testResult.pass = passed;
        testResult.errorReport = sb.toString();
        return testResult;
    }

    public String toString() {
        return "TestCase{userAgent='" + this.userAgent + '\'' + ", testName='" + this.testName + '\'' + ", options=" + this.options + ", metadata=" + this.metadata + ", expected=" + this.expected + '}';
    }

    public static class TestResult
    implements BooleanSupplier {
        private TestCase testCase;
        private boolean pass;
        private long parseDurationNS;
        private String errorReport;

        public TestCase getTestCase() {
            return this.testCase;
        }

        public boolean testPassed() {
            return this.pass;
        }

        public boolean testFailed() {
            return !this.pass;
        }

        public long getParseDurationNS() {
            return this.parseDurationNS;
        }

        public String getErrorReport() {
            return this.errorReport;
        }

        public String toString() {
            return this.testCase + this.errorReport;
        }

        @Override
        public boolean getAsBoolean() {
            return this.pass;
        }
    }
}

