/*
 * Yet Another UserAgent Analyzer
 * Copyright (C) 2013-2021 Niels Basjes
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package nl.basjes.parse.useragent.calculate;

import nl.basjes.parse.useragent.UserAgent.MutableUserAgent;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;

public abstract class FieldCalculator implements Serializable {
    public abstract void calculate(MutableUserAgent userAgent);

    public abstract String getCalculatedFieldName();

    public Set<String> getDependencies() {
        return Collections.emptySet();
    }

    @Override
    public String toString() {
        return "Calculate " + getDependencies() + " ==> " + getCalculatedFieldName();
    }
}
