/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.analyze.Analyzer;

public class TestCase
implements Serializable {
    private final String userAgent;
    private final String testName;
    private final List<String> options;
    private final Map<String, String> metadata;
    private final Map<String, String> expected;

    private TestCase() {
        this.userAgent = "<<Should never appear after deserialization>>";
        this.testName = "<<Should never appear after deserialization>>";
        this.options = Collections.emptyList();
        this.metadata = Collections.emptyMap();
        this.expected = Collections.emptyMap();
    }

    public TestCase(String userAgent, String testName) {
        this.userAgent = userAgent;
        this.testName = testName;
        this.options = new ArrayList<String>();
        this.metadata = new LinkedHashMap<String, String>();
        this.expected = new LinkedHashMap<String, String>();
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getTestName() {
        return this.testName;
    }

    public List<String> getOptions() {
        return this.options;
    }

    public void addOption(String option) {
        this.options.add(option);
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void addMetadata(String key, String value) {
        this.metadata.put(key, value);
    }

    public Map<String, String> getExpected() {
        return this.expected;
    }

    public void expect(String key, String value) {
        this.expected.put(key, value);
    }

    public boolean verify(Analyzer analyzer) {
        UserAgent.ImmutableUserAgent result = analyzer.parse(this.userAgent);
        TreeSet<String> combinedKeys = new TreeSet<String>();
        combinedKeys.addAll(this.expected.keySet());
        combinedKeys.addAll(result.toMap().keySet());
        combinedKeys.remove("Useragent");
        combinedKeys.remove("__SyntaxError__");
        for (String key : combinedKeys) {
            String actualValue;
            String expectedValue = this.expected.get(key);
            if (!(expectedValue == null ? !result.get(key).isDefaultValue() : !expectedValue.equals(actualValue = result.getValue(key)))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "TestCase{userAgent='" + this.userAgent + '\'' + ", testName='" + this.testName + '\'' + ", options=" + this.options + ", metadata=" + this.metadata + ", expected=" + this.expected + '}';
    }
}

