/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.analyze.treewalker.steps.value;

import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nl.basjes.parse.useragent.analyze.treewalker.steps.Step;
import nl.basjes.parse.useragent.analyze.treewalker.steps.WalkList;
import nl.basjes.parse.useragent.yauaa.shaded.org.antlr.v4.runtime.tree.ParseTree;

public class StepIsValidVersion
extends Step {
    private static final Pattern VALID_VERSION = Pattern.compile("^[a-z]?\\d+(?:[_.]\\d+){0,5}(?:[-_.,][a-z\\d._ -]+)?$", 2);

    protected boolean isValid(String version) {
        return VALID_VERSION.matcher(version).matches();
    }

    @Override
    public WalkList.WalkResult walk(@Nonnull ParseTree tree, @Nullable String value) {
        String actualValue = this.getActualValue(tree, value);
        if (this.isValid(actualValue)) {
            return this.walkNextStep(tree, actualValue);
        }
        return null;
    }

    public String toString() {
        return "IsValidVersion()";
    }
}

