/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api.message;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.directory.shared.ldap.codec.util.LdapURLEncodingException;
import org.apache.directory.shared.ldap.util.LdapURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Referral {
    static final Logger LOG = LoggerFactory.getLogger(Referral.class);
    private List<LdapURL> referrals;

    public Collection<String> getLdapUrls() {
        if (this.referrals == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> urls = new ArrayList<String>(this.referrals.size());
        for (LdapURL referral : this.referrals) {
            urls.add(referral.toString());
        }
        return urls;
    }

    public void addLdapUrls(String ... urls) {
        if (urls == null || urls.length == 0) {
            return;
        }
        if (this.referrals == null) {
            this.referrals = new ArrayList<LdapURL>(urls.length);
        }
        for (String url : urls) {
            try {
                LdapURL ldapUrl = new LdapURL(url);
                this.referrals.add(ldapUrl);
            }
            catch (LdapURLEncodingException luee) {
                LOG.warn("The given URL '{}' is invalid", (Object)url);
            }
        }
    }

    public void addLdapUrls(LdapURL ... urls) {
        if (urls == null || urls.length == 0) {
            return;
        }
        if (this.referrals == null) {
            this.referrals = new ArrayList<LdapURL>(urls.length);
        }
        for (LdapURL url : urls) {
            this.referrals.add(url);
        }
    }

    public void removeLdapUrl(String ... urls) {
        if (urls == null || urls.length == 0) {
            return;
        }
        if (this.referrals == null || this.referrals.size() == 0) {
            return;
        }
        for (String url : urls) {
            try {
                LdapURL ldapUrl = new LdapURL(url);
                this.referrals.remove(ldapUrl);
            }
            catch (LdapURLEncodingException luee) {
                LOG.warn("The given URL '{}' is invalid", (Object)url);
            }
        }
    }

    public void removeLdapUrl(LdapURL ... urls) {
        if (urls == null || urls.length == 0) {
            return;
        }
        if (this.referrals == null || this.referrals.size() == 0) {
            return;
        }
        for (LdapURL url : urls) {
            this.referrals.remove(url);
        }
    }
}

