/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.jlink;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.beryx.jlink.BaseTask;
import org.beryx.jlink.JlinkPlugin;
import org.beryx.jlink.data.CdsData;
import org.beryx.jlink.data.CustomImageData;
import org.beryx.jlink.data.JlinkTaskData;
import org.beryx.jlink.data.LauncherData;
import org.beryx.jlink.data.SecondaryLauncherData;
import org.beryx.jlink.data.TargetPlatform;
import org.beryx.jlink.impl.JlinkTaskImpl;
import org.beryx.jlink.util.PathUtil;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.Directory;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class JlinkTask
extends BaseTask {
    private static final Logger LOGGER;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    public JlinkTask() {
        this.dependsOn(new Object[]{JlinkPlugin.getTASK_NAME_PREPARE_MODULES_DIR()});
        String string = "Creates a modular runtime image with jlink";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, JlinkTask.class, (GroovyObject)this, (String)"description");
    }

    @Input
    public String getModuleName() {
        return ShortTypeHandling.castToString((Object)this.getExtension().getModuleName().get());
    }

    @Input
    public String getMergedModuleName() {
        return ShortTypeHandling.castToString((Object)this.getExtension().getMergedModuleName().get());
    }

    @Input
    public LauncherData getLauncherData() {
        return (LauncherData)ScriptBytecodeAdapter.castToType((Object)this.getExtension().getLauncherData().get(), LauncherData.class);
    }

    @Input
    public List<SecondaryLauncherData> getSecondaryLaunchers() {
        return (List)ScriptBytecodeAdapter.castToType((Object)this.getExtension().getSecondaryLaunchers().get(), List.class);
    }

    @Input
    public CustomImageData getCustomImageData() {
        return (CustomImageData)ScriptBytecodeAdapter.castToType((Object)this.getExtension().getCustomImageData().get(), CustomImageData.class);
    }

    @Input
    public String getMainClass() {
        return ShortTypeHandling.castToString((Object)this.getExtension().getMainClass().get());
    }

    @Input
    public String getConfiguration() {
        return ShortTypeHandling.castToString((Object)this.getExtension().getConfiguration().get());
    }

    @Input
    public List<String> getOptions() {
        return (List)ScriptBytecodeAdapter.castToType((Object)this.getExtension().getOptions().get(), List.class);
    }

    @Input
    public List<String> getExtraModulePaths() {
        return (List)ScriptBytecodeAdapter.castToType((Object)this.getExtension().getExtraModulePaths().get(), List.class);
    }

    @Input
    public String getJavaHome() {
        return this.getJavaHomeOrDefault();
    }

    @Input
    public Map<String, TargetPlatform> getTargetPlatforms() {
        return (Map)ScriptBytecodeAdapter.castToType((Object)this.getExtension().getTargetPlatforms().get(), Map.class);
    }

    @InputDirectory
    public Directory getJlinkJarsDir() {
        return this.getProject().getLayout().getProjectDirectory().dir(PathUtil.getJlinkJarsDirPath(this.getJlinkBasePath()));
    }

    @Internal
    public String getImageName() {
        return ShortTypeHandling.castToString((Object)this.getExtension().getImageName().get());
    }

    @Internal
    public Directory getImageDir() {
        return (Directory)ScriptBytecodeAdapter.castToType((Object)this.getExtension().getImageDir().get(), Directory.class);
    }

    @Input
    public CdsData getCdsData() {
        return (CdsData)ScriptBytecodeAdapter.castToType((Object)this.getExtension().getCdsData().get(), CdsData.class);
    }

    @TaskAction
    public void jlinkTaskAction() {
        JlinkTaskData taskData = new JlinkTaskData();
        String string = this.getJlinkBasePath();
        taskData.setJlinkBasePath(string);
        File file = this.getImageDirAsFile();
        taskData.setImageDir(file);
        String string2 = this.getModuleName();
        taskData.setModuleName(string2);
        String string3 = this.getMergedModuleName();
        taskData.setMergedModuleName(string3);
        LauncherData launcherData = this.getLauncherData();
        taskData.setLauncherData(launcherData);
        List<SecondaryLauncherData> list = this.getSecondaryLaunchers();
        taskData.setSecondaryLaunchers(list);
        CustomImageData customImageData = this.getCustomImageData();
        taskData.setCustomImageData(customImageData);
        String string4 = this.getMainClass();
        String string5 = DefaultTypeTransformation.booleanUnbox((Object)string4) ? string4 : this.getDefaultMainClass();
        taskData.setMainClass(string5);
        Configuration configuration = this.getProject().getConfigurations().getByName(this.getConfiguration());
        taskData.setConfiguration(configuration);
        List<String> list2 = this.getOptions();
        taskData.setOptions(list2);
        List<String> list3 = this.getExtraModulePaths();
        taskData.setExtraModulePaths(list3);
        String string6 = this.getJavaHome();
        taskData.setJavaHome(string6);
        Map<String, TargetPlatform> map = this.getTargetPlatforms();
        taskData.setTargetPlatforms(map);
        File file2 = this.getJlinkJarsDir().getAsFile();
        taskData.setJlinkJarsDir(file2);
        CdsData cdsData = this.getCdsData();
        taskData.setCdsData(cdsData);
        JlinkTaskImpl taskImpl = new JlinkTaskImpl(this.getProject(), taskData);
        taskImpl.execute();
    }

    @OutputDirectory
    public File getImageDirAsFile() {
        return DefaultTypeTransformation.booleanUnbox((Object)this.getImageName()) ? this.getImageDirFromName() : this.getImageDir().getAsFile();
    }

    @Internal
    public File getImageDirFromName() {
        return this.getProject().file((Object)new GStringImpl(new Object[]{this.getProject().getBuildDir(), this.getImageName()}, new String[]{"", "/", ""}));
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != JlinkTask.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        Logger logger;
        LOGGER = logger = Logging.getLogger(JlinkTask.class);
    }
}

