/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.storage.domain;

import org.duracloud.common.util.EncryptionUtil;
import org.duracloud.storage.domain.DatabaseConfig;
import org.jdom.Content;
import org.jdom.Element;

public class DatabaseConfigXmlUtil {
    public static Element marshall(DatabaseConfig millDbConfig, String elementName) {
        String password;
        String username;
        EncryptionUtil encryptionUtil = new EncryptionUtil();
        Element db = new Element(elementName);
        String host = millDbConfig.getHost();
        if (null != host) {
            db.addContent((Content)new Element("host").setText(host));
        }
        int port = millDbConfig.getPort();
        db.addContent((Content)new Element("port").setText(port + ""));
        String name = millDbConfig.getName();
        if (null != name) {
            db.addContent((Content)new Element("name").setText(name));
        }
        if (null != (username = millDbConfig.getUsername())) {
            db.addContent((Content)new Element("username").setText(username));
        }
        if (null != (password = millDbConfig.getPassword())) {
            db.addContent((Content)new Element("password").setText(encryptionUtil.encrypt(password)));
        }
        return db;
    }

    public static DatabaseConfig unmarshalDatabaseConfig(Element dbConfigElement) {
        String password;
        String username;
        String name;
        String port;
        EncryptionUtil encryptionUtil = new EncryptionUtil();
        DatabaseConfig millDbConfig = new DatabaseConfig();
        String host = dbConfigElement.getChildText("host");
        if (null != host) {
            millDbConfig.setHost(host);
        }
        if (null != (port = dbConfigElement.getChildText("port"))) {
            millDbConfig.setPort(Integer.parseInt(port));
        }
        if (null != (name = dbConfigElement.getChildText("name"))) {
            millDbConfig.setName(name);
        }
        if (null != (username = dbConfigElement.getChildText("username"))) {
            millDbConfig.setUsername(username);
        }
        if (null != (password = dbConfigElement.getChildText("password"))) {
            millDbConfig.setPassword(encryptionUtil.decrypt(password));
        }
        return millDbConfig;
    }
}

