/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.Assert;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.GrizzlyTestCase;
import org.glassfish.grizzly.StandaloneProcessor;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.impl.SafeFutureImpl;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.nio.transport.TCPNIOServerConnection;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.streams.StreamReader;
import org.glassfish.grizzly.streams.StreamWriter;
import org.glassfish.grizzly.utils.Pair;

public class CompositeBufferInStreamTest
extends GrizzlyTestCase {
    public static final int PORT = 7783;
    private static final Logger LOGGER = Grizzly.logger(CompositeBufferInStreamTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCompositeBuffer() throws Exception {
        Connection connection = null;
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
        Buffer portion1 = Buffers.wrap((MemoryManager)transport.getMemoryManager(), (String)"Hello");
        Buffer portion2 = Buffers.wrap((MemoryManager)transport.getMemoryManager(), (String)" ");
        Buffer portion3 = Buffers.wrap((MemoryManager)transport.getMemoryManager(), (String)"world!");
        SafeFutureImpl lock1 = SafeFutureImpl.create();
        SafeFutureImpl lock2 = SafeFutureImpl.create();
        SafeFutureImpl lock3 = SafeFutureImpl.create();
        Pair[] portions = new Pair[]{new Pair((Object)portion1, (Object)lock1), new Pair((Object)portion2, (Object)lock2), new Pair((Object)portion3, (Object)lock3)};
        try {
            TCPNIOServerConnection serverConnection = transport.bind(7783);
            transport.configureStandalone(true);
            transport.start();
            this.startEchoServerThread(transport, serverConnection, portions);
            GrizzlyFuture future = transport.connect("localhost", 7783);
            connection = (Connection)future.get(10L, TimeUnit.SECONDS);
            CompositeBufferInStreamTest.assertTrue((connection != null ? 1 : 0) != 0);
            connection.configureStandalone(true);
            StreamWriter writer = ((StandaloneProcessor)connection.getProcessor()).getStreamWriter(connection);
            for (Pair portion : portions) {
                Buffer buffer = ((Buffer)portion.getFirst()).duplicate();
                Future locker = (Future)portion.getSecond();
                writer.writeBuffer(buffer);
                GrizzlyFuture writeFuture = writer.flush();
                writeFuture.get(5000L, TimeUnit.MILLISECONDS);
                locker.get(5000L, TimeUnit.MILLISECONDS);
            }
            CompositeBufferInStreamTest.assertTrue((boolean)true);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            transport.stop();
        }
    }

    private void startEchoServerThread(final TCPNIOTransport transport, final TCPNIOServerConnection serverConnection, final Pair<Buffer, FutureImpl<Integer>>[] portions) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block14: {
                    try {
                        int i;
                        GrizzlyFuture acceptFuture = serverConnection.accept();
                        Connection connection = (Connection)acceptFuture.get(10L, TimeUnit.SECONDS);
                        Assert.assertTrue((boolean)acceptFuture.isDone());
                        int availableExp = 0;
                        StreamReader reader = ((StandaloneProcessor)connection.getProcessor()).getStreamReader(connection);
                        try {
                            for (i = 0; i < portions.length; ++i) {
                                Pair portion = portions[i];
                                FutureImpl currentLocker = (FutureImpl)portion.getSecond();
                                GrizzlyFuture readFuture = reader.notifyAvailable(availableExp += ((Buffer)portion.getFirst()).remaining());
                                readFuture.get(30L, TimeUnit.SECONDS);
                                if (readFuture.isDone()) {
                                    Buffer compositeBuffer = reader.getBufferWindow();
                                    int counter = 0;
                                    for (int j = 0; j <= i; ++j) {
                                        Buffer currentBuffer = (Buffer)portions[j].getFirst();
                                        for (int k = 0; k < currentBuffer.limit(); ++k) {
                                            byte expected;
                                            byte found;
                                            if ((found = compositeBuffer.get(counter++)) == (expected = currentBuffer.get(k))) continue;
                                            currentLocker.failure((Throwable)new IllegalStateException("CompositeBuffer content is broken. Offset: " + compositeBuffer.position() + " found: " + found + " expected: " + expected));
                                            return;
                                        }
                                    }
                                } else {
                                    currentLocker.failure((Throwable)new IllegalStateException("Error reading content portion: " + i));
                                    return;
                                }
                                currentLocker.result((Object)i);
                            }
                        }
                        catch (Throwable e) {
                            ((FutureImpl)portions[i].getSecond()).failure(e);
                            LOGGER.log(Level.WARNING, "Error working with accepted connection on step: " + i, e);
                        }
                        finally {
                            connection.close();
                        }
                    }
                    catch (Exception e) {
                        if (transport.isStopped()) break block14;
                        LOGGER.log(Level.WARNING, "Error accepting connection", e);
                        Assert.assertTrue((String)"Error accepting connection", (boolean)false);
                    }
                }
            }
        }).start();
    }
}

