/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly;

import java.io.EOFException;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.compression.zip.GZipFilter;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.impl.SafeFutureImpl;
import org.glassfish.grizzly.nio.transport.TCPNIOConnectorHandler;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.utils.ChunkingFilter;
import org.glassfish.grizzly.utils.DelayFilter;
import org.glassfish.grizzly.utils.EchoFilter;
import org.glassfish.grizzly.utils.StringFilter;

public class GZipTest
extends TestCase {
    private static final int PORT = 7786;

    public void testSimpleEcho() throws Exception {
        this.doTest("Hello world");
    }

    public void test10Echoes() throws Exception {
        String[] array = new String[10];
        for (int i = 0; i < array.length; ++i) {
            array[i] = "Hello world #" + i;
        }
        this.doTest(array);
    }

    public void testLargeEcho() throws Exception {
        int len = 262144;
        StringBuilder sb = new StringBuilder(262144);
        String a = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
        int totalLen = a.length() - 1;
        Random r = new Random(System.currentTimeMillis());
        for (int i = 0; i < 262144; ++i) {
            sb.append(a.charAt(r.nextInt(totalLen)));
        }
        this.doTest(sb.toString());
    }

    public void testChunkedEcho() throws Exception {
        this.doTest(true, "Hello world");
    }

    public void testChunked10Echoes() throws Exception {
        String[] array = new String[10];
        for (int i = 0; i < array.length; ++i) {
            array[i] = "Hello world #" + i;
        }
        this.doTest(true, array);
    }

    void doTest(String ... messages) throws Exception {
        this.doTest(false, messages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doTest(boolean applyChunking, String ... messages) throws Exception {
        Connection connection = null;
        FilterChainBuilder serverChainBuilder = FilterChainBuilder.stateless();
        serverChainBuilder.add((Filter)new TransportFilter());
        if (applyChunking) {
            serverChainBuilder.add((Filter)new ChunkingFilter(2));
            serverChainBuilder.add((Filter)new DelayFilter(50L, 50L));
        }
        serverChainBuilder.add((Filter)new GZipFilter());
        serverChainBuilder.add((Filter)new StringFilter());
        serverChainBuilder.add((Filter)new EchoFilter());
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
        transport.setProcessor((Processor)serverChainBuilder.build());
        try {
            transport.bind(7786);
            transport.start();
            SafeFutureImpl completeFuture = SafeFutureImpl.create();
            FilterChainBuilder clientChainBuilder = FilterChainBuilder.stateless();
            clientChainBuilder.add((Filter)new TransportFilter());
            clientChainBuilder.add((Filter)new GZipFilter());
            clientChainBuilder.add((Filter)new StringFilter());
            clientChainBuilder.add((Filter)new ClientEchoCheckFilter((FutureImpl<Boolean>)completeFuture, messages));
            TCPNIOConnectorHandler connectorHandler = ((TCPNIOConnectorHandler.Builder)TCPNIOConnectorHandler.builder((TCPNIOTransport)transport).processor((Processor)clientChainBuilder.build())).build();
            Future future = connectorHandler.connect("localhost", 7786);
            connection = (Connection)future.get(10L, TimeUnit.SECONDS);
            GZipTest.assertTrue((connection != null ? 1 : 0) != 0);
            GZipTest.assertTrue((boolean)((Boolean)completeFuture.get(120L, TimeUnit.SECONDS)));
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            transport.stop();
        }
    }

    private static final class ClientEchoCheckFilter
    extends BaseFilter {
        private final String[] messages;
        private final FutureImpl<Boolean> future;
        private final AtomicInteger idx = new AtomicInteger();

        public ClientEchoCheckFilter(FutureImpl<Boolean> future, String ... messages) {
            this.messages = messages;
            this.future = future;
        }

        public NextAction handleConnect(FilterChainContext ctx) throws IOException {
            ctx.write((Object)this.messages[this.idx.get()]);
            return ctx.getStopAction();
        }

        public NextAction handleRead(FilterChainContext ctx) throws IOException {
            String echoedMessage = (String)ctx.getMessage();
            int currentIdx = this.idx.getAndIncrement();
            String messageToCompare = this.messages[currentIdx];
            if (messageToCompare.equals(echoedMessage)) {
                if (currentIdx >= this.messages.length - 1) {
                    this.future.result((Object)true);
                } else {
                    ctx.write((Object)this.messages[currentIdx + 1]);
                }
            } else {
                this.future.failure((Throwable)new IllegalStateException("Message #" + currentIdx + " is incorrect. Expected: " + messageToCompare + " received: " + echoedMessage));
            }
            return ctx.getStopAction();
        }

        public void exceptionOccurred(FilterChainContext ctx, Throwable error) {
            if (!this.future.isDone()) {
                this.future.failure(error);
            }
        }

        public NextAction handleClose(FilterChainContext ctx) throws IOException {
            if (!this.future.isDone()) {
                this.future.failure((Throwable)new EOFException("handleClose was called"));
            }
            return ctx.getStopAction();
        }
    }
}

