/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.Assert;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.GrizzlyTestCase;
import org.glassfish.grizzly.StandaloneProcessor;
import org.glassfish.grizzly.nio.transport.TCPNIOServerConnection;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.streams.StreamReader;
import org.glassfish.grizzly.streams.StreamWriter;

public class StandaloneTest
extends GrizzlyTestCase {
    private static Logger logger = Grizzly.logger(StandaloneTest.class);
    public static int PORT = 7780;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStandalone() throws Exception {
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
        int messageSize = 166434;
        Connection connection = null;
        StreamReader reader = null;
        StreamWriter writer = null;
        try {
            transport.configureStandalone(true);
            TCPNIOServerConnection serverConnection = transport.bind(PORT);
            transport.start();
            Thread serverThread = this.startEchoServerThread(transport, serverConnection, messageSize);
            GrizzlyFuture connectFuture = transport.connect("localhost", PORT);
            connection = (Connection)connectFuture.get(10L, TimeUnit.SECONDS);
            StandaloneTest.assertTrue((boolean)connectFuture.isDone());
            byte[] buffer = new byte[messageSize];
            for (int i = 0; i < messageSize; ++i) {
                buffer[i] = (byte)(i % 128);
            }
            writer = StandaloneProcessor.INSTANCE.getStreamWriter(connection);
            writer.writeByteArray(buffer);
            writer.flush();
            reader = StandaloneProcessor.INSTANCE.getStreamReader(connection);
            byte[] receiveBuffer = new byte[messageSize];
            GrizzlyFuture readFuture = reader.notifyAvailable(messageSize);
            readFuture.get(20L, TimeUnit.SECONDS);
            reader.readByteArray(receiveBuffer);
            StandaloneTest.assertTrue((boolean)readFuture.isDone());
            StandaloneTest.assertTrue((boolean)Arrays.equals(buffer, receiveBuffer));
            serverThread.join(10000L);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            transport.stop();
        }
    }

    private Thread startEchoServerThread(final TCPNIOTransport transport, final TCPNIOServerConnection serverConnection, final int messageSize) {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block7: {
                    try {
                        GrizzlyFuture acceptFuture = serverConnection.accept();
                        Connection connection = (Connection)acceptFuture.get(10L, TimeUnit.SECONDS);
                        Assert.assertTrue((boolean)acceptFuture.isDone());
                        StreamReader reader = StandaloneProcessor.INSTANCE.getStreamReader(connection);
                        StreamWriter writer = StandaloneProcessor.INSTANCE.getStreamWriter(connection);
                        try {
                            GrizzlyFuture readFuture = reader.notifyAvailable(messageSize);
                            readFuture.get(10L, TimeUnit.SECONDS);
                            byte[] buffer = new byte[messageSize];
                            reader.readByteArray(buffer);
                            Assert.assertTrue((boolean)readFuture.isDone());
                            writer.writeByteArray(buffer);
                            GrizzlyFuture writeFuture = writer.flush();
                            writeFuture.get(10L, TimeUnit.SECONDS);
                            Assert.assertTrue((boolean)writeFuture.isDone());
                        }
                        catch (Throwable e) {
                            logger.log(Level.WARNING, "Error working with accepted connection", e);
                            Assert.assertTrue((String)"Error working with accepted connection", (boolean)false);
                        }
                        finally {
                            connection.close();
                        }
                    }
                    catch (Exception e) {
                        if (transport.isStopped()) break block7;
                        logger.log(Level.WARNING, "Error accepting connection", e);
                        Assert.assertTrue((String)"Error accepting connection", (boolean)false);
                    }
                }
            }
        });
        thread.start();
        return thread;
    }
}

