/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.ast.expr;

import java.util.Optional;
import java.util.function.Consumer;
import org.javamodularity.moduleplugin.shadow.javaparser.TokenRange;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.AllFieldsConstructor;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.Node;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.LiteralStringValueExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.visitor.CloneVisitor;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.visitor.GenericVisitor;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.visitor.VoidVisitor;
import org.javamodularity.moduleplugin.shadow.javaparser.metamodel.IntegerLiteralExprMetaModel;
import org.javamodularity.moduleplugin.shadow.javaparser.metamodel.JavaParserMetaModel;

public class IntegerLiteralExpr
extends LiteralStringValueExpr {
    public IntegerLiteralExpr() {
        this(null, "0");
    }

    @AllFieldsConstructor
    public IntegerLiteralExpr(String value) {
        this(null, value);
    }

    public IntegerLiteralExpr(TokenRange tokenRange, String value) {
        super(tokenRange, value);
        this.customInitialization();
    }

    public IntegerLiteralExpr(int value) {
        this(null, String.valueOf(value));
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        return super.remove(node);
    }

    public int asInt() {
        String result = this.value.replaceAll("_", "");
        if (result.startsWith("0x") || result.startsWith("0X")) {
            return Integer.parseUnsignedInt(result.substring(2), 16);
        }
        if (result.startsWith("0b") || result.startsWith("0B")) {
            return Integer.parseUnsignedInt(result.substring(2), 2);
        }
        if (result.length() > 1 && result.startsWith("0")) {
            return Integer.parseUnsignedInt(result.substring(1), 8);
        }
        return Integer.parseInt(result);
    }

    public IntegerLiteralExpr setInt(int value) {
        this.value = String.valueOf(value);
        return this;
    }

    @Override
    public IntegerLiteralExpr clone() {
        return (IntegerLiteralExpr)this.accept(new CloneVisitor(), null);
    }

    @Override
    public IntegerLiteralExprMetaModel getMetaModel() {
        return JavaParserMetaModel.integerLiteralExprMetaModel;
    }

    @Override
    public boolean replace(Node node, Node replacementNode) {
        if (node == null) {
            return false;
        }
        return super.replace(node, replacementNode);
    }

    @Override
    public boolean isIntegerLiteralExpr() {
        return true;
    }

    @Override
    public IntegerLiteralExpr asIntegerLiteralExpr() {
        return this;
    }

    @Override
    public void ifIntegerLiteralExpr(Consumer<IntegerLiteralExpr> action) {
        action.accept(this);
    }

    @Override
    public Optional<IntegerLiteralExpr> toIntegerLiteralExpr() {
        return Optional.of(this);
    }
}

