/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.printer.concretesyntaxmodel;

import org.javamodularity.moduleplugin.shadow.javaparser.GeneratedJavaParserConstants;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.Node;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.IntegerLiteralExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.observer.ObservableProperty;
import org.javamodularity.moduleplugin.shadow.javaparser.printer.SourcePrinter;
import org.javamodularity.moduleplugin.shadow.javaparser.printer.concretesyntaxmodel.CsmElement;
import org.javamodularity.moduleplugin.shadow.javaparser.printer.concretesyntaxmodel.PrintingHelper;
import org.javamodularity.moduleplugin.shadow.javaparser.utils.CodeGenerationUtils;

public class CsmAttribute
implements CsmElement {
    private final ObservableProperty property;

    public ObservableProperty getProperty() {
        return this.property;
    }

    public CsmAttribute(ObservableProperty property) {
        this.property = property;
    }

    @Override
    public void prettyPrint(Node node, SourcePrinter printer) {
        Object value = this.property.getRawValue(node);
        printer.print(PrintingHelper.printToString(value));
    }

    public int getTokenType(Node node, String text, String tokenText) {
        switch (this.property) {
            case IDENTIFIER: {
                return 89;
            }
            case TYPE: {
                String expectedImage = "\"" + text.toLowerCase() + "\"";
                for (int i = 0; i < GeneratedJavaParserConstants.tokenImage.length; ++i) {
                    if (!GeneratedJavaParserConstants.tokenImage[i].equals(expectedImage)) continue;
                    return i;
                }
                throw new RuntimeException(CodeGenerationUtils.f("Attribute '%s' does not corresponding to any expected value. Text: %s", this.property.camelCaseName(), text));
            }
            case KEYWORD: 
            case OPERATOR: {
                String expectedImage = "\"" + tokenText.toLowerCase() + "\"";
                for (int i = 0; i < GeneratedJavaParserConstants.tokenImage.length; ++i) {
                    if (!GeneratedJavaParserConstants.tokenImage[i].equals(expectedImage)) continue;
                    return i;
                }
                throw new RuntimeException(CodeGenerationUtils.f("Attribute '%s' does not corresponding to any expected value. Text: %s", this.property.camelCaseName(), tokenText));
            }
            case VALUE: {
                if (node instanceof IntegerLiteralExpr) {
                    return 75;
                }
            }
            case NAME: {
                return 89;
            }
        }
        throw new UnsupportedOperationException("getTokenType does not know how to handle property " + (Object)((Object)this.property) + " with text: " + text);
    }
}

