/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.declarations.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.MethodUsage;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedTypeVariable;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.core.resolution.Context;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.logic.InferenceContext;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.model.resolution.TypeSolver;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel.MyObjectProvider;

public class MethodDeclarationCommonLogic {
    private ResolvedMethodDeclaration methodDeclaration;
    private TypeSolver typeSolver;

    public MethodDeclarationCommonLogic(ResolvedMethodDeclaration methodDeclaration, TypeSolver typeSolver) {
        this.methodDeclaration = methodDeclaration;
        this.typeSolver = typeSolver;
    }

    public MethodUsage resolveTypeVariables(Context context, List<ResolvedType> parameterTypes) {
        ResolvedType returnType = this.replaceTypeParams(this.methodDeclaration.getReturnType(), context);
        ArrayList<ResolvedType> params = new ArrayList<ResolvedType>();
        for (int i = 0; i < this.methodDeclaration.getNumberOfParams(); ++i) {
            ResolvedType replaced = this.replaceTypeParams(this.methodDeclaration.getParam(i).getType(), context);
            params.add(replaced);
        }
        InferenceContext inferenceContext = new InferenceContext(MyObjectProvider.INSTANCE);
        for (int i = 0; i < this.methodDeclaration.getNumberOfParams() - (this.methodDeclaration.hasVariadicParameter() ? 1 : 0); ++i) {
            ResolvedType formalParamType = this.methodDeclaration.getParam(i).getType();
            ResolvedType actualParamType = parameterTypes.get(i);
            inferenceContext.addPair(formalParamType, actualParamType);
        }
        returnType = inferenceContext.resolve(inferenceContext.addSingle(returnType));
        return new MethodUsage(this.methodDeclaration, params, returnType);
    }

    private ResolvedType replaceTypeParams(ResolvedType type, Context context) {
        Optional<ResolvedType> typeParam;
        ResolvedTypeParameterDeclaration typeParameter;
        if (type.isTypeVariable() && (typeParameter = type.asTypeParameter()).declaredOnType() && (typeParam = this.typeParamByName(typeParameter.getName(), context)).isPresent()) {
            type = typeParam.get();
        }
        if (type.isReferenceType()) {
            type.asReferenceType().transformTypeParameters(tp -> this.replaceTypeParams(tp, context));
        }
        return type;
    }

    protected Optional<ResolvedType> typeParamByName(String name, Context context) {
        return this.methodDeclaration.getTypeParameters().stream().filter(tp -> tp.getName().equals(name)).map(tp -> this.toType((ResolvedTypeParameterDeclaration)tp)).findFirst();
    }

    protected ResolvedType toType(ResolvedTypeParameterDeclaration typeParameterDeclaration) {
        return new ResolvedTypeVariable(typeParameterDeclaration);
    }
}

