/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.CompilationUnit;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.Node;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.ClassOrInterfaceDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.FieldDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.Parameter;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.VariableDeclarator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.ArrayAccessExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.ArrayCreationExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.ArrayInitializerExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.AssignExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.BinaryExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.BooleanLiteralExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.CastExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.CharLiteralExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.ClassExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.ConditionalExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.DoubleLiteralExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.EnclosedExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.Expression;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.FieldAccessExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.InstanceOfExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.IntegerLiteralExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.LambdaExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.LongLiteralExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.MethodCallExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.MethodReferenceExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.NameExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.NullLiteralExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.ObjectCreationExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.StringLiteralExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.SuperExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.ThisExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.UnaryExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.VariableDeclarationExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.stmt.BlockStmt;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.stmt.ExpressionStmt;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.stmt.ReturnStmt;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.type.Type;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.type.UnknownType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.MethodUsage;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.UnsolvedSymbolException;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedClassDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedArrayType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedPrimitiveType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedReferenceType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedVoidType;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.core.resolution.Context;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparser.Navigator;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.DefaultVisitorAdapter;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.JavaParserFactory;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserSymbolDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.logic.FunctionalInterfaceLogic;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.logic.InferenceContext;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.model.resolution.SymbolReference;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.model.resolution.TypeSolver;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.model.resolution.Value;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.model.typesystem.NullType;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.model.typesystem.ReferenceTypeImpl;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel.MyObjectProvider;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel.ReflectionClassDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.SymbolSolver;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.typesolvers.ReflectionTypeSolver;
import org.javamodularity.moduleplugin.shadow.javaparser.utils.Log;

public class TypeExtractor
extends DefaultVisitorAdapter {
    private TypeSolver typeSolver;
    private JavaParserFacade facade;

    public TypeExtractor(TypeSolver typeSolver, JavaParserFacade facade) {
        this.typeSolver = typeSolver;
        this.facade = facade;
    }

    @Override
    public ResolvedType visit(VariableDeclarator node, Boolean solveLambdas) {
        if (Navigator.requireParentNode(node) instanceof FieldDeclaration) {
            return this.facade.convertToUsageVariableType(node);
        }
        if (Navigator.requireParentNode(node) instanceof VariableDeclarationExpr) {
            return this.facade.convertToUsageVariableType(node);
        }
        throw new UnsupportedOperationException(Navigator.requireParentNode(node).getClass().getCanonicalName());
    }

    @Override
    public ResolvedType visit(Parameter node, Boolean solveLambdas) {
        if (node.getType() instanceof UnknownType) {
            throw new IllegalStateException("Parameter has unknown type: " + node);
        }
        return this.facade.convertToUsage(node.getType(), node);
    }

    @Override
    public ResolvedType visit(ArrayAccessExpr node, Boolean solveLambdas) {
        ResolvedType arrayUsageType = node.getName().accept(this, solveLambdas);
        if (arrayUsageType.isArray()) {
            return ((ResolvedArrayType)arrayUsageType).getComponentType();
        }
        return arrayUsageType;
    }

    @Override
    public ResolvedType visit(ArrayCreationExpr node, Boolean solveLambdas) {
        ResolvedType res = this.facade.convertToUsage(node.getElementType(), JavaParserFactory.getContext(node, this.typeSolver));
        for (int i = 0; i < node.getLevels().size(); ++i) {
            res = new ResolvedArrayType(res);
        }
        return res;
    }

    @Override
    public ResolvedType visit(ArrayInitializerExpr node, Boolean solveLambdas) {
        throw new UnsupportedOperationException(node.getClass().getCanonicalName());
    }

    @Override
    public ResolvedType visit(AssignExpr node, Boolean solveLambdas) {
        return node.getTarget().accept(this, solveLambdas);
    }

    @Override
    public ResolvedType visit(BinaryExpr node, Boolean solveLambdas) {
        switch (node.getOperator()) {
            case PLUS: 
            case MINUS: 
            case DIVIDE: 
            case MULTIPLY: {
                return this.facade.getBinaryTypeConcrete(node.getLeft(), node.getRight(), solveLambdas, node.getOperator());
            }
            case LESS_EQUALS: 
            case LESS: 
            case GREATER: 
            case GREATER_EQUALS: 
            case EQUALS: 
            case NOT_EQUALS: 
            case OR: 
            case AND: {
                return ResolvedPrimitiveType.BOOLEAN;
            }
            case BINARY_AND: 
            case BINARY_OR: 
            case SIGNED_RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: 
            case LEFT_SHIFT: 
            case REMAINDER: 
            case XOR: {
                return node.getLeft().accept(this, solveLambdas);
            }
        }
        throw new UnsupportedOperationException("Operator " + node.getOperator().name());
    }

    @Override
    public ResolvedType visit(CastExpr node, Boolean solveLambdas) {
        return this.facade.convertToUsage(node.getType(), JavaParserFactory.getContext(node, this.typeSolver));
    }

    @Override
    public ResolvedType visit(ClassExpr node, Boolean solveLambdas) {
        Type astType = node.getType();
        ResolvedType jssType = this.facade.convertToUsage(astType, node.getType());
        return new ReferenceTypeImpl(new ReflectionClassDeclaration(Class.class, this.typeSolver), (List<ResolvedType>)ImmutableList.of((Object)jssType), this.typeSolver);
    }

    @Override
    public ResolvedType visit(ConditionalExpr node, Boolean solveLambdas) {
        return node.getThenExpr().accept(this, solveLambdas);
    }

    @Override
    public ResolvedType visit(EnclosedExpr node, Boolean solveLambdas) {
        return node.getInner().accept(this, solveLambdas);
    }

    private ResolvedType solveDotExpressionType(ResolvedReferenceTypeDeclaration parentType, FieldAccessExpr node) {
        if (parentType.isEnum() && parentType.asEnum().hasEnumConstant(node.getName().getId())) {
            return parentType.asEnum().getEnumConstant(node.getName().getId()).getType();
        }
        if (parentType.hasField(node.getName().getId())) {
            return parentType.getField(node.getName().getId()).getType();
        }
        if (parentType.hasInternalType(node.getName().getId())) {
            return new ReferenceTypeImpl(parentType.getInternalType(node.getName().getId()), this.typeSolver);
        }
        throw new UnsolvedSymbolException(node.getName().getId());
    }

    @Override
    public ResolvedType visit(FieldAccessExpr node, Boolean solveLambdas) {
        Optional<Object> value;
        block10: {
            SymbolReference<ResolvedReferenceTypeDeclaration> sr;
            if (node.getScope() instanceof NameExpr || node.getScope() instanceof FieldAccessExpr) {
                Expression staticValue = node.getScope();
                SymbolReference<ResolvedTypeDeclaration> typeAccessedStatically = JavaParserFactory.getContext(node, this.typeSolver).solveType(staticValue.toString());
                if (typeAccessedStatically.isSolved()) {
                    return this.solveDotExpressionType(typeAccessedStatically.getCorrespondingDeclaration().asReferenceType(), node);
                }
            } else if (node.getScope() instanceof ThisExpr) {
                ResolvedTypeDeclaration correspondingDeclaration;
                SymbolReference<ResolvedTypeDeclaration> solve = this.facade.solve((ThisExpr)node.getScope());
                if (solve.isSolved() && (correspondingDeclaration = solve.getCorrespondingDeclaration()) instanceof ResolvedReferenceTypeDeclaration) {
                    return this.solveDotExpressionType(correspondingDeclaration.asReferenceType(), node);
                }
            } else if (node.getScope().toString().indexOf(46) > 0 && (sr = this.typeSolver.tryToSolveType(node.getScope().toString())).isSolved()) {
                return this.solveDotExpressionType(sr.getCorrespondingDeclaration(), node);
            }
            value = Optional.empty();
            try {
                value = new SymbolSolver(this.typeSolver).solveSymbolAsValue(node.getName().getId(), node);
            }
            catch (UnsolvedSymbolException use) {
                SymbolReference<ResolvedReferenceTypeDeclaration> sref = this.typeSolver.tryToSolveType(node.toString());
                if (!sref.isSolved()) break block10;
                return new ReferenceTypeImpl(sref.getCorrespondingDeclaration(), this.typeSolver);
            }
        }
        if (value.isPresent()) {
            return ((Value)value.get()).getType();
        }
        throw new UnsolvedSymbolException(node.getName().getId());
    }

    @Override
    public ResolvedType visit(InstanceOfExpr node, Boolean solveLambdas) {
        return ResolvedPrimitiveType.BOOLEAN;
    }

    @Override
    public ResolvedType visit(StringLiteralExpr node, Boolean solveLambdas) {
        return new ReferenceTypeImpl(new ReflectionTypeSolver().solveType(String.class.getCanonicalName()), this.typeSolver);
    }

    @Override
    public ResolvedType visit(IntegerLiteralExpr node, Boolean solveLambdas) {
        return ResolvedPrimitiveType.INT;
    }

    @Override
    public ResolvedType visit(LongLiteralExpr node, Boolean solveLambdas) {
        return ResolvedPrimitiveType.LONG;
    }

    @Override
    public ResolvedType visit(CharLiteralExpr node, Boolean solveLambdas) {
        return ResolvedPrimitiveType.CHAR;
    }

    @Override
    public ResolvedType visit(DoubleLiteralExpr node, Boolean solveLambdas) {
        if (node.getValue().toLowerCase().endsWith("f")) {
            return ResolvedPrimitiveType.FLOAT;
        }
        return ResolvedPrimitiveType.DOUBLE;
    }

    @Override
    public ResolvedType visit(BooleanLiteralExpr node, Boolean solveLambdas) {
        return ResolvedPrimitiveType.BOOLEAN;
    }

    @Override
    public ResolvedType visit(NullLiteralExpr node, Boolean solveLambdas) {
        return NullType.INSTANCE;
    }

    @Override
    public ResolvedType visit(MethodCallExpr node, Boolean solveLambdas) {
        Log.trace("getType on method call %s", () -> node);
        MethodUsage ref = this.facade.solveMethodAsUsage(node);
        Log.trace("getType on method call %s resolved to %s", () -> node, () -> ref);
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = () -> node;
        supplierArray[1] = ref::returnType;
        Log.trace("getType on method call %s return type is %s", supplierArray);
        return ref.returnType();
    }

    @Override
    public ResolvedType visit(NameExpr node, Boolean solveLambdas) {
        Log.trace("getType on name expr %s", () -> node);
        Optional<Value> value = new SymbolSolver(this.typeSolver).solveSymbolAsValue(node.getName().getId(), node);
        if (!value.isPresent()) {
            throw new UnsolvedSymbolException("Solving " + node, node.getName().getId());
        }
        return value.get().getType();
    }

    @Override
    public ResolvedType visit(ObjectCreationExpr node, Boolean solveLambdas) {
        return this.facade.convertToUsage((Type)node.getType(), node);
    }

    @Override
    public ResolvedType visit(ThisExpr node, Boolean solveLambdas) {
        if (node.getClassExpr().isPresent()) {
            Optional<ClassOrInterfaceDeclaration> classByName;
            String className = node.getClassExpr().get().toString();
            SymbolReference<ResolvedReferenceTypeDeclaration> clazz = this.typeSolver.tryToSolveType(className);
            if (clazz.isSolved()) {
                return new ReferenceTypeImpl(clazz.getCorrespondingDeclaration(), this.typeSolver);
            }
            Optional<CompilationUnit> cu = node.findAncestor(CompilationUnit.class);
            if (cu.isPresent() && (classByName = cu.get().getClassByName(className)).isPresent()) {
                return new ReferenceTypeImpl(this.facade.getTypeDeclaration(classByName.get()), this.typeSolver);
            }
        }
        return new ReferenceTypeImpl(this.facade.getTypeDeclaration(this.facade.findContainingTypeDeclOrObjectCreationExpr(node)), this.typeSolver);
    }

    @Override
    public ResolvedType visit(SuperExpr node, Boolean solveLambdas) {
        ResolvedReferenceTypeDeclaration typeOfNode = this.facade.getTypeDeclaration(this.facade.findContainingTypeDecl(node));
        if (typeOfNode instanceof ResolvedClassDeclaration) {
            return ((ResolvedClassDeclaration)typeOfNode).getSuperClass();
        }
        throw new UnsupportedOperationException(node.getClass().getCanonicalName());
    }

    @Override
    public ResolvedType visit(UnaryExpr node, Boolean solveLambdas) {
        switch (node.getOperator()) {
            case MINUS: 
            case PLUS: {
                return node.getExpression().accept(this, solveLambdas);
            }
            case LOGICAL_COMPLEMENT: {
                return ResolvedPrimitiveType.BOOLEAN;
            }
            case POSTFIX_DECREMENT: 
            case PREFIX_DECREMENT: 
            case POSTFIX_INCREMENT: 
            case PREFIX_INCREMENT: {
                return node.getExpression().accept(this, solveLambdas);
            }
        }
        throw new UnsupportedOperationException(node.getOperator().name());
    }

    @Override
    public ResolvedType visit(VariableDeclarationExpr node, Boolean solveLambdas) {
        if (node.getVariables().size() != 1) {
            throw new UnsupportedOperationException();
        }
        return this.facade.convertToUsageVariableType((VariableDeclarator)node.getVariables().get(0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ResolvedType visit(LambdaExpr node, Boolean solveLambdas) {
        ResolvedType actualType;
        Context ctx;
        Optional<MethodUsage> functionalMethod;
        if (!(Navigator.requireParentNode(node) instanceof MethodCallExpr)) throw new UnsupportedOperationException("The type of a lambda expr depends on the position and its return value");
        MethodCallExpr callExpr = (MethodCallExpr)Navigator.requireParentNode(node);
        int pos = JavaParserSymbolDeclaration.getParamPos(node);
        SymbolReference<ResolvedMethodDeclaration> refMethod = this.facade.solve(callExpr);
        if (!refMethod.isSolved()) {
            throw new UnsolvedSymbolException(Navigator.requireParentNode(node).toString(), callExpr.getName().getId());
        }
        Log.trace("getType on lambda expr %s", () -> ((ResolvedMethodDeclaration)refMethod.getCorrespondingDeclaration()).getName());
        if (solveLambdas == false) return refMethod.getCorrespondingDeclaration().getParam(pos).getType();
        ResolvedType result = refMethod.getCorrespondingDeclaration().getParam(pos).getType();
        if (callExpr.getScope().isPresent()) {
            ResolvedType scopeType;
            Expression scope = callExpr.getScope().get();
            boolean staticCall = false;
            if (scope instanceof NameExpr) {
                NameExpr nameExpr = (NameExpr)scope;
                try {
                    SymbolReference<ResolvedTypeDeclaration> type = JavaParserFactory.getContext(nameExpr, this.typeSolver).solveType(nameExpr.getName().getId());
                    if (type.isSolved()) {
                        staticCall = true;
                    }
                }
                catch (Exception type) {
                    // empty catch block
                }
            }
            if (!staticCall && (scopeType = this.facade.getType(scope)).isReferenceType()) {
                result = scopeType.asReferenceType().useThisTypeParametersOnTheGivenType(result);
            }
        }
        if (!(functionalMethod = FunctionalInterfaceLogic.getFunctionalMethod(result = JavaParserFacade.solveGenericTypes(result, ctx = JavaParserFactory.getContext(node, this.typeSolver)))).isPresent()) return result;
        LambdaExpr lambdaExpr = node;
        InferenceContext lambdaCtx = new InferenceContext(MyObjectProvider.INSTANCE);
        InferenceContext funcInterfaceCtx = new InferenceContext(MyObjectProvider.INSTANCE);
        ResolvedReferenceType functionalInterfaceType = ReferenceTypeImpl.undeterminedParameters(functionalMethod.get().getDeclaration().declaringType(), this.typeSolver);
        lambdaCtx.addPair(result, functionalInterfaceType);
        if (lambdaExpr.getBody() instanceof ExpressionStmt) {
            actualType = this.facade.getType(((ExpressionStmt)lambdaExpr.getBody()).getExpression());
        } else {
            if (!(lambdaExpr.getBody() instanceof BlockStmt)) throw new UnsupportedOperationException();
            BlockStmt blockStmt = (BlockStmt)lambdaExpr.getBody();
            List<ReturnStmt> returnStmts = blockStmt.findAll(ReturnStmt.class);
            if (returnStmts.size() <= 0) return ResolvedVoidType.INSTANCE;
            actualType = returnStmts.stream().map(returnStmt -> returnStmt.getExpression().map(e -> this.facade.getType((Node)e)).orElse(ResolvedVoidType.INSTANCE)).filter(x -> x != null && !x.isVoid() && !x.isNull()).findFirst().orElse(ResolvedVoidType.INSTANCE);
        }
        ResolvedType formalType = functionalMethod.get().returnType();
        funcInterfaceCtx.addPair(formalType, actualType);
        ResolvedType functionalTypeWithReturn = funcInterfaceCtx.resolve(funcInterfaceCtx.addSingle(functionalInterfaceType));
        if (formalType instanceof ResolvedVoidType) return result;
        lambdaCtx.addPair(result, functionalTypeWithReturn);
        return lambdaCtx.resolve(lambdaCtx.addSingle(result));
    }

    @Override
    public ResolvedType visit(MethodReferenceExpr node, Boolean solveLambdas) {
        if (Navigator.requireParentNode(node) instanceof MethodCallExpr) {
            MethodCallExpr callExpr = (MethodCallExpr)Navigator.requireParentNode(node);
            int pos = JavaParserSymbolDeclaration.getParamPos(node);
            SymbolReference<ResolvedMethodDeclaration> refMethod = this.facade.solve(callExpr, false);
            if (!refMethod.isSolved()) {
                throw new UnsolvedSymbolException(Navigator.requireParentNode(node).toString(), callExpr.getName().getId());
            }
            Log.trace("getType on method reference expr %s", () -> ((ResolvedMethodDeclaration)refMethod.getCorrespondingDeclaration()).getName());
            if (solveLambdas.booleanValue()) {
                MethodUsage usage = this.facade.solveMethodAsUsage(callExpr);
                ResolvedType result = usage.getParamType(pos);
                Context ctx = JavaParserFactory.getContext(node, this.typeSolver);
                if (FunctionalInterfaceLogic.getFunctionalMethod(result = JavaParserFacade.solveGenericTypes(result, ctx)).isPresent()) {
                    MethodReferenceExpr methodReferenceExpr = node;
                    ResolvedType actualType = this.facade.toMethodUsage(methodReferenceExpr).returnType();
                    ResolvedType formalType = FunctionalInterfaceLogic.getFunctionalMethod(result).get().returnType();
                    InferenceContext inferenceContext = new InferenceContext(MyObjectProvider.INSTANCE);
                    inferenceContext.addPair(formalType, actualType);
                    result = inferenceContext.resolve(inferenceContext.addSingle(result));
                }
                return result;
            }
            return refMethod.getCorrespondingDeclaration().getParam(pos).getType();
        }
        throw new UnsupportedOperationException("The type of a method reference expr depends on the position and its return value");
    }

    @Override
    public ResolvedType visit(FieldDeclaration node, Boolean solveLambdas) {
        if (node.getVariables().size() == 1) {
            return ((VariableDeclarator)node.getVariables().get(0)).accept(this, solveLambdas);
        }
        throw new IllegalArgumentException("Cannot resolve the type of a field with multiple variable declarations. Pick one");
    }
}

