/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.contexts;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.NodeList;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.TypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.ObjectCreationExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.nodeTypes.NodeWithTypeArguments;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.type.TypeParameter;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedValueDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedReferenceType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedType;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.JavaParserFactory;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.contexts.AbstractJavaParserContext;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserAnonymousClassDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserTypeParameter;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.model.resolution.SymbolReference;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.model.resolution.TypeSolver;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel.ReflectionClassDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.MethodResolutionLogic;

public class AnonymousClassDeclarationContext
extends AbstractJavaParserContext<ObjectCreationExpr> {
    private final JavaParserAnonymousClassDeclaration myDeclaration;

    public AnonymousClassDeclarationContext(ObjectCreationExpr node, TypeSolver typeSolver) {
        super(node, typeSolver);
        this.myDeclaration = new JavaParserAnonymousClassDeclaration((ObjectCreationExpr)this.wrappedNode, this.typeSolver);
        Preconditions.checkArgument((boolean)node.getAnonymousClassBody().isPresent(), (Object)"An anonymous class must have a body");
    }

    @Override
    public SymbolReference<ResolvedMethodDeclaration> solveMethod(String name, List<ResolvedType> argumentsTypes, boolean staticOnly) {
        SymbolReference<ResolvedMethodDeclaration> res;
        SymbolReference<ResolvedMethodDeclaration> parentSolution;
        List<ResolvedMethodDeclaration> candidateMethods = this.myDeclaration.getDeclaredMethods().stream().filter(m -> m.getName().equals(name) && (!staticOnly || m.isStatic())).collect(Collectors.toList());
        if (!Object.class.getCanonicalName().equals(this.myDeclaration.getQualifiedName())) {
            for (ResolvedReferenceType ancestor : this.myDeclaration.getAncestors()) {
                SymbolReference<ResolvedMethodDeclaration> res2 = MethodResolutionLogic.solveMethodInType(ancestor.getTypeDeclaration(), name, argumentsTypes, staticOnly);
                if (!res2.isSolved()) continue;
                candidateMethods.add(res2.getCorrespondingDeclaration());
            }
        }
        if (candidateMethods.isEmpty() && (parentSolution = this.getParent().solveMethod(name, argumentsTypes, staticOnly)).isSolved()) {
            candidateMethods.add(parentSolution.getCorrespondingDeclaration());
        }
        if (candidateMethods.isEmpty() && this.myDeclaration.getSuperTypeDeclaration().isInterface() && (res = MethodResolutionLogic.solveMethodInType(new ReflectionClassDeclaration(Object.class, this.typeSolver), name, argumentsTypes, false)).isSolved()) {
            candidateMethods.add(res.getCorrespondingDeclaration());
        }
        return MethodResolutionLogic.findMostApplicable(candidateMethods, name, argumentsTypes, this.typeSolver);
    }

    @Override
    public SymbolReference<ResolvedTypeDeclaration> solveType(String name) {
        List<TypeDeclaration> typeDeclarations = this.myDeclaration.findMembersOfKind(TypeDeclaration.class);
        Optional<SymbolReference> exactMatch = typeDeclarations.stream().filter(internalType -> internalType.getName().getId().equals(name)).findFirst().map(internalType -> SymbolReference.solved(JavaParserFacade.get(this.typeSolver).getTypeDeclaration((TypeDeclaration<?>)internalType)));
        if (exactMatch.isPresent()) {
            return exactMatch.get();
        }
        Optional<SymbolReference> recursiveMatch = typeDeclarations.stream().filter(internalType -> name.startsWith(String.format("%s.", internalType.getName()))).findFirst().map(internalType -> JavaParserFactory.getContext(internalType, this.typeSolver).solveType(name.substring(internalType.getName().getId().length() + 1)));
        if (recursiveMatch.isPresent()) {
            return recursiveMatch.get();
        }
        Optional<SymbolReference> typeArgumentsMatch = ((ObjectCreationExpr)this.wrappedNode).getTypeArguments().map(nodes -> ((NodeWithTypeArguments)((Object)nodes)).getTypeArguments().orElse(new NodeList())).orElse(new NodeList()).stream().filter(type -> type.toString().equals(name)).findFirst().map(matchingType -> SymbolReference.solved(new JavaParserTypeParameter(new TypeParameter(matchingType.toString()), this.typeSolver)));
        if (typeArgumentsMatch.isPresent()) {
            return typeArgumentsMatch.get();
        }
        for (ResolvedReferenceType ancestor : this.myDeclaration.getAncestors()) {
            if (ancestor.getTypeDeclaration().getName().equals(name)) {
                return SymbolReference.solved(ancestor.getTypeDeclaration());
            }
            try {
                for (ResolvedTypeDeclaration resolvedTypeDeclaration : ancestor.getTypeDeclaration().internalTypes()) {
                    if (!resolvedTypeDeclaration.getName().equals(name)) continue;
                    return SymbolReference.solved(resolvedTypeDeclaration);
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
        }
        return this.getParent().solveType(name);
    }

    @Override
    public SymbolReference<? extends ResolvedValueDeclaration> solveSymbol(String name) {
        Preconditions.checkArgument((this.typeSolver != null ? 1 : 0) != 0);
        if (this.myDeclaration.hasVisibleField(name)) {
            return SymbolReference.solved(this.myDeclaration.getVisibleField(name));
        }
        return this.getParent().solveSymbol(name);
    }
}

