/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.contexts;

import java.util.List;
import java.util.stream.Collectors;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.Modifier;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.BodyDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.TypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.nodeTypes.NodeWithTypeParameters;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.type.TypeParameter;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.HasAccessSpecifier;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedClassDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedConstructorDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedReferenceType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedType;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.core.resolution.Context;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.JavaParserFactory;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserTypeParameter;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.model.resolution.SymbolReference;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.model.resolution.TypeSolver;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.reflectionmodel.ReflectionClassDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.ConstructorResolutionLogic;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.MethodResolutionLogic;

public class JavaParserTypeDeclarationAdapter {
    private TypeDeclaration<?> wrappedNode;
    private TypeSolver typeSolver;
    private Context context;
    private ResolvedReferenceTypeDeclaration typeDeclaration;

    public JavaParserTypeDeclarationAdapter(TypeDeclaration<?> wrappedNode, TypeSolver typeSolver, ResolvedReferenceTypeDeclaration typeDeclaration, Context context) {
        this.wrappedNode = wrappedNode;
        this.typeSolver = typeSolver;
        this.typeDeclaration = typeDeclaration;
        this.context = context;
    }

    public SymbolReference<ResolvedTypeDeclaration> solveType(String name) {
        ResolvedTypeDeclaration type;
        if (this.wrappedNode.getName().getId().equals(name)) {
            return SymbolReference.solved(JavaParserFacade.get(this.typeSolver).getTypeDeclaration(this.wrappedNode));
        }
        for (BodyDeclaration<?> member : this.wrappedNode.getMembers()) {
            if (!(member instanceof TypeDeclaration)) continue;
            TypeDeclaration internalType = (TypeDeclaration)member;
            if (internalType.getName().getId().equals(name)) {
                return SymbolReference.solved(JavaParserFacade.get(this.typeSolver).getTypeDeclaration(internalType));
            }
            if (name.startsWith(String.format("%s.%s", this.wrappedNode.getName(), internalType.getName()))) {
                return JavaParserFactory.getContext(internalType, this.typeSolver).solveType(name.substring(this.wrappedNode.getName().getId().length() + 1));
            }
            if (!name.startsWith(String.format("%s.", internalType.getName()))) continue;
            return JavaParserFactory.getContext(internalType, this.typeSolver).solveType(name.substring(internalType.getName().getId().length() + 1));
        }
        if (this.wrappedNode instanceof NodeWithTypeParameters) {
            NodeWithTypeParameters nodeWithTypeParameters = (NodeWithTypeParameters)((Object)this.wrappedNode);
            for (TypeParameter astTpRaw : nodeWithTypeParameters.getTypeParameters()) {
                TypeParameter astTp = astTpRaw;
                if (!astTp.getName().getId().equals(name)) continue;
                return SymbolReference.solved(new JavaParserTypeParameter(astTp, this.typeSolver));
            }
        }
        return (type = this.checkAncestorsForType(name, this.typeDeclaration)) != null ? SymbolReference.solved(type) : this.context.getParent().solveType(name);
    }

    private ResolvedTypeDeclaration checkAncestorsForType(String name, ResolvedReferenceTypeDeclaration declaration) {
        for (ResolvedReferenceType ancestor : declaration.getAncestors(true)) {
            try {
                for (ResolvedTypeDeclaration resolvedTypeDeclaration : ancestor.getTypeDeclaration().internalTypes()) {
                    ResolvedReferenceTypeDeclaration resolvedReferenceTypeDeclaration;
                    boolean visible = true;
                    if (resolvedTypeDeclaration instanceof ResolvedReferenceTypeDeclaration && (resolvedReferenceTypeDeclaration = resolvedTypeDeclaration.asReferenceType()) instanceof HasAccessSpecifier) {
                        boolean bl = visible = ((HasAccessSpecifier)((Object)resolvedReferenceTypeDeclaration)).accessSpecifier() != Modifier.Keyword.PRIVATE;
                    }
                    if (!resolvedTypeDeclaration.getName().equals(name)) continue;
                    if (visible) {
                        return resolvedTypeDeclaration;
                    }
                    return null;
                }
                ResolvedTypeDeclaration ancestorDeclaration = this.checkAncestorsForType(name, ancestor.getTypeDeclaration());
                if (ancestorDeclaration == null) continue;
                return ancestorDeclaration;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
        }
        return null;
    }

    public SymbolReference<ResolvedMethodDeclaration> solveMethod(String name, List<ResolvedType> argumentsTypes, boolean staticOnly) {
        SymbolReference<ResolvedMethodDeclaration> res;
        SymbolReference<ResolvedMethodDeclaration> parentSolution;
        List<ResolvedMethodDeclaration> candidateMethods = this.typeDeclaration.getDeclaredMethods().stream().filter(m -> m.getName().equals(name)).filter(m -> !staticOnly || m.isStatic()).collect(Collectors.toList());
        if (!Object.class.getCanonicalName().equals(this.typeDeclaration.getQualifiedName())) {
            for (ResolvedReferenceType ancestor : this.typeDeclaration.getAncestors(true)) {
                if (this.typeDeclaration == ancestor.getTypeDeclaration()) continue;
                candidateMethods.addAll(ancestor.getAllMethodsVisibleToInheritors().stream().filter(m -> m.getName().equals(name)).collect(Collectors.toList()));
                SymbolReference<ResolvedMethodDeclaration> res2 = MethodResolutionLogic.solveMethodInType(ancestor.getTypeDeclaration(), name, argumentsTypes, staticOnly);
                if (!res2.isSolved()) continue;
                candidateMethods.add(res2.getCorrespondingDeclaration());
            }
        }
        if (candidateMethods.isEmpty() && (parentSolution = this.context.getParent().solveMethod(name, argumentsTypes, staticOnly)).isSolved()) {
            candidateMethods.add(parentSolution.getCorrespondingDeclaration());
        }
        if (candidateMethods.isEmpty() && this.typeDeclaration.isInterface() && (res = MethodResolutionLogic.solveMethodInType(new ReflectionClassDeclaration(Object.class, this.typeSolver), name, argumentsTypes, false)).isSolved()) {
            candidateMethods.add(res.getCorrespondingDeclaration());
        }
        return MethodResolutionLogic.findMostApplicable(candidateMethods, name, argumentsTypes, this.typeSolver);
    }

    public SymbolReference<ResolvedConstructorDeclaration> solveConstructor(List<ResolvedType> argumentsTypes) {
        if (this.typeDeclaration instanceof ResolvedClassDeclaration) {
            return ConstructorResolutionLogic.findMostApplicable(this.typeDeclaration.getConstructors(), argumentsTypes, this.typeSolver);
        }
        return SymbolReference.unsolved(ResolvedConstructorDeclaration.class);
    }
}

