/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.declarations;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.CompilationUnit;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.Node;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.PackageDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.ClassOrInterfaceDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.ConstructorDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.EnumDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.AnnotationExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.nodeTypes.NodeWithAnnotations;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.nodeTypes.NodeWithConstructors;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.UnsolvedSymbolException;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedConstructorDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.JavaParserFactory;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.declarations.DefaultConstructorDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserConstructorDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.model.resolution.SymbolReference;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.model.resolution.TypeSolver;

class AstResolutionUtils {
    AstResolutionUtils() {
    }

    static String containerName(Node container) {
        String packageName = AstResolutionUtils.getPackageName(container);
        String className = AstResolutionUtils.getClassName("", container);
        return packageName + (!packageName.isEmpty() && !className.isEmpty() ? "." : "") + className;
    }

    static String getPackageName(Node container) {
        if (container instanceof CompilationUnit) {
            Optional<PackageDeclaration> p = ((CompilationUnit)container).getPackageDeclaration();
            if (p.isPresent()) {
                return p.get().getName().toString();
            }
        } else if (container != null) {
            return AstResolutionUtils.getPackageName(container.getParentNode().orElse(null));
        }
        return "";
    }

    static String getClassName(String base, Node container) {
        if (container instanceof ClassOrInterfaceDeclaration) {
            String b = AstResolutionUtils.getClassName(base, container.getParentNode().orElse(null));
            String cn = ((ClassOrInterfaceDeclaration)container).getName().getId();
            if (b.isEmpty()) {
                return cn;
            }
            return b + "." + cn;
        }
        if (container instanceof EnumDeclaration) {
            String b = AstResolutionUtils.getClassName(base, container.getParentNode().orElse(null));
            String cn = ((EnumDeclaration)container).getName().getId();
            if (b.isEmpty()) {
                return cn;
            }
            return b + "." + cn;
        }
        if (container != null) {
            return AstResolutionUtils.getClassName(base, container.getParentNode().orElse(null));
        }
        return base;
    }

    static boolean hasDirectlyAnnotation(NodeWithAnnotations<?> nodeWithAnnotations, TypeSolver typeSolver, String canonicalName) {
        for (AnnotationExpr annotationExpr : nodeWithAnnotations.getAnnotations()) {
            SymbolReference<ResolvedTypeDeclaration> ref = JavaParserFactory.getContext(annotationExpr, typeSolver).solveType(annotationExpr.getName().getId());
            if (ref.isSolved()) {
                if (!ref.getCorrespondingDeclaration().getQualifiedName().equals(canonicalName)) continue;
                return true;
            }
            throw new UnsolvedSymbolException(annotationExpr.getName().getId());
        }
        return false;
    }

    static <N extends ResolvedReferenceTypeDeclaration> List<ResolvedConstructorDeclaration> getConstructors(NodeWithConstructors<?> wrappedNode, TypeSolver typeSolver, N container) {
        List<ResolvedConstructorDeclaration> declared = wrappedNode.getConstructors().stream().map(c -> new JavaParserConstructorDeclaration<ResolvedReferenceTypeDeclaration>(container, (ConstructorDeclaration)c, typeSolver)).collect(Collectors.toList());
        if (declared.isEmpty()) {
            return ImmutableList.of(new DefaultConstructorDeclaration<N>(container));
        }
        return declared;
    }
}

