/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.declarations;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.Modifier;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.Node;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.ConstructorDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.FieldDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.MethodDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.TypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.VariableDeclarator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.ObjectCreationExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.type.ClassOrInterfaceType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.MethodUsage;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedConstructorDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedFieldDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedReferenceType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedType;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.core.resolution.Context;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.core.resolution.MethodUsageResolutionCapability;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.JavaParserFactory;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.declarations.AstResolutionUtils;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserConstructorDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserFieldDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserMethodDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.logic.AbstractClassDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.model.resolution.SymbolReference;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.model.resolution.TypeSolver;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.model.typesystem.ReferenceTypeImpl;

public class JavaParserAnonymousClassDeclaration
extends AbstractClassDeclaration
implements MethodUsageResolutionCapability {
    private final TypeSolver typeSolver;
    private final ObjectCreationExpr wrappedNode;
    private final ResolvedTypeDeclaration superTypeDeclaration;
    private final String name = "Anonymous-" + UUID.randomUUID();

    public JavaParserAnonymousClassDeclaration(ObjectCreationExpr wrappedNode, TypeSolver typeSolver) {
        this.typeSolver = typeSolver;
        this.wrappedNode = wrappedNode;
        ClassOrInterfaceType superType = wrappedNode.getType();
        String superTypeName = superType.getName().getId();
        if (superType.getScope().isPresent()) {
            superTypeName = superType.getScope().get().asString() + "." + superTypeName;
        }
        this.superTypeDeclaration = JavaParserFactory.getContext(wrappedNode.getParentNode().get(), typeSolver).solveType(superTypeName).getCorrespondingDeclaration();
    }

    public ResolvedTypeDeclaration getSuperTypeDeclaration() {
        return this.superTypeDeclaration;
    }

    public <T extends Node> List<T> findMembersOfKind(Class<T> memberClass) {
        if (this.wrappedNode.getAnonymousClassBody().isPresent()) {
            return this.wrappedNode.getAnonymousClassBody().get().stream().filter(node -> memberClass.isAssignableFrom(node.getClass())).map(memberClass::cast).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public Context getContext() {
        return JavaParserFactory.getContext(this.wrappedNode, this.typeSolver);
    }

    @Override
    public SymbolReference<ResolvedMethodDeclaration> solveMethod(String name, List<ResolvedType> argumentsTypes, boolean staticOnly) {
        return this.getContext().solveMethod(name, argumentsTypes, staticOnly);
    }

    @Override
    public Optional<MethodUsage> solveMethodAsUsage(String name, List<ResolvedType> argumentTypes, Context invocationContext, List<ResolvedType> typeParameters) {
        return this.getContext().solveMethodAsUsage(name, argumentTypes);
    }

    @Override
    protected ResolvedReferenceType object() {
        return new ReferenceTypeImpl(this.typeSolver.solveType(Object.class.getCanonicalName()), this.typeSolver);
    }

    @Override
    public ResolvedReferenceType getSuperClass() {
        ResolvedReferenceTypeDeclaration superRRTD = this.superTypeDeclaration.asReferenceType();
        if (superRRTD == null) {
            throw new RuntimeException("The super ResolvedReferenceTypeDeclaration is not expected to be null");
        }
        return new ReferenceTypeImpl(superRRTD, this.typeSolver);
    }

    @Override
    public List<ResolvedReferenceType> getInterfaces() {
        return this.superTypeDeclaration.asReferenceType().getAncestors().stream().filter(type -> type.getTypeDeclaration().isInterface()).collect(Collectors.toList());
    }

    @Override
    public List<ResolvedConstructorDeclaration> getConstructors() {
        return this.findMembersOfKind(ConstructorDeclaration.class).stream().map(ctor -> new JavaParserConstructorDeclaration<JavaParserAnonymousClassDeclaration>(this, (ConstructorDeclaration)ctor, this.typeSolver)).collect(Collectors.toList());
    }

    @Override
    public Modifier.Keyword accessSpecifier() {
        return Modifier.Keyword.PRIVATE;
    }

    @Override
    public List<ResolvedReferenceType> getAncestors(boolean acceptIncompleteList) {
        return ImmutableList.builder().add((Object)this.getSuperClass()).addAll(this.superTypeDeclaration.asReferenceType().getAncestors(acceptIncompleteList)).build();
    }

    @Override
    public List<ResolvedFieldDeclaration> getAllFields() {
        List myFields = this.findMembersOfKind(FieldDeclaration.class).stream().flatMap(field -> field.getVariables().stream().map(variable -> new JavaParserFieldDeclaration((VariableDeclarator)variable, this.typeSolver))).collect(Collectors.toList());
        List<ResolvedFieldDeclaration> superClassFields = this.getSuperClass().getTypeDeclaration().getAllFields();
        List interfaceFields = this.getInterfaces().stream().flatMap(inteface -> inteface.getTypeDeclaration().getAllFields().stream()).collect(Collectors.toList());
        return ImmutableList.builder().addAll(myFields).addAll(superClassFields).addAll(interfaceFields).build();
    }

    @Override
    public Set<ResolvedMethodDeclaration> getDeclaredMethods() {
        return this.findMembersOfKind(MethodDeclaration.class).stream().map(method -> new JavaParserMethodDeclaration((MethodDeclaration)method, this.typeSolver)).collect(Collectors.toSet());
    }

    @Override
    public boolean isAssignableBy(ResolvedType type) {
        return false;
    }

    @Override
    public boolean isAssignableBy(ResolvedReferenceTypeDeclaration other) {
        return false;
    }

    @Override
    public boolean hasDirectlyAnnotation(String qualifiedName) {
        return false;
    }

    @Override
    public String getPackageName() {
        return AstResolutionUtils.getPackageName(this.wrappedNode);
    }

    @Override
    public String getClassName() {
        return AstResolutionUtils.getClassName("", this.wrappedNode);
    }

    @Override
    public String getQualifiedName() {
        String containerName = AstResolutionUtils.containerName(this.wrappedNode.getParentNode().orElse(null));
        if (containerName.isEmpty()) {
            return this.getName();
        }
        return containerName + "." + this.getName();
    }

    @Override
    public Set<ResolvedReferenceTypeDeclaration> internalTypes() {
        return this.findMembersOfKind(TypeDeclaration.class).stream().map(typeMember -> JavaParserFacade.get(this.typeSolver).getTypeDeclaration((TypeDeclaration<?>)typeMember)).collect(Collectors.toSet());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<ResolvedTypeParameterDeclaration> getTypeParameters() {
        return Lists.newArrayList();
    }

    @Override
    public Optional<ResolvedReferenceTypeDeclaration> containerType() {
        throw new UnsupportedOperationException("containerType is not supported for " + this.getClass().getCanonicalName());
    }

    @Override
    public Optional<Node> toAst() {
        return Optional.of(this.wrappedNode);
    }
}

