/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.SignatureAttribute;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.Modifier;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.Node;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.MethodUsage;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.UnsolvedSymbolException;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedConstructorDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedFieldDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedValueDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedReferenceType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedType;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.core.resolution.Context;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.core.resolution.MethodUsageResolutionCapability;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.LambdaArgumentTypePlaceholder;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistFactory;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistFieldDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistInterfaceDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistMethodDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistTypeDeclarationAdapter;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistUtils;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.logic.AbstractClassDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.model.resolution.SymbolReference;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.model.resolution.TypeSolver;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.model.typesystem.ReferenceTypeImpl;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.MethodResolutionLogic;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.SymbolSolver;

public class JavassistClassDeclaration
extends AbstractClassDeclaration
implements MethodUsageResolutionCapability {
    private CtClass ctClass;
    private TypeSolver typeSolver;
    private JavassistTypeDeclarationAdapter javassistTypeDeclarationAdapter;

    public JavassistClassDeclaration(CtClass ctClass, TypeSolver typeSolver) {
        if (ctClass == null) {
            throw new IllegalArgumentException();
        }
        if (ctClass.isInterface() || ctClass.isAnnotation() || ctClass.isPrimitive() || ctClass.isEnum()) {
            throw new IllegalArgumentException("Trying to instantiate a JavassistClassDeclaration with something which is not a class: " + ctClass.toString());
        }
        this.ctClass = ctClass;
        this.typeSolver = typeSolver;
        this.javassistTypeDeclarationAdapter = new JavassistTypeDeclarationAdapter(ctClass, typeSolver);
    }

    @Override
    protected ResolvedReferenceType object() {
        return new ReferenceTypeImpl(this.typeSolver.solveType(Object.class.getCanonicalName()), this.typeSolver);
    }

    @Override
    public boolean hasDirectlyAnnotation(String canonicalName) {
        return this.ctClass.hasAnnotation(canonicalName);
    }

    @Override
    public Set<ResolvedMethodDeclaration> getDeclaredMethods() {
        return this.javassistTypeDeclarationAdapter.getDeclaredMethods();
    }

    @Override
    public boolean isAssignableBy(ResolvedReferenceTypeDeclaration other) {
        return this.isAssignableBy(new ReferenceTypeImpl(other, this.typeSolver));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavassistClassDeclaration that = (JavassistClassDeclaration)o;
        return this.ctClass.equals(that.ctClass);
    }

    public int hashCode() {
        return this.ctClass.hashCode();
    }

    @Override
    public String getPackageName() {
        return this.ctClass.getPackageName();
    }

    @Override
    public String getClassName() {
        String className = this.ctClass.getName().replace('$', '.');
        if (this.getPackageName() != null) {
            return className.substring(this.getPackageName().length() + 1);
        }
        return className;
    }

    @Override
    public String getQualifiedName() {
        return this.ctClass.getName().replace('$', '.');
    }

    @Override
    @Deprecated
    public Optional<MethodUsage> solveMethodAsUsage(String name, List<ResolvedType> argumentsTypes, Context invokationContext, List<ResolvedType> typeParameterValues) {
        return JavassistUtils.getMethodUsage(this.ctClass, name, argumentsTypes, this.typeSolver, this.getTypeParameters(), typeParameterValues);
    }

    @Deprecated
    public SymbolReference<? extends ResolvedValueDeclaration> solveSymbol(String name, TypeSolver typeSolver) {
        String[] interfaceFQNs;
        for (CtField field : this.ctClass.getDeclaredFields()) {
            if (!field.getName().equals(name)) continue;
            return SymbolReference.solved(new JavassistFieldDeclaration(field, typeSolver));
        }
        String superclassFQN = this.getSuperclassFQN();
        SymbolReference<? extends ResolvedValueDeclaration> ref = this.solveSymbolForFQN(name, superclassFQN);
        if (ref.isSolved()) {
            return ref;
        }
        for (String interfaceFQN : interfaceFQNs = this.getInterfaceFQNs()) {
            SymbolReference<? extends ResolvedValueDeclaration> interfaceRef = this.solveSymbolForFQN(name, interfaceFQN);
            if (!interfaceRef.isSolved()) continue;
            return interfaceRef;
        }
        return SymbolReference.unsolved(ResolvedValueDeclaration.class);
    }

    private SymbolReference<? extends ResolvedValueDeclaration> solveSymbolForFQN(String symbolName, String fqn) {
        if (fqn == null) {
            return SymbolReference.unsolved(ResolvedValueDeclaration.class);
        }
        ResolvedReferenceTypeDeclaration fqnTypeDeclaration = this.typeSolver.solveType(fqn);
        return new SymbolSolver(this.typeSolver).solveSymbolInType(fqnTypeDeclaration, symbolName);
    }

    private String[] getInterfaceFQNs() {
        return this.ctClass.getClassFile().getInterfaces();
    }

    private String getSuperclassFQN() {
        return this.ctClass.getClassFile().getSuperclass();
    }

    @Override
    public List<ResolvedReferenceType> getAncestors(boolean acceptIncompleteList) {
        ArrayList<ResolvedReferenceType> ancestors;
        block6: {
            block5: {
                ancestors = new ArrayList<ResolvedReferenceType>();
                try {
                    ResolvedReferenceType superClass = this.getSuperClass();
                    if (superClass != null) {
                        ancestors.add(superClass);
                    }
                }
                catch (UnsolvedSymbolException e) {
                    if (acceptIncompleteList) break block5;
                    throw e;
                }
            }
            try {
                ancestors.addAll(this.getInterfaces());
            }
            catch (UnsolvedSymbolException e) {
                if (acceptIncompleteList) break block6;
                throw e;
            }
        }
        return ancestors;
    }

    @Override
    @Deprecated
    public SymbolReference<ResolvedMethodDeclaration> solveMethod(String name, List<ResolvedType> argumentsTypes, boolean staticOnly) {
        ArrayList<ResolvedMethodDeclaration> candidates = new ArrayList<ResolvedMethodDeclaration>();
        Predicate<CtMethod> staticOnlyCheck = m -> !staticOnly || staticOnly && Modifier.isStatic(m.getModifiers());
        for (CtMethod method : this.ctClass.getDeclaredMethods()) {
            boolean isNotBridge;
            boolean isSynthetic = method.getMethodInfo().getAttribute("Synthetic") != null;
            boolean bl = isNotBridge = (method.getMethodInfo().getAccessFlags() & 0x40) == 0;
            if (!method.getName().equals(name) || isSynthetic || !isNotBridge || !staticOnlyCheck.test(method)) continue;
            candidates.add(new JavassistMethodDeclaration(method, this.typeSolver));
        }
        SymbolReference<ResolvedMethodDeclaration> superClassMethodRef = MethodResolutionLogic.solveMethodInType(this.getSuperClass().getTypeDeclaration(), name, argumentsTypes, staticOnly);
        if (superClassMethodRef.isSolved()) {
            candidates.add(superClassMethodRef.getCorrespondingDeclaration());
        }
        for (ResolvedReferenceType interfaceRef : this.getInterfaces()) {
            SymbolReference<ResolvedMethodDeclaration> interfaceMethodRef = MethodResolutionLogic.solveMethodInType(interfaceRef.getTypeDeclaration(), name, argumentsTypes, staticOnly);
            if (!interfaceMethodRef.isSolved()) continue;
            candidates.add(interfaceMethodRef.getCorrespondingDeclaration());
        }
        return MethodResolutionLogic.findMostApplicable(candidates, name, argumentsTypes, this.typeSolver);
    }

    public ResolvedType getUsage(Node node) {
        return new ReferenceTypeImpl((ResolvedReferenceTypeDeclaration)this, this.typeSolver);
    }

    @Override
    public boolean isAssignableBy(ResolvedType type) {
        if (type.isNull()) {
            return true;
        }
        if (type instanceof LambdaArgumentTypePlaceholder) {
            return this.isFunctionalInterface();
        }
        if (type.describe().equals(this.getQualifiedName())) {
            return true;
        }
        try {
            if (this.ctClass.getSuperclass() != null && new JavassistClassDeclaration(this.ctClass.getSuperclass(), this.typeSolver).isAssignableBy(type)) {
                return true;
            }
            for (CtClass interfaze : this.ctClass.getInterfaces()) {
                if (!new JavassistInterfaceDeclaration(interfaze, this.typeSolver).isAssignableBy(type)) continue;
                return true;
            }
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    @Override
    public boolean isTypeParameter() {
        return false;
    }

    @Override
    public List<ResolvedFieldDeclaration> getAllFields() {
        return this.javassistTypeDeclarationAdapter.getDeclaredFields();
    }

    @Override
    public String getName() {
        String[] nameElements = this.ctClass.getSimpleName().replace('$', '.').split("\\.");
        return nameElements[nameElements.length - 1];
    }

    @Override
    public boolean isField() {
        return false;
    }

    @Override
    public boolean isParameter() {
        return false;
    }

    @Override
    public boolean isType() {
        return true;
    }

    @Override
    public boolean isClass() {
        return !this.ctClass.isInterface();
    }

    @Override
    public ResolvedReferenceType getSuperClass() {
        try {
            if (this.ctClass.getClassFile().getSuperclass() == null) {
                return new ReferenceTypeImpl(this.typeSolver.solveType(Object.class.getCanonicalName()), this.typeSolver);
            }
            if (this.ctClass.getGenericSignature() == null) {
                return new ReferenceTypeImpl(this.typeSolver.solveType(JavassistUtils.internalNameToCanonicalName(this.ctClass.getClassFile().getSuperclass())), this.typeSolver);
            }
            SignatureAttribute.ClassSignature classSignature = SignatureAttribute.toClassSignature((String)this.ctClass.getGenericSignature());
            return JavassistUtils.signatureTypeToType((SignatureAttribute.Type)classSignature.getSuperClass(), this.typeSolver, this).asReferenceType();
        }
        catch (BadBytecode e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<ResolvedReferenceType> getInterfaces() {
        try {
            if (this.ctClass.getGenericSignature() == null) {
                return Arrays.stream(this.ctClass.getClassFile().getInterfaces()).map(i -> this.typeSolver.solveType(JavassistUtils.internalNameToCanonicalName(i))).map(i -> new ReferenceTypeImpl((ResolvedReferenceTypeDeclaration)i, this.typeSolver)).collect(Collectors.toList());
            }
            SignatureAttribute.ClassSignature classSignature = SignatureAttribute.toClassSignature((String)this.ctClass.getGenericSignature());
            return Arrays.stream(classSignature.getInterfaces()).map(i -> JavassistUtils.signatureTypeToType((SignatureAttribute.Type)i, this.typeSolver, this).asReferenceType()).collect(Collectors.toList());
        }
        catch (BadBytecode e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isInterface() {
        return this.ctClass.isInterface();
    }

    public String toString() {
        return "JavassistClassDeclaration {" + this.ctClass.getName() + '}';
    }

    @Override
    public List<ResolvedTypeParameterDeclaration> getTypeParameters() {
        return this.javassistTypeDeclarationAdapter.getTypeParameters();
    }

    @Override
    public Modifier.Keyword accessSpecifier() {
        return JavassistFactory.modifiersToAccessLevel(this.ctClass.getModifiers());
    }

    @Override
    public List<ResolvedConstructorDeclaration> getConstructors() {
        return this.javassistTypeDeclarationAdapter.getConstructors();
    }

    @Override
    public Optional<ResolvedReferenceTypeDeclaration> containerType() {
        return this.javassistTypeDeclarationAdapter.containerType();
    }

    @Override
    public Set<ResolvedReferenceTypeDeclaration> internalTypes() {
        try {
            return Arrays.stream(this.ctClass.getDeclaredClasses()).map(itype -> JavassistFactory.toTypeDeclaration(itype, this.typeSolver)).collect(Collectors.toSet());
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ResolvedReferenceTypeDeclaration getInternalType(String name) {
        Optional<ResolvedReferenceTypeDeclaration> type = this.internalTypes().stream().filter(f -> f.getName().endsWith(name)).findFirst();
        return type.orElseThrow(() -> new UnsolvedSymbolException("Internal type not found: " + name));
    }

    @Override
    public boolean hasInternalType(String name) {
        return this.internalTypes().stream().anyMatch(f -> f.getName().endsWith(name));
    }

    @Override
    public Optional<Node> toAst() {
        return Optional.empty();
    }
}

