/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javassist.CtBehavior;
import javassist.CtConstructor;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.SignatureAttribute;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.Modifier;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.ConstructorDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedClassDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedConstructorDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedParameterDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedType;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistClassDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistFactory;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistParameterDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistTypeParameter;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistUtils;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.model.resolution.TypeSolver;

public class JavassistConstructorDeclaration
implements ResolvedConstructorDeclaration {
    private final CtConstructor ctConstructor;
    private final TypeSolver typeSolver;

    public JavassistConstructorDeclaration(CtConstructor ctConstructor, TypeSolver typeSolver) {
        this.ctConstructor = ctConstructor;
        this.typeSolver = typeSolver;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{ctConstructor=" + this.ctConstructor.getName() + ", typeSolver=" + this.typeSolver + '}';
    }

    @Override
    public String getName() {
        return this.ctConstructor.getName();
    }

    @Override
    public boolean isField() {
        return false;
    }

    @Override
    public boolean isParameter() {
        return false;
    }

    @Override
    public boolean isType() {
        return false;
    }

    @Override
    public ResolvedClassDeclaration declaringType() {
        return new JavassistClassDeclaration(this.ctConstructor.getDeclaringClass(), this.typeSolver);
    }

    @Override
    public int getNumberOfParams() {
        try {
            return this.ctConstructor.getParameterTypes().length;
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ResolvedParameterDeclaration getParam(int i) {
        try {
            boolean variadic = false;
            if ((this.ctConstructor.getModifiers() & 0x80) > 0) {
                variadic = i == this.ctConstructor.getParameterTypes().length - 1;
            }
            Optional<String> paramName = JavassistUtils.extractParameterName((CtBehavior)this.ctConstructor, i);
            if (this.ctConstructor.getGenericSignature() != null) {
                SignatureAttribute.MethodSignature methodSignature = SignatureAttribute.toMethodSignature((String)this.ctConstructor.getGenericSignature());
                SignatureAttribute.Type signatureType = methodSignature.getParameterTypes()[i];
                return new JavassistParameterDeclaration(JavassistUtils.signatureTypeToType(signatureType, this.typeSolver, this), this.typeSolver, variadic, (String)paramName.orElse(null));
            }
            return new JavassistParameterDeclaration(this.ctConstructor.getParameterTypes()[i], this.typeSolver, variadic, (String)paramName.orElse(null));
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (BadBytecode badBytecode) {
            throw new RuntimeException(badBytecode);
        }
    }

    @Override
    public List<ResolvedTypeParameterDeclaration> getTypeParameters() {
        try {
            if (this.ctConstructor.getGenericSignature() == null) {
                return Collections.emptyList();
            }
            SignatureAttribute.MethodSignature methodSignature = SignatureAttribute.toMethodSignature((String)this.ctConstructor.getGenericSignature());
            return Arrays.stream(methodSignature.getTypeParameters()).map(jasTp -> new JavassistTypeParameter((SignatureAttribute.TypeParameter)jasTp, this, this.typeSolver)).collect(Collectors.toList());
        }
        catch (BadBytecode badBytecode) {
            throw new RuntimeException(badBytecode);
        }
    }

    @Override
    public Modifier.Keyword accessSpecifier() {
        return JavassistFactory.modifiersToAccessLevel(this.ctConstructor.getModifiers());
    }

    @Override
    public int getNumberOfSpecifiedExceptions() {
        try {
            return this.ctConstructor.getExceptionTypes().length;
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ResolvedType getSpecifiedException(int index) {
        if (index < 0 || index >= this.getNumberOfSpecifiedExceptions()) {
            throw new IllegalArgumentException(String.format("No exception with index %d. Number of exceptions: %d", index, this.getNumberOfSpecifiedExceptions()));
        }
        try {
            return JavassistFactory.typeUsageFor(this.ctConstructor.getExceptionTypes()[index], this.typeSolver);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Optional<ConstructorDeclaration> toAst() {
        return Optional.empty();
    }
}

