/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.Modifier;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.MethodUsage;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.UnsolvedSymbolException;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedConstructorDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedEnumConstantDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedEnumDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedFieldDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedValueDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedReferenceType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedType;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.core.resolution.Context;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.core.resolution.MethodUsageResolutionCapability;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistClassDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistEnumConstantDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistFactory;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistFieldDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistMethodDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistTypeDeclarationAdapter;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistUtils;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.logic.AbstractTypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.logic.MethodResolutionCapability;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.model.resolution.SymbolReference;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.model.resolution.TypeSolver;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.model.typesystem.ReferenceTypeImpl;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.MethodResolutionLogic;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.SymbolSolver;

public class JavassistEnumDeclaration
extends AbstractTypeDeclaration
implements ResolvedEnumDeclaration,
MethodResolutionCapability,
MethodUsageResolutionCapability {
    private CtClass ctClass;
    private TypeSolver typeSolver;
    private JavassistTypeDeclarationAdapter javassistTypeDeclarationAdapter;

    public JavassistEnumDeclaration(CtClass ctClass, TypeSolver typeSolver) {
        if (ctClass == null) {
            throw new IllegalArgumentException();
        }
        if (!ctClass.isEnum()) {
            throw new IllegalArgumentException("Trying to instantiate a JavassistEnumDeclaration with something which is not an enum: " + ctClass.toString());
        }
        this.ctClass = ctClass;
        this.typeSolver = typeSolver;
        this.javassistTypeDeclarationAdapter = new JavassistTypeDeclarationAdapter(ctClass, typeSolver);
    }

    @Override
    public Modifier.Keyword accessSpecifier() {
        return JavassistFactory.modifiersToAccessLevel(this.ctClass.getModifiers());
    }

    @Override
    public String getPackageName() {
        return this.ctClass.getPackageName();
    }

    @Override
    public String getClassName() {
        String name = this.ctClass.getName().replace('$', '.');
        if (this.getPackageName() != null) {
            return name.substring(this.getPackageName().length() + 1, name.length());
        }
        return name;
    }

    @Override
    public String getQualifiedName() {
        return this.ctClass.getName().replace('$', '.');
    }

    @Override
    public List<ResolvedReferenceType> getAncestors(boolean acceptIncompleteList) {
        ArrayList<ResolvedReferenceType> ancestors;
        block6: {
            ancestors = new ArrayList<ResolvedReferenceType>();
            String superClassName = this.ctClass.getClassFile().getSuperclass();
            if (superClassName != null) {
                try {
                    ancestors.add(new ReferenceTypeImpl(this.typeSolver.solveType(superClassName), this.typeSolver));
                }
                catch (UnsolvedSymbolException e) {
                    if (acceptIncompleteList) break block6;
                    throw e;
                }
            }
        }
        for (String interfazeName : this.ctClass.getClassFile().getInterfaces()) {
            try {
                ancestors.add(new ReferenceTypeImpl(this.typeSolver.solveType(interfazeName), this.typeSolver));
            }
            catch (UnsolvedSymbolException e) {
                if (acceptIncompleteList) continue;
                throw e;
            }
        }
        return ancestors;
    }

    @Override
    public ResolvedFieldDeclaration getField(String name) {
        Optional<ResolvedFieldDeclaration> field = this.javassistTypeDeclarationAdapter.getDeclaredFields().stream().filter(f -> f.getName().equals(name)).findFirst();
        return field.orElseThrow(() -> new RuntimeException("Field " + name + " does not exist in " + this.ctClass.getName() + "."));
    }

    @Override
    public boolean hasField(String name) {
        return this.javassistTypeDeclarationAdapter.getDeclaredFields().stream().anyMatch(f -> f.getName().equals(name));
    }

    @Override
    public List<ResolvedFieldDeclaration> getAllFields() {
        return this.javassistTypeDeclarationAdapter.getDeclaredFields();
    }

    @Override
    public Set<ResolvedMethodDeclaration> getDeclaredMethods() {
        return this.javassistTypeDeclarationAdapter.getDeclaredMethods();
    }

    @Override
    public boolean isAssignableBy(ResolvedType type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAssignableBy(ResolvedReferenceTypeDeclaration other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasDirectlyAnnotation(String canonicalName) {
        return this.ctClass.hasAnnotation(canonicalName);
    }

    @Override
    public String getName() {
        String[] nameElements = this.ctClass.getSimpleName().replace('$', '.').split("\\.");
        return nameElements[nameElements.length - 1];
    }

    @Override
    public List<ResolvedTypeParameterDeclaration> getTypeParameters() {
        return this.javassistTypeDeclarationAdapter.getTypeParameters();
    }

    @Override
    public Optional<ResolvedReferenceTypeDeclaration> containerType() {
        return this.javassistTypeDeclarationAdapter.containerType();
    }

    @Override
    public SymbolReference<ResolvedMethodDeclaration> solveMethod(String name, List<ResolvedType> argumentsTypes, boolean staticOnly) {
        ArrayList<ResolvedMethodDeclaration> candidates = new ArrayList<ResolvedMethodDeclaration>();
        Predicate<CtMethod> staticOnlyCheck = m -> !staticOnly || staticOnly && Modifier.isStatic(m.getModifiers());
        for (CtMethod method : this.ctClass.getDeclaredMethods()) {
            boolean isNotBridge;
            boolean isSynthetic = method.getMethodInfo().getAttribute("Synthetic") != null;
            boolean bl = isNotBridge = (method.getMethodInfo().getAccessFlags() & 0x40) == 0;
            if (!method.getName().equals(name) || isSynthetic || !isNotBridge || !staticOnlyCheck.test(method)) continue;
            candidates.add(new JavassistMethodDeclaration(method, this.typeSolver));
        }
        try {
            SymbolReference<ResolvedMethodDeclaration> ref;
            CtClass superClass = this.ctClass.getSuperclass();
            if (superClass != null && (ref = new JavassistClassDeclaration(superClass, this.typeSolver).solveMethod(name, argumentsTypes, staticOnly)).isSolved()) {
                candidates.add(ref.getCorrespondingDeclaration());
            }
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        return MethodResolutionLogic.findMostApplicable(candidates, name, argumentsTypes, this.typeSolver);
    }

    @Override
    public Optional<MethodUsage> solveMethodAsUsage(String name, List<ResolvedType> argumentsTypes, Context invokationContext, List<ResolvedType> typeParameterValues) {
        return JavassistUtils.getMethodUsage(this.ctClass, name, argumentsTypes, this.typeSolver, this.getTypeParameters(), typeParameterValues);
    }

    @Override
    public Set<ResolvedReferenceTypeDeclaration> internalTypes() {
        try {
            return Arrays.stream(this.ctClass.getDeclaredClasses()).map(itype -> JavassistFactory.toTypeDeclaration(itype, this.typeSolver)).collect(Collectors.toSet());
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ResolvedReferenceTypeDeclaration getInternalType(String name) {
        Optional<ResolvedReferenceTypeDeclaration> type = this.internalTypes().stream().filter(f -> f.getName().endsWith(name)).findFirst();
        return type.orElseThrow(() -> new UnsolvedSymbolException("Internal type not found: " + name));
    }

    @Override
    public boolean hasInternalType(String name) {
        return this.internalTypes().stream().anyMatch(f -> f.getName().endsWith(name));
    }

    public SymbolReference<? extends ResolvedValueDeclaration> solveSymbol(String name, TypeSolver typeSolver) {
        String[] interfaceFQNs;
        for (CtField field : this.ctClass.getDeclaredFields()) {
            if (!field.getName().equals(name)) continue;
            return SymbolReference.solved(new JavassistFieldDeclaration(field, typeSolver));
        }
        for (String interfaceFQN : interfaceFQNs = this.getInterfaceFQNs()) {
            SymbolReference<? extends ResolvedValueDeclaration> interfaceRef = this.solveSymbolForFQN(name, interfaceFQN);
            if (!interfaceRef.isSolved()) continue;
            return interfaceRef;
        }
        return SymbolReference.unsolved(ResolvedValueDeclaration.class);
    }

    private SymbolReference<? extends ResolvedValueDeclaration> solveSymbolForFQN(String symbolName, String fqn) {
        if (fqn == null) {
            return SymbolReference.unsolved(ResolvedValueDeclaration.class);
        }
        ResolvedReferenceTypeDeclaration fqnTypeDeclaration = this.typeSolver.solveType(fqn);
        return new SymbolSolver(this.typeSolver).solveSymbolInType(fqnTypeDeclaration, symbolName);
    }

    private String[] getInterfaceFQNs() {
        return this.ctClass.getClassFile().getInterfaces();
    }

    @Override
    public List<ResolvedEnumConstantDeclaration> getEnumConstants() {
        return Arrays.stream(this.ctClass.getFields()).filter(f -> (f.getFieldInfo2().getAccessFlags() & 0x4000) != 0).map(f -> new JavassistEnumConstantDeclaration((CtField)f, this.typeSolver)).collect(Collectors.toList());
    }

    @Override
    public List<ResolvedConstructorDeclaration> getConstructors() {
        return this.javassistTypeDeclarationAdapter.getConstructors();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{ctClass=" + this.ctClass.getName() + ", typeSolver=" + this.typeSolver + '}';
    }
}

