/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.Modifier;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.ClassOrInterfaceDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.MethodUsage;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.UnsolvedSymbolException;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedConstructorDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedFieldDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedInterfaceDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedValueDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedReferenceType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedType;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.core.resolution.Context;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.core.resolution.MethodUsageResolutionCapability;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistClassDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistFactory;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistFieldDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistMethodDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistTypeDeclarationAdapter;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistUtils;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.logic.AbstractTypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.logic.MethodResolutionCapability;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.model.resolution.SymbolReference;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.model.resolution.TypeSolver;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.model.typesystem.ReferenceTypeImpl;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.MethodResolutionLogic;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.SymbolSolver;

public class JavassistInterfaceDeclaration
extends AbstractTypeDeclaration
implements ResolvedInterfaceDeclaration,
MethodResolutionCapability,
MethodUsageResolutionCapability {
    private CtClass ctClass;
    private TypeSolver typeSolver;
    private JavassistTypeDeclarationAdapter javassistTypeDeclarationAdapter;

    public String toString() {
        return "JavassistInterfaceDeclaration{ctClass=" + this.ctClass.getName() + ", typeSolver=" + this.typeSolver + '}';
    }

    public JavassistInterfaceDeclaration(CtClass ctClass, TypeSolver typeSolver) {
        if (!ctClass.isInterface()) {
            throw new IllegalArgumentException("Not an interface: " + ctClass.getName());
        }
        this.ctClass = ctClass;
        this.typeSolver = typeSolver;
        this.javassistTypeDeclarationAdapter = new JavassistTypeDeclarationAdapter(ctClass, typeSolver);
    }

    @Override
    public List<ResolvedReferenceType> getInterfacesExtended() {
        return Arrays.stream(this.ctClass.getClassFile().getInterfaces()).map(i -> this.typeSolver.solveType((String)i)).map(i -> new ReferenceTypeImpl((ResolvedReferenceTypeDeclaration)i, this.typeSolver)).collect(Collectors.toList());
    }

    @Override
    public String getPackageName() {
        return this.ctClass.getPackageName();
    }

    @Override
    public String getClassName() {
        String className = this.ctClass.getName().replace('$', '.');
        if (this.getPackageName() != null) {
            return className.substring(this.getPackageName().length() + 1);
        }
        return className;
    }

    @Override
    public String getQualifiedName() {
        return this.ctClass.getName().replace('$', '.');
    }

    @Override
    @Deprecated
    public Optional<MethodUsage> solveMethodAsUsage(String name, List<ResolvedType> argumentsTypes, Context invokationContext, List<ResolvedType> typeParameterValues) {
        return JavassistUtils.getMethodUsage(this.ctClass, name, argumentsTypes, this.typeSolver, this.getTypeParameters(), typeParameterValues);
    }

    @Override
    @Deprecated
    public SymbolReference<ResolvedMethodDeclaration> solveMethod(String name, List<ResolvedType> argumentsTypes, boolean staticOnly) {
        ArrayList<ResolvedMethodDeclaration> candidates = new ArrayList<ResolvedMethodDeclaration>();
        Predicate<CtMethod> staticOnlyCheck = m -> !staticOnly || staticOnly && Modifier.isStatic(m.getModifiers());
        CtMethod[] ctMethodArray = this.ctClass.getDeclaredMethods();
        int n = ctMethodArray.length;
        for (int i = 0; i < n; ++i) {
            boolean isNotBridge;
            CtMethod method = ctMethodArray[i];
            boolean isSynthetic = method.getMethodInfo().getAttribute("Synthetic") != null;
            boolean bl = isNotBridge = (method.getMethodInfo().getAccessFlags() & 0x40) == 0;
            if (!method.getName().equals(name) || isSynthetic || !isNotBridge || !staticOnlyCheck.test(method)) continue;
            candidates.add(new JavassistMethodDeclaration(method, this.typeSolver));
        }
        try {
            SymbolReference<ResolvedMethodDeclaration> ref;
            CtClass superClass = this.ctClass.getSuperclass();
            if (superClass != null && (ref = new JavassistClassDeclaration(superClass, this.typeSolver).solveMethod(name, argumentsTypes, staticOnly)).isSolved()) {
                candidates.add(ref.getCorrespondingDeclaration());
            }
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            for (CtClass interfaze : this.ctClass.getInterfaces()) {
                SymbolReference<ResolvedMethodDeclaration> ref = new JavassistInterfaceDeclaration(interfaze, this.typeSolver).solveMethod(name, argumentsTypes, staticOnly);
                if (!ref.isSolved()) continue;
                candidates.add(ref.getCorrespondingDeclaration());
            }
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        return MethodResolutionLogic.findMostApplicable(candidates, name, argumentsTypes, this.typeSolver);
    }

    @Override
    public boolean isAssignableBy(ResolvedType type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ResolvedFieldDeclaration> getAllFields() {
        return this.javassistTypeDeclarationAdapter.getDeclaredFields();
    }

    @Override
    public boolean isAssignableBy(ResolvedReferenceTypeDeclaration other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ResolvedReferenceType> getAncestors(boolean acceptIncompleteList) {
        List<Object> ancestors = new ArrayList();
        try {
            for (CtClass interfaze : this.ctClass.getInterfaces()) {
                try {
                    ResolvedReferenceType superInterfaze = JavassistFactory.typeUsageFor(interfaze, this.typeSolver).asReferenceType();
                    ancestors.add(superInterfaze);
                }
                catch (UnsolvedSymbolException e) {
                    if (acceptIncompleteList) continue;
                    throw e;
                }
            }
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        ancestors = ancestors.stream().filter(a -> !a.getQualifiedName().equals(Object.class.getCanonicalName())).collect(Collectors.toList());
        ancestors.add(new ReferenceTypeImpl(this.typeSolver.solveType(Object.class.getCanonicalName()), this.typeSolver));
        return ancestors;
    }

    @Override
    public Set<ResolvedMethodDeclaration> getDeclaredMethods() {
        return Arrays.stream(this.ctClass.getDeclaredMethods()).map(m -> new JavassistMethodDeclaration((CtMethod)m, this.typeSolver)).collect(Collectors.toSet());
    }

    @Override
    public boolean hasDirectlyAnnotation(String canonicalName) {
        return this.ctClass.hasAnnotation(canonicalName);
    }

    @Override
    public String getName() {
        String[] nameElements = this.ctClass.getSimpleName().replace('$', '.').split("\\.");
        return nameElements[nameElements.length - 1];
    }

    @Override
    public List<ResolvedTypeParameterDeclaration> getTypeParameters() {
        return this.javassistTypeDeclarationAdapter.getTypeParameters();
    }

    @Override
    public Modifier.Keyword accessSpecifier() {
        return JavassistFactory.modifiersToAccessLevel(this.ctClass.getModifiers());
    }

    @Override
    public ResolvedInterfaceDeclaration asInterface() {
        return this;
    }

    @Deprecated
    public SymbolReference<? extends ResolvedValueDeclaration> solveSymbol(String name, TypeSolver typeSolver) {
        String[] interfaceFQNs;
        for (CtField field : this.ctClass.getDeclaredFields()) {
            if (!field.getName().equals(name)) continue;
            return SymbolReference.solved(new JavassistFieldDeclaration(field, typeSolver));
        }
        for (String interfaceFQN : interfaceFQNs = this.getInterfaceFQNs()) {
            SymbolReference<? extends ResolvedValueDeclaration> interfaceRef = this.solveSymbolForFQN(name, interfaceFQN);
            if (!interfaceRef.isSolved()) continue;
            return interfaceRef;
        }
        return SymbolReference.unsolved(ResolvedValueDeclaration.class);
    }

    private SymbolReference<? extends ResolvedValueDeclaration> solveSymbolForFQN(String symbolName, String fqn) {
        if (fqn == null) {
            return SymbolReference.unsolved(ResolvedValueDeclaration.class);
        }
        ResolvedReferenceTypeDeclaration fqnTypeDeclaration = this.typeSolver.solveType(fqn);
        return new SymbolSolver(this.typeSolver).solveSymbolInType(fqnTypeDeclaration, symbolName);
    }

    private String[] getInterfaceFQNs() {
        return this.ctClass.getClassFile().getInterfaces();
    }

    @Override
    public Optional<ResolvedReferenceTypeDeclaration> containerType() {
        return this.javassistTypeDeclarationAdapter.containerType();
    }

    @Override
    public Set<ResolvedReferenceTypeDeclaration> internalTypes() {
        try {
            return Arrays.stream(this.ctClass.getDeclaredClasses()).map(itype -> JavassistFactory.toTypeDeclaration(itype, this.typeSolver)).collect(Collectors.toSet());
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ResolvedReferenceTypeDeclaration getInternalType(String name) {
        Optional<ResolvedReferenceTypeDeclaration> type = this.internalTypes().stream().filter(f -> f.getName().endsWith(name)).findFirst();
        return type.orElseThrow(() -> new UnsolvedSymbolException("Internal type not found: " + name));
    }

    @Override
    public boolean hasInternalType(String name) {
        return this.internalTypes().stream().anyMatch(f -> f.getName().endsWith(name));
    }

    @Override
    public List<ResolvedConstructorDeclaration> getConstructors() {
        return Collections.emptyList();
    }

    @Override
    public Optional<ClassOrInterfaceDeclaration> toAst() {
        return Optional.empty();
    }
}

