/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javassist.CtBehavior;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.SignatureAttribute;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.Modifier;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.Node;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.MethodDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.MethodUsage;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedParameterDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedType;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.core.resolution.Context;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.core.resolution.TypeVariableResolutionCapability;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.declarations.common.MethodDeclarationCommonLogic;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistClassDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistEnumDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistFactory;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistInterfaceDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistParameterDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistTypeParameter;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistUtils;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.model.resolution.TypeSolver;

public class JavassistMethodDeclaration
implements ResolvedMethodDeclaration,
TypeVariableResolutionCapability {
    private CtMethod ctMethod;
    private TypeSolver typeSolver;

    public JavassistMethodDeclaration(CtMethod ctMethod, TypeSolver typeSolver) {
        this.ctMethod = ctMethod;
        this.typeSolver = typeSolver;
    }

    @Override
    public boolean isDefaultMethod() {
        return this.ctMethod.getDeclaringClass().isInterface() && !this.isAbstract();
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.ctMethod.getModifiers());
    }

    public String toString() {
        return "JavassistMethodDeclaration{ctMethod=" + this.ctMethod + '}';
    }

    @Override
    public String getName() {
        return this.ctMethod.getName();
    }

    @Override
    public boolean isField() {
        return false;
    }

    @Override
    public boolean isParameter() {
        return false;
    }

    @Override
    public boolean isType() {
        return false;
    }

    @Override
    public ResolvedReferenceTypeDeclaration declaringType() {
        if (this.ctMethod.getDeclaringClass().isInterface()) {
            return new JavassistInterfaceDeclaration(this.ctMethod.getDeclaringClass(), this.typeSolver);
        }
        if (this.ctMethod.getDeclaringClass().isEnum()) {
            return new JavassistEnumDeclaration(this.ctMethod.getDeclaringClass(), this.typeSolver);
        }
        return new JavassistClassDeclaration(this.ctMethod.getDeclaringClass(), this.typeSolver);
    }

    @Override
    public ResolvedType getReturnType() {
        try {
            if (this.ctMethod.getGenericSignature() != null) {
                SignatureAttribute.Type genericSignatureType = SignatureAttribute.toMethodSignature((String)this.ctMethod.getGenericSignature()).getReturnType();
                return JavassistUtils.signatureTypeToType(genericSignatureType, this.typeSolver, this);
            }
            return JavassistFactory.typeUsageFor(this.ctMethod.getReturnType(), this.typeSolver);
        }
        catch (NotFoundException | BadBytecode e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getNumberOfParams() {
        try {
            return this.ctMethod.getParameterTypes().length;
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ResolvedParameterDeclaration getParam(int i) {
        try {
            boolean variadic = false;
            if ((this.ctMethod.getModifiers() & 0x80) > 0) {
                variadic = i == this.ctMethod.getParameterTypes().length - 1;
            }
            Optional<String> paramName = JavassistUtils.extractParameterName((CtBehavior)this.ctMethod, i);
            String signature = this.ctMethod.getGenericSignature() == null ? this.ctMethod.getSignature() : this.ctMethod.getGenericSignature();
            SignatureAttribute.MethodSignature methodSignature = SignatureAttribute.toMethodSignature((String)signature);
            SignatureAttribute.Type signatureType = methodSignature.getParameterTypes()[i];
            return new JavassistParameterDeclaration(JavassistUtils.signatureTypeToType(signatureType, this.typeSolver, this), this.typeSolver, variadic, (String)paramName.orElse(null));
        }
        catch (NotFoundException | BadBytecode e) {
            throw new RuntimeException(e);
        }
    }

    public MethodUsage getUsage(Node node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MethodUsage resolveTypeVariables(Context context, List<ResolvedType> parameterTypes) {
        return new MethodDeclarationCommonLogic(this, this.typeSolver).resolveTypeVariables(context, parameterTypes);
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.ctMethod.getModifiers());
    }

    @Override
    public List<ResolvedTypeParameterDeclaration> getTypeParameters() {
        try {
            if (this.ctMethod.getGenericSignature() == null) {
                return new ArrayList<ResolvedTypeParameterDeclaration>();
            }
            SignatureAttribute.MethodSignature methodSignature = SignatureAttribute.toMethodSignature((String)this.ctMethod.getGenericSignature());
            return Arrays.stream(methodSignature.getTypeParameters()).map(jasTp -> new JavassistTypeParameter((SignatureAttribute.TypeParameter)jasTp, this, this.typeSolver)).collect(Collectors.toList());
        }
        catch (BadBytecode badBytecode) {
            throw new RuntimeException(badBytecode);
        }
    }

    @Override
    public Modifier.Keyword accessSpecifier() {
        return JavassistFactory.modifiersToAccessLevel(this.ctMethod.getModifiers());
    }

    @Override
    public int getNumberOfSpecifiedExceptions() {
        try {
            return this.ctMethod.getExceptionTypes().length;
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ResolvedType getSpecifiedException(int index) {
        if (index < 0 || index >= this.getNumberOfSpecifiedExceptions()) {
            throw new IllegalArgumentException(String.format("No exception with index %d. Number of exceptions: %d", index, this.getNumberOfSpecifiedExceptions()));
        }
        try {
            return JavassistFactory.typeUsageFor(this.ctMethod.getExceptionTypes()[index], this.typeSolver);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Optional<MethodDeclaration> toAst() {
        return Optional.empty();
    }
}

