/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.logic;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedReferenceType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedTypeVariable;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedWildcard;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.logic.ObjectProvider;

public class InferenceVariableType
implements ResolvedType {
    private int id;
    private ResolvedTypeParameterDeclaration correspondingTp;
    private Set<ResolvedType> equivalentTypes = new HashSet<ResolvedType>();
    private ObjectProvider objectProvider;
    private Set<ResolvedType> superTypes = new HashSet<ResolvedType>();

    public String toString() {
        return "InferenceVariableType{id=" + this.id + '}';
    }

    public void setCorrespondingTp(ResolvedTypeParameterDeclaration correspondingTp) {
        this.correspondingTp = correspondingTp;
    }

    public void registerEquivalentType(ResolvedType type) {
        this.equivalentTypes.add(type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InferenceVariableType)) {
            return false;
        }
        InferenceVariableType that = (InferenceVariableType)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return this.id;
    }

    public InferenceVariableType(int id, ObjectProvider objectProvider) {
        this.id = id;
        this.objectProvider = objectProvider;
    }

    public static InferenceVariableType fromWildcard(ResolvedWildcard wildcard, int id, ObjectProvider objectProvider) {
        InferenceVariableType inferenceVariableType = new InferenceVariableType(id, objectProvider);
        if (wildcard.isExtends()) {
            inferenceVariableType.superTypes.add(wildcard.getBoundedType());
        }
        if (wildcard.isSuper()) {
            inferenceVariableType.superTypes.add(wildcard.getBoundedType());
        }
        return inferenceVariableType;
    }

    @Override
    public String describe() {
        return "InferenceVariable_" + this.id;
    }

    @Override
    public boolean isAssignableBy(ResolvedType other) {
        throw new UnsupportedOperationException();
    }

    private Set<ResolvedType> concreteEquivalentTypesAlsoIndirectly(Set<InferenceVariableType> considered, InferenceVariableType inferenceVariableType) {
        considered.add(inferenceVariableType);
        HashSet<ResolvedType> result = new HashSet<ResolvedType>();
        result.addAll(inferenceVariableType.equivalentTypes.stream().filter(t -> !t.isTypeVariable() && !(t instanceof InferenceVariableType)).collect(Collectors.toSet()));
        inferenceVariableType.equivalentTypes.stream().filter(t -> t instanceof InferenceVariableType).forEach(t -> {
            InferenceVariableType ivt = (InferenceVariableType)t;
            if (!considered.contains(ivt)) {
                result.addAll(this.concreteEquivalentTypesAlsoIndirectly(considered, ivt));
            }
        });
        return result;
    }

    public ResolvedType equivalentType() {
        Set<ResolvedType> concreteEquivalent = this.concreteEquivalentTypesAlsoIndirectly(new HashSet<InferenceVariableType>(), this);
        if (concreteEquivalent.isEmpty()) {
            if (this.correspondingTp == null) {
                return this.objectProvider.object();
            }
            return new ResolvedTypeVariable(this.correspondingTp);
        }
        if (concreteEquivalent.size() == 1) {
            return concreteEquivalent.iterator().next();
        }
        Set notTypeVariables = this.equivalentTypes.stream().filter(t -> !t.isTypeVariable() && !this.hasInferenceVariables((ResolvedType)t)).collect(Collectors.toSet());
        if (notTypeVariables.size() == 1) {
            return (ResolvedType)notTypeVariables.iterator().next();
        }
        if (notTypeVariables.size() == 0 && !this.superTypes.isEmpty()) {
            if (this.superTypes.size() == 1) {
                return this.superTypes.iterator().next();
            }
            throw new IllegalStateException("Super types are: " + this.superTypes);
        }
        throw new IllegalStateException("Equivalent types are: " + this.equivalentTypes);
    }

    private boolean hasInferenceVariables(ResolvedType type) {
        if (type instanceof InferenceVariableType) {
            return true;
        }
        if (type.isReferenceType()) {
            ResolvedReferenceType refType = type.asReferenceType();
            for (ResolvedType t : refType.typeParametersValues()) {
                if (!this.hasInferenceVariables(t)) continue;
                return true;
            }
            return false;
        }
        if (type.isWildcard()) {
            ResolvedWildcard wildcardType = type.asWildcard();
            return this.hasInferenceVariables(wildcardType.getBoundedType());
        }
        return false;
    }
}

