/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.typeinference;

import java.util.List;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.Node;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.ConditionalExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.EnclosedExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.Expression;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.LambdaExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.MethodCallExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.MethodReferenceExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.ObjectCreationExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.stmt.BlockStmt;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.stmt.ExpressionStmt;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.stmt.ReturnStmt;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.type.UnknownType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedType;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.model.resolution.TypeSolver;

public class ExpressionHelper {
    public static boolean isStandaloneExpression(Expression expression) {
        return !ExpressionHelper.isPolyExpression(expression);
    }

    public static boolean isPolyExpression(Expression expression) {
        if (expression instanceof EnclosedExpr) {
            throw new UnsupportedOperationException(expression.toString());
        }
        if (expression instanceof ObjectCreationExpr) {
            ObjectCreationExpr objectCreationExpr = (ObjectCreationExpr)expression;
            if (objectCreationExpr.isUsingDiamondOperator()) {
                throw new UnsupportedOperationException(expression.toString());
            }
            return false;
        }
        if (expression instanceof MethodCallExpr) {
            MethodCallExpr methodCallExpr = (MethodCallExpr)expression;
            if (!ExpressionHelper.appearsInAssignmentContext(expression) || ExpressionHelper.appearsInInvocationContext(expression)) {
                return false;
            }
            if (ExpressionHelper.isQualified(methodCallExpr) && !ExpressionHelper.elidesTypeArguments(methodCallExpr)) {
                return false;
            }
            throw new UnsupportedOperationException(expression.toString());
        }
        if (expression instanceof MethodReferenceExpr) {
            throw new UnsupportedOperationException(expression.toString());
        }
        if (expression instanceof ConditionalExpr) {
            throw new UnsupportedOperationException(expression.toString());
        }
        return expression instanceof LambdaExpr;
    }

    private static boolean elidesTypeArguments(MethodCallExpr methodCall) {
        throw new UnsupportedOperationException();
    }

    private static boolean isQualified(MethodCallExpr methodCall) {
        throw new UnsupportedOperationException();
    }

    private static boolean appearsInAssignmentContext(Expression expression) {
        if (expression.getParentNode().isPresent()) {
            Node parent = expression.getParentNode().get();
            if (parent instanceof ExpressionStmt) {
                return false;
            }
            if (parent instanceof MethodCallExpr) {
                return false;
            }
            if (parent instanceof ReturnStmt) {
                return false;
            }
            throw new UnsupportedOperationException(parent.getClass().getCanonicalName());
        }
        return false;
    }

    private static boolean appearsInInvocationContext(Expression expression) {
        if (expression.getParentNode().isPresent()) {
            Node parent = expression.getParentNode().get();
            if (parent instanceof ExpressionStmt) {
                return false;
            }
            if (parent instanceof MethodCallExpr) {
                return true;
            }
            throw new UnsupportedOperationException(parent.getClass().getCanonicalName());
        }
        return false;
    }

    public static boolean isExplicitlyTyped(LambdaExpr lambdaExpr) {
        return lambdaExpr.getParameters().stream().allMatch(p -> !(p.getType() instanceof UnknownType));
    }

    public static List<Expression> getResultExpressions(BlockStmt blockStmt) {
        throw new UnsupportedOperationException();
    }

    public static boolean isCompatibleInAssignmentContext(Expression expression, ResolvedType type, TypeSolver typeSolver) {
        return type.isAssignableBy(JavaParserFacade.get(typeSolver).getType(expression, false));
    }
}

