/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.typeinference;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.Expression;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.LambdaExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.MethodUsage;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedIntersectionType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedPrimitiveType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedReferenceType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedType;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedWildcard;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.logic.FunctionalInterfaceLogic;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.model.resolution.TypeSolver;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.model.typesystem.ReferenceTypeImpl;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.typeinference.ExpressionHelper;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.typeinference.InferenceVariable;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.typeinference.MethodType;
import org.javamodularity.moduleplugin.shadow.javaparser.utils.Pair;

public class TypeHelper {
    public static boolean isProperType(ResolvedType type) {
        if (type instanceof InferenceVariable) {
            return false;
        }
        if (type instanceof ResolvedReferenceType) {
            ResolvedReferenceType referenceType = (ResolvedReferenceType)type;
            return referenceType.typeParametersValues().stream().allMatch(it -> TypeHelper.isProperType(it));
        }
        if (type instanceof ResolvedWildcard) {
            ResolvedWildcard wildcard = (ResolvedWildcard)type;
            if (wildcard.isBounded()) {
                return TypeHelper.isProperType(wildcard.getBoundedType());
            }
            return true;
        }
        if (type.isPrimitive()) {
            return true;
        }
        if (type.isTypeVariable()) {
            return false;
        }
        if (type.isArray()) {
            return TypeHelper.isProperType(type.asArrayType().getComponentType());
        }
        throw new UnsupportedOperationException(type.toString());
    }

    public static boolean isCompatibleInAStrictInvocationContext(Expression expression, ResolvedType t) {
        throw new UnsupportedOperationException();
    }

    public static boolean isCompatibleInALooseInvocationContext(TypeSolver typeSolver, Expression expression, ResolvedType t) {
        return TypeHelper.isCompatibleInALooseInvocationContext(JavaParserFacade.get(typeSolver).getType(expression), t);
    }

    public static boolean isCompatibleInALooseInvocationContext(ResolvedType s, ResolvedType t) {
        if (s.equals(t)) {
            return true;
        }
        if (s.isPrimitive() && t.isPrimitive() && TypeHelper.areCompatibleThroughWideningPrimitiveConversion(s, t)) {
            return true;
        }
        if (s.isReferenceType() && t.isReferenceType() && TypeHelper.areCompatibleThroughWideningReferenceConversion(s, t)) {
            return true;
        }
        if (s.isPrimitive() && t.isReferenceType() && TypeHelper.areCompatibleThroughWideningReferenceConversion(TypeHelper.toBoxedType(s.asPrimitive()), t)) {
            return true;
        }
        if (TypeHelper.isUnboxable(s) && s.isReferenceType() && t.isPrimitive() && TypeHelper.areCompatibleThroughWideningPrimitiveConversion(TypeHelper.toUnboxedType(s.asReferenceType()), t)) {
            return true;
        }
        if (s.isNull() && t.isReferenceType()) {
            return true;
        }
        return t.isAssignableBy(s);
    }

    private static boolean isUnboxable(ResolvedType referenceType) {
        if (!referenceType.isReferenceType()) {
            return false;
        }
        return Arrays.stream(ResolvedPrimitiveType.values()).anyMatch(pt -> referenceType.asReferenceType().getQualifiedName().equals(pt.getBoxTypeQName()));
    }

    private static ResolvedType toUnboxedType(ResolvedReferenceType referenceType) {
        throw new UnsupportedOperationException(referenceType.toString());
    }

    private static ResolvedType toBoxedType(ResolvedPrimitiveType primitiveType) {
        throw new UnsupportedOperationException();
    }

    private static boolean areCompatibleThroughWideningReferenceConversion(ResolvedType s, ResolvedType t) {
        Optional<ResolvedPrimitiveType> correspondingPrimitiveTypeForS = Arrays.stream(ResolvedPrimitiveType.values()).filter(pt -> pt.getBoxTypeQName().equals(s.asReferenceType().getQualifiedName())).findFirst();
        if (!correspondingPrimitiveTypeForS.isPresent()) {
            return false;
        }
        throw new UnsupportedOperationException("areCompatibleThroughWideningReferenceConversion s=" + s + ", t=" + t);
    }

    private static boolean areCompatibleThroughWideningPrimitiveConversion(ResolvedType s, ResolvedType t) {
        if (s.isPrimitive() && t.isPrimitive()) {
            return s.isAssignableBy(t);
        }
        return false;
    }

    public static boolean isInferenceVariable(ResolvedType type) {
        return type instanceof InferenceVariable;
    }

    public static Set<InferenceVariable> usedInferenceVariables(ResolvedType type) {
        if (TypeHelper.isInferenceVariable(type)) {
            return new HashSet<InferenceVariable>(Arrays.asList((InferenceVariable)type));
        }
        if (type.isReferenceType()) {
            HashSet<InferenceVariable> res = new HashSet<InferenceVariable>();
            for (ResolvedType tp : type.asReferenceType().typeParametersValues()) {
                res.addAll(TypeHelper.usedInferenceVariables(tp));
            }
            return res;
        }
        throw new UnsupportedOperationException(type.toString());
    }

    public static ResolvedType leastUpperBound(Set<ResolvedType> types) {
        if (types.size() == 0) {
            throw new IllegalArgumentException();
        }
        if (types.size() == 1) {
            return (ResolvedType)types.stream().findFirst().get();
        }
        throw new UnsupportedOperationException();
    }

    public static Pair<ResolvedType, Boolean> groundTargetTypeOfLambda(LambdaExpr lambdaExpr, ResolvedType T, TypeSolver typeSolver) {
        boolean used18_5_3 = false;
        boolean wildcardParameterized = T.asReferenceType().typeParametersValues().stream().anyMatch(tp -> tp.isWildcard());
        if (wildcardParameterized) {
            if (ExpressionHelper.isExplicitlyTyped(lambdaExpr)) {
                used18_5_3 = true;
                throw new UnsupportedOperationException();
            }
            return new Pair<ResolvedType, Boolean>(TypeHelper.nonWildcardParameterizationOf(T.asReferenceType(), typeSolver), used18_5_3);
        }
        return new Pair<ResolvedType, Boolean>(T, used18_5_3);
    }

    private static ResolvedReferenceType nonWildcardParameterizationOf(ResolvedReferenceType originalType, TypeSolver typeSolver) {
        LinkedList<ResolvedType> TIs = new LinkedList<ResolvedType>();
        List<ResolvedType> AIs = originalType.typeParametersValues();
        List<ResolvedTypeParameterDeclaration> TPs = originalType.getTypeDeclaration().getTypeParameters();
        ReferenceTypeImpl object = new ReferenceTypeImpl(typeSolver.solveType(Object.class.getCanonicalName()), typeSolver);
        for (int i = 0; i < AIs.size(); ++i) {
            ResolvedType Ai = AIs.get(i);
            ResolvedType Ti = null;
            if (!Ai.isWildcard()) {
                Ti = Ai;
            }
            if (Ti == null && Ai.isWildcard() && Ai.asWildcard().mention(originalType.getTypeDeclaration().getTypeParameters())) {
                throw new IllegalArgumentException();
            }
            if (Ti == null) {
                ReferenceTypeImpl Bi;
                ResolvedType resolvedType = Bi = TPs.get(i).hasLowerBound() ? TPs.get(i).getLowerBound() : object;
                if (Ai.isWildcard() && !Ai.asWildcard().isBounded()) {
                    Ti = Bi;
                } else if (Ai.isWildcard() && Ai.asWildcard().isUpperBounded()) {
                    ResolvedType Ui = Ai.asWildcard().getBoundedType();
                    Ti = TypeHelper.glb(new HashSet<ResolvedType>(Arrays.asList(Ui, Bi)));
                } else if (Ai.isWildcard() && Ai.asWildcard().isLowerBounded()) {
                    Ti = Ai.asWildcard().getBoundedType();
                } else {
                    throw new RuntimeException("This should not happen");
                }
            }
            TIs.add(Ti);
        }
        return new ReferenceTypeImpl(originalType.getTypeDeclaration(), TIs, typeSolver);
    }

    public static MethodType getFunctionType(ResolvedType type) {
        Optional<MethodUsage> mu = FunctionalInterfaceLogic.getFunctionalMethod(type);
        if (mu.isPresent()) {
            return MethodType.fromMethodUsage(mu.get());
        }
        throw new IllegalArgumentException();
    }

    public static ResolvedType glb(Set<ResolvedType> types) {
        if (types.size() == 0) {
            throw new IllegalArgumentException();
        }
        if (types.size() == 1) {
            return types.iterator().next();
        }
        return new ResolvedIntersectionType(types);
    }
}

