/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.typeinference.constraintformulas;

import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedType;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.model.resolution.TypeSolver;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.model.typesystem.ReferenceTypeImpl;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.typeinference.BoundSet;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.typeinference.ConstraintFormula;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.typeinference.TypeHelper;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.typeinference.constraintformulas.TypeSameAsType;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.typeinference.constraintformulas.TypeSubtypeOfType;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.typesolvers.ReflectionTypeSolver;

public class TypeCompatibleWithType
extends ConstraintFormula {
    private ResolvedType s;
    private ResolvedType t;
    private TypeSolver typeSolver;

    public TypeCompatibleWithType(TypeSolver typeSolver, ResolvedType s, ResolvedType t) {
        this.typeSolver = typeSolver;
        this.s = s;
        this.t = t;
    }

    @Override
    public ConstraintFormula.ReductionResult reduce(BoundSet currentBoundSet) {
        if (TypeHelper.isProperType(this.s) && TypeHelper.isProperType(this.t)) {
            if (TypeHelper.isCompatibleInALooseInvocationContext(this.s, this.t)) {
                return ConstraintFormula.ReductionResult.trueResult();
            }
            return ConstraintFormula.ReductionResult.falseResult();
        }
        if (this.s.isPrimitive()) {
            ReflectionTypeSolver typeSolver = new ReflectionTypeSolver();
            ReferenceTypeImpl sFirst = new ReferenceTypeImpl(typeSolver.solveType(this.s.asPrimitive().getBoxTypeQName()), typeSolver);
            return ConstraintFormula.ReductionResult.oneConstraint(new TypeCompatibleWithType(typeSolver, sFirst, this.t));
        }
        if (this.t.isPrimitive()) {
            ReflectionTypeSolver typeSolver = new ReflectionTypeSolver();
            ReferenceTypeImpl tFirst = new ReferenceTypeImpl(typeSolver.solveType(this.t.asPrimitive().getBoxTypeQName()), typeSolver);
            return ConstraintFormula.ReductionResult.oneConstraint(new TypeSameAsType(this.s, tFirst));
        }
        if (this.t.isReferenceType() && !this.t.asReferenceType().getTypeDeclaration().getTypeParameters().isEmpty()) {
            boolean condition1 = this.t.isAssignableBy(this.s);
            ResolvedType G = this.t.asReferenceType().toRawType();
            boolean condition2 = G.isAssignableBy(this.s);
            if (!condition1 && condition2) {
                return ConstraintFormula.ReductionResult.trueResult();
            }
        }
        if (this.t.isArray()) {
            throw new UnsupportedOperationException();
        }
        return ConstraintFormula.ReductionResult.empty().withConstraint(new TypeSubtypeOfType(this.typeSolver, this.s, this.t));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeCompatibleWithType that = (TypeCompatibleWithType)o;
        if (!this.s.equals(that.s)) {
            return false;
        }
        return this.t.equals(that.t);
    }

    public int hashCode() {
        int result = this.s.hashCode();
        result = 31 * result + this.t.hashCode();
        return result;
    }

    public String toString() {
        return "TypeCompatibleWithType{s=" + this.s + ", t=" + this.t + '}';
    }
}

