/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.typesolvers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.UnsolvedSymbolException;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistFactory;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.model.resolution.SymbolReference;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.model.resolution.TypeSolver;

public class JarTypeSolver
implements TypeSolver {
    private static JarTypeSolver instance;
    private TypeSolver parent;
    private Map<String, ClasspathElement> classpathElements = new HashMap<String, ClasspathElement>();
    private ClassPool classPool = new ClassPool(false);

    public JarTypeSolver(Path pathToJar) throws IOException {
        this(pathToJar.toFile());
    }

    public JarTypeSolver(File pathToJar) throws IOException {
        this(pathToJar.getCanonicalPath());
    }

    public JarTypeSolver(String pathToJar) throws IOException {
        this.addPathToJar(pathToJar);
    }

    public JarTypeSolver(InputStream jarInputStream) throws IOException {
        this.addPathToJar(jarInputStream);
    }

    public static JarTypeSolver getJarTypeSolver(String pathToJar) throws IOException {
        if (instance == null) {
            instance = new JarTypeSolver(pathToJar);
        } else {
            instance.addPathToJar(pathToJar);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File dumpToTempFile(InputStream inputStream) throws IOException {
        File tempFile = File.createTempFile("jar_file_from_input_stream", ".jar");
        tempFile.deleteOnExit();
        byte[] buffer = new byte[8192];
        try (FileOutputStream output = new FileOutputStream(tempFile);){
            int bytesRead;
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                ((OutputStream)output).write(buffer, 0, bytesRead);
            }
        }
        finally {
            inputStream.close();
        }
        return tempFile;
    }

    private void addPathToJar(InputStream jarInputStream) throws IOException {
        this.addPathToJar(this.dumpToTempFile(jarInputStream).getAbsolutePath());
    }

    private void addPathToJar(String pathToJar) throws IOException {
        try {
            this.classPool.appendClassPath(pathToJar);
            this.classPool.appendSystemPath();
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        JarFile jarFile = new JarFile(pathToJar);
        Enumeration<JarEntry> e = jarFile.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            if (entry == null || entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
            String name = this.entryPathToClassName(entry.getName());
            this.classpathElements.put(name, new ClasspathElement(jarFile, entry));
        }
    }

    @Override
    public TypeSolver getParent() {
        return this.parent;
    }

    @Override
    public void setParent(TypeSolver parent) {
        this.parent = parent;
    }

    private String entryPathToClassName(String entryPath) {
        if (!entryPath.endsWith(".class")) {
            throw new IllegalStateException();
        }
        String className = entryPath.substring(0, entryPath.length() - ".class".length());
        className = className.replace('/', '.');
        className = className.replace('$', '.');
        return className;
    }

    @Override
    public SymbolReference<ResolvedReferenceTypeDeclaration> tryToSolveType(String name) {
        try {
            if (this.classpathElements.containsKey(name)) {
                return SymbolReference.solved(JavassistFactory.toTypeDeclaration(this.classpathElements.get(name).toCtClass(), this.getRoot()));
            }
            return SymbolReference.unsolved(ResolvedReferenceTypeDeclaration.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ResolvedReferenceTypeDeclaration solveType(String name) throws UnsolvedSymbolException {
        SymbolReference<ResolvedReferenceTypeDeclaration> ref = this.tryToSolveType(name);
        if (ref.isSolved()) {
            return ref.getCorrespondingDeclaration();
        }
        throw new UnsolvedSymbolException(name);
    }

    private class ClasspathElement {
        private JarFile jarFile;
        private JarEntry entry;

        ClasspathElement(JarFile jarFile, JarEntry entry) {
            this.jarFile = jarFile;
            this.entry = entry;
        }

        CtClass toCtClass() throws IOException {
            try (InputStream is = this.jarFile.getInputStream(this.entry);){
                CtClass ctClass = JarTypeSolver.this.classPool.makeClass(is);
                return ctClass;
            }
        }
    }
}

